import 'package:flutter/material.dart';
import '../../../../../theme/colors.dart';
import '../../../../../theme/device_type.dart';
import '../../forgot_password/forgot_password.dart';
import '../../../../../utils/navigation/navigation.dart';

class ForgotPasswordLink extends StatelessWidget {
  /// Initialize
  const ForgotPasswordLink({super.key});

  @override
  Widget build(BuildContext context) {
    return Container(
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      alignment: Alignment.centerRight,
      child: GestureDetector(
        onTap: () {
          BNavigator().historyFadeNavigate(context, const ForgotPassword());
        },
        child: const Text(
          "Forgot Password?",
          style: TextStyle(color: secondaryColor, fontWeight: FontWeight.w600),
        ),
      ),
    );
  }
}
