import 'package:flutter/material.dart';
import '../../../../../theme/colors.dart';
import '../../../../../theme/device_type.dart';

class AppleButton extends StatelessWidget {
  /// Variables
  final Function loginFunc;

  /// Initialize
  const AppleButton({super.key, required this.loginFunc});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      alignment: Alignment.center,
      child: ElevatedButton(
        style: ElevatedButton.styleFrom(
            elevation: 0,
            backgroundColor: primaryColor,
            shape: RoundedRectangleBorder(
                side: BorderSide(
                  color: textColorLight.withOpacity(0.4),
                ),
                borderRadius: BorderRadius.circular(14.0))),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            /// Logo
            Container(
              margin: const EdgeInsets.only(right: 10.0),
              child: Image.asset(
                "assets/icons/apple.ico",
                height: 28.0,
              ),
            ),

            /// Text
            const Text(
              'Sign in with Apple',
              style: TextStyle(color: textColorDark),
            )
          ],
        ),
        onPressed: () {
          loginFunc();
        },
      ),
    );
  }
}
