import 'helpers/gradient.dart';
import '../sign_up/sign_up.dart';
import 'helpers/text_content.dart';
import '../../../../theme/colors.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'helpers/terms_and_privacy.dart';
import '../../../../datastore/sqlite/sqlite.dart';
import '../../../../utils/buttons/simple_button.dart';
import '../../../../utils/navigation/navigation.dart';

class AuthHome extends StatefulWidget {
  const AuthHome({super.key});

  @override
  State<AuthHome> createState() => _AuthHomeState();
}

class _AuthHomeState extends State<AuthHome> {
  /// Init
  @override
  void initState() {
    _initialize();
    super.initState();
  }

  /// Widget
  @override
  Widget build(BuildContext context) {
    return AnnotatedRegion<SystemUiOverlayStyle>(
      value: const SystemUiOverlayStyle(
          statusBarColor: Colors.transparent,
          statusBarBrightness: Brightness.dark,
          statusBarIconBrightness:Brightness.light),
      child: Scaffold(
        body: Container(
          decoration: const BoxDecoration(
              image: DecorationImage(
                  image: AssetImage("assets/vectors/hero.png"),
                  fit: BoxFit.cover)),
          child: Stack(
            children: [
              /// Gradient
              const Positioned.fill(child: BlackGradient()),

              /// Content
              Positioned.fill(
                child: SafeArea(
                  child: Padding(
                    padding: const EdgeInsets.all(20.0),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        /// Spacing
                        Expanded(child: Container()),
                        
                        /// Logo
                        Container(
                          width: 72,
                          height: 72,
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(16),
                            image: const DecorationImage(image: AssetImage("assets/logos/ios.png"))
                          ),
                        ),

                        /// Spacing
                        const SizedBox(
                          height: 44.0,
                        ),

                        /// Text Content
                        const TextContent(),

                        /// Spacing
                        const SizedBox(
                          height: 20.0,
                        ),

                        /// Get started button
                        SimpleButton(
                            text: "Get Started",
                            color: secondaryColor,
                            textColor: primaryColor,
                            isProcessing: false,
                            actionFunc: () {
                              _redirectToCreateAccount();
                            }),

                        /// Spacing
                        const SizedBox(height: 12.0),

                        /// Terms
                        const TermsAndPrivacy(),

                        /// Spacing
                        const SizedBox(height: 12.0),
                      ],
                    ),
                  ),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  /// Redirect to create account
  _redirectToCreateAccount() async {
    BNavigator().historyRightNavigate(context, const SignUp());
  }

  /// Initialize
  _initialize() async {
    await SqliteDB().createTables();
  }
}
