import 'package:flutter/material.dart';
import '../../../../../theme/colors.dart';
import '../../../../../theme/device_type.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:auto_size_text/auto_size_text.dart';


class TextContent extends StatelessWidget {
  const TextContent({super.key});

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        /// Display title
        Container(
          width: double.infinity,
          alignment: Device.screenWidth > 600.0
              ? Alignment.center
              : Alignment.centerLeft,
          child: AutoSizeText("Your Pathway to",
              textAlign: TextAlign.left,
              maxLines: 2,
              style: GoogleFonts.robotoCondensed(
                  textStyle: Theme.of(context).textTheme.displayMedium!.copyWith(
                      color: primaryColor,
                      height: 0.7
                  )
              )),
        ),

        /// Display title
        Container(
            width: double.infinity,
            alignment: Device.screenWidth > 600.0
                ? Alignment.center
                : Alignment.centerLeft,
            child: AutoSizeText("Success",
                textAlign: TextAlign.left,
                maxLines: 1,
                style: GoogleFonts.robotoCondensed(
                    textStyle: Theme.of(context).textTheme.displayMedium!.copyWith(
                        color: primaryColor,
                        height: 0
                    )
                ))
        ),

        /// Spacing
        SizedBox(
          height: Device.screenWidth > 600.0 ? 24 : 12.0,
        ),

        /// Sub title
        Container(
          width: double.infinity,
          alignment: Device.screenWidth > 600.0
              ? Alignment.center
              : Alignment.centerLeft,
          child: AutoSizeText(
              "We help busy professionals get back in shape,\nBecome fitter and feel healthy for life",
              textAlign: Device.screenWidth > 600.0
                  ? TextAlign.center
                  : TextAlign.left,
              maxLines: 2,
              style: Theme.of(context).textTheme.bodyLarge!.copyWith(
                  color: primaryColor, fontWeight: FontWeight.w600)),
        ),
      ],
    );
  }
}
