import 'package:flutter/material.dart';
import '../../../../../theme/colors.dart';
import '../../../../../configure/app_info.dart';
import '../../../../../utils/browser/browser.dart';
import '../../../../../utils/buttons/link_button.dart';

class TermsAndPrivacy extends StatelessWidget {
  const TermsAndPrivacy({super.key});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 20.0, vertical: 8.0),
      child: RichText(
          textAlign: TextAlign.center,
          text: TextSpan(
              style: Theme.of(context).textTheme.bodyMedium?.copyWith(
                    height: 1.5,
                    fontWeight: FontWeight.w600,
                  ),
              children: [
                /// Intro text
                const TextSpan(
                    style: TextStyle(fontWeight: FontWeight.w500, color: primaryColor),
                    text: "By continuing you agree to our "),

                /// Terms of services link
                LinkButtonWithAnimation(
                    style: const TextStyle(color: secondaryColor),
                    page: LinkBrowser(
                      url: AppInfo().terms,
                      text: "Terms of Services",
                    ),
                    text: "Terms of Services",
                    context: context),

                const TextSpan(
                    style: TextStyle(fontWeight: FontWeight.w500, color: primaryColor),
                    text: " and "),

                /// Privacy policy link
                LinkButtonWithAnimation(
                    style: const TextStyle(color: secondaryColor),
                    page: LinkBrowser(
                      url: AppInfo().privacy,
                      text: "Privacy Policy",
                    ),
                    text: "Privacy Policy",
                    context: context),
              ])),
    );
  }
}
