import 'package:flutter/material.dart';
import '../../../../../theme/colors.dart';

class SendEmailButton extends StatelessWidget {
  /// Variables
  final bool isProcessing;
  final double screenWidth;
  final Function actionFunc;

  /// Initialize
  const SendEmailButton(
      {super.key,
      required this.screenWidth,
      required this.actionFunc,
      required this.isProcessing});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: screenWidth > 600.0 ? 400.0 : double.infinity,
      height: 60.0,
      alignment: Alignment.center,
      child: isProcessing
          ? const Center(
              child: SizedBox(
                width: 24.0,
                height: 24.0,
                child: CircularProgressIndicator(
                  color: secondaryColor,
                ),
              ),
            )
          : Row(
              children: [
                Expanded(
                  child: ElevatedButton(
                    child: const Text(
                      'Send Reset Password Link',
                      style: TextStyle(),
                    ),
                    onPressed: () {
                      actionFunc();
                    },
                  ),
                ),
              ],
            ),
    );
  }
}
