import '../../login/login.dart';
import 'package:flutter/material.dart';
import '../../../../../utils/navigation/navigation.dart';

class BackToLoginButton extends StatelessWidget {
  /// Variables
  final double screenWidth;

  /// Initialize
  const BackToLoginButton({super.key, required this.screenWidth});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: screenWidth > 600.0 ? 400.0 : double.infinity,
      height: 60.0,
      alignment: Alignment.center,
      child: Row(
        children: [
          Expanded(
            child: ElevatedButton(
              child: const Text(
                'Back to Login',
                style: TextStyle(),
              ),
              onPressed: () {
                BNavigator().fadeNavigate(context, const Login());
              },
            ),
          ),
        ],
      ),
    );
  }
}
