import '../home/home.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import '../../../../theme/colors.dart';
import '../../../../theme/device_type.dart';
import '../../../../utils/alerts/snackbars.dart';
import 'package:firebase_auth/firebase_auth.dart';
import '../../../../utils/navigation/navigation.dart';
import '../forgot_password/helpers/back_to_login_button.dart';

class EmailSent extends StatefulWidget {
  /// Variable
  final String email;

  /// Initialize
  const EmailSent({super.key, required this.email});

  @override
  EmailSentState createState() => EmailSentState();
}

class EmailSentState extends State<EmailSent> {
  /// Variables
  int _count = 0;
  bool _processing = false;
  final FirebaseAuth _auth = FirebaseAuth.instance;
  final GlobalKey<ScaffoldState> _scaffoldState = GlobalKey();

  /// Widget
  @override
  Widget build(BuildContext context) {
    return AnnotatedRegion<SystemUiOverlayStyle>(
      value: SystemUiOverlayStyle(
          statusBarColor: Colors.transparent,
          statusBarBrightness: Theme.of(context).brightness ==
              Brightness.dark
              ?Brightness.dark:Brightness.light,
          statusBarIconBrightness: Theme.of(context).brightness ==
              Brightness.dark
              ?Brightness.light:Brightness.dark),
      child: Scaffold(
        key: _scaffoldState,
        appBar: AppBar(
          elevation: 0.0,
          leading: CloseButton(
            onPressed: () {
              BNavigator().fadeNavigate(context, const AuthHome());
            },
          ),
        ),
        body: Container(
            padding: const EdgeInsets.all(20.0),
            child: Column(
              children: [
                /// Image
                Container(
                  width: double.infinity,
                  height: Device.screenHeight / 4.0,
                  alignment: Alignment.center,
                  child: Image.asset(
                    "assets/vectors/email_sent.png",
                    fit: BoxFit.contain,
                  ),
                ),

                /// Spacing
                const SizedBox(height: 16,),

                /// Information
                RichText(
                    textAlign: TextAlign.center,
                    text: TextSpan(
                        style: Theme.of(context)
                            .textTheme
                            .bodyLarge
                            ?.copyWith(height: 1.4),
                        children: [
                          const TextSpan(text: "Email has been sent to"),
                          TextSpan(
                              text: "\n${widget.email}\n",
                              style: const TextStyle(color: secondaryColor)),
                          const TextSpan(
                              text:
                                  "Please check the email and follow the instructions to change the password"),
                        ])),

                /// Spacing
                const SizedBox(
                  height: 40.0,
                ),

                /// Instruction
                Text(
                  "Haven't got the email yet",
                  textAlign: TextAlign.center,
                  style: Theme.of(context).textTheme.bodyLarge,
                ),

                /// Resend Email
                TextButton(
                    onPressed: () {
                      _resendEmail();
                    },
                    child: const Text(
                      "Resend Email",
                      style: TextStyle(color: secondaryColor),
                    )),

                /// Spacing
                const SizedBox(
                  height: 20.0,
                ),

                /// Button
                BackToLoginButton(screenWidth: Device.screenWidth),

                /// Spacing
                const SizedBox(
                  height: 40.0,
                ),
              ],
            )),
      ),
    );
  }

  /// Resend email
  _resendEmail() async {
    if (_count == 0 && !_processing) {
      _processing = true;
      _count += 1;
      _auth.sendPasswordResetEmail(email: widget.email);
      PSnackbars().showSnackbar("Email send successfully", context);
      _processing = false;
    } else {
      _processing = true;
      await Future.delayed(const Duration(seconds: 3));
      if (mounted) {
        PSnackbars().showSnackbar("Email send successfully", context);
      }
      _processing = false;
    }
  }
}
