import "../model/model.dart";
import "../model/api_calls/social_login_api_calls.dart";

/// Contract class
abstract class SocialLoginContract {
  void onSocialLoginComplete(item);
}

/// Presenter class
class SocialLoginPresenter {
  /// Defines view and repository
  final SocialLoginContract? _view;
  SocialLoginApis? _repository;

  /// Initialize presenter
  SocialLoginPresenter(this._view) {
    _repository = SocialLoginApiCalls();
  }

  /// Login request
  void socialLogin(userInfo) {
    _repository!
        .socialLogin(userInfo)
        .then((i) => _view!.onSocialLoginComplete(i));
  }
}
