import "../model/model.dart";
import "../model/api_calls/logout_api_calls.dart";

/// Contract class
abstract class LogoutContract {
  void onLogoutComplete(item);
}

/// Presenter class
class LogoutPresenter {
  /// Defines view and repository
  final LogoutContract? _view;
  LogoutApis? _repository;

  /// Initialize presenter
  LogoutPresenter(this._view) {
    _repository = LogoutApiCalls();
  }

  /// Login request
  void logout() {
    _repository!.logout().then((i) => _view!.onLogoutComplete(i));
  }
}
