import "../model/model.dart";
import "../model/api_calls/email_register_api_calls.dart";

/// Contract class
abstract class EmailRegisterContract {
  void onRegisterComplete(item);
}

/// Presenter class
class EmailRegisterPresenter {
  /// Defines view and repository
  final EmailRegisterContract? _view;
  EmailRegisterApis? _repository;

  /// Initialize presenter
  EmailRegisterPresenter(this._view) {
    _repository = EmailRegisterApiCalls();
  }

  /// Register request
  void emailRegister(userInfo) {
    _repository!
        .emailRegister(userInfo)
        .then((i) => _view!.onRegisterComplete(i));
  }
}
