import "../model/model.dart";
import "../model/api_calls/email_login_api_calls.dart";

/// Contract class
abstract class EmailLoginContract {
  void onLoginComplete(item);
}

/// Presenter class
class EmailLoginPresenter {
  /// Defines view and repository
  final EmailLoginContract? _view;
  EmailLoginApis? _repository;

  /// Initialize presenter
  EmailLoginPresenter(this._view) {
    _repository = EmailLoginApiCalls();
  }

  /// Login request
  void emailLogin(userInfo) {
    _repository!.emailLogin(userInfo).then((i) => _view!.onLoginComplete(i));
  }
}
