import "../model/model.dart";
import "../model/api_calls/delete_account_api_calls.dart";

/// Contract class
abstract class DeleteAccountContract {
  void onDeleteAccountComplete(item);
}

/// Presenter class
class DeleteAccountPresenter {
  /// Defines view and repository
  final DeleteAccountContract? _view;
  DeleteAccountApis? _repository;

  /// Initialize presenter
  DeleteAccountPresenter(this._view) {
    _repository = DeleteAccountApiCalls();
  }

  /// Login request
  void deleteAccount() {
    _repository!.delete().then((i) => _view!.onDeleteAccountComplete(i));
  }
}
