import "../model.dart";
import "../../../../tasks/auth_tasks.dart";
import "../../../../datastore/sqlite/sq_user.dart";
import "../../../../datastore/data_objects/user.dart";
import "../../../../datastore/firestore/firestore_user.dart";

class SocialLoginApiCalls implements SocialLoginApis {
  /// Logs user in
  /// Arguments - [userInfo] : User Information JSON
  @override
  Future socialLogin(userInfo) async {
    /// Convert to user object
    final User user = User.fromMap(userInfo);

    /// Get user id
    final userId = user.id;

    /// Check if user exist
    final dbUser = await FireStoreUserDB().getUser(userId);

    /// Check if deleted
    final isDeleted = await FireStoreUserDB().checkDeleted(user.id);
    if (isDeleted) {
      return {"status": "failed"};
    }

    /// If exist
    if (dbUser['status'] == "success") {
      /// Add data to sqlite
      final User userObj = User.fromMap(dbUser['user']);
      final userJson = userObj.toMap();
      await SqUser().putUser(userJson);
      await AuthTasks().login(user.id);

      /// Return and later redirect based on level
      return {
        "status": "success",
        "level": userObj.level,
        "loginType": userInfo["loginType"]
      };
    }

    /// If user doesn't exist
    else {
      /// Add data to fire-store
      final userJson = user.toMap();
      final userObjectJson = user.toObjectMap();
      await FireStoreUserDB().addUser(userObjectJson);

      /// Create firestore doc for user
      AuthTasks().register(user.id);

      /// Add data to sqlite
      await SqUser().putUser(userJson);

      /// Return and later redirect based on level
      return {
        "status": "success",
        "level": user.level,
        "loginType": userInfo["loginType"]
      };
    }
  }
}
