import "../model.dart";
import "package:firebase_auth/firebase_auth.dart";
import "../../../../datastore/sqlite/sqlite.dart";
import "../../../../datastore/shared_pref/shared_pref.dart";

class LogoutApiCalls implements LogoutApis {
  @override
  Future logout() async {
    /// Reset data
    SqliteDB().deleteAll();
    SharedPref().reset();

    /// Sign out
    await FirebaseAuth.instance.signOut();

    /// Add table created
    /// so, it wont try to create again
    await SharedPref().put("tableCreated", "int", 1);

    /// Log event
    return {"status": "success"};
  }
}
