import "../model.dart";
import "../../../../tasks/auth_tasks.dart";
import "../../../../datastore/sqlite/sq_user.dart";
import "../../../../datastore/data_objects/user.dart";
import "../../../../datastore/firestore/firestore_user.dart";

class EmailRegisterApiCalls implements EmailRegisterApis {
  /// Register a user
  /// Arguments - [userInfo] : User Information JSON
  @override
  Future emailRegister(userInfo) async {
    /// Convert to user object
    final User user = User.fromMap(userInfo);

    /// Check if deleted
    final isDeleted = await FireStoreUserDB().checkDeleted(user.id);
    if (isDeleted) {
      return {"status": "failed"};
    }

    /// Add data to fire-store
    final userObjectJson = user.toObjectMap();
    await FireStoreUserDB().addUser(userObjectJson);

    /// Create firestore doc for user
    AuthTasks().register(user.id);

    /// Add data to sqlite
    final userJson = user.toMap();
    await SqUser().putUser(userJson);

    /// Return and later redirect based on level
    return {"status": "success", "level": user.level};
  }
}
