import "../model.dart";
import "../../../../tasks/auth_tasks.dart";
import "../../../../datastore/sqlite/sq_user.dart";
import "../../../../datastore/data_objects/user.dart";
import "../../../../datastore/firestore/firestore_user.dart";

class EmailLoginApiCalls implements EmailLoginApis {
  /// Logs user in
  /// Arguments - [userInfo] : User Information JSON
  @override
  Future emailLogin(userInfo) async {
    /// Convert to user object
    final User user = User.fromMap(userInfo);

    /// Get user id
    final userId = user.id;

    /// Check if user exist
    final dbUser = await FireStoreUserDB().getUser(userId);

    /// If exist
    if (dbUser['status'] == "success") {
      /// Add data to sqlite
      final User userObj = User.fromMap(dbUser["user"]);
      final userJson = userObj.toMap();
      await SqUser().putUser(userJson);
      await AuthTasks().login(user.id);

      /// Return and later redirect based on level
      return {"status": "success", "level": userObj.level};
    } else {
      return {"status": "failed"};
    }
  }
}
