import "../model.dart";
import '../../../../datastore/sqlite/sqlite.dart';
import '../../../../datastore/sqlite/sq_user.dart';
import '../../../../datastore/shared_pref/shared_pref.dart';
import '../../../../datastore/firestore/firestore_user.dart';

class DeleteAccountApiCalls implements DeleteAccountApis {
  @override
  Future delete() async {
    /// User ids
    final userInfo = await SqUser().fetchUserInfo();
    final user = userInfo[0];
    //final user = FirebaseAuth.instance.currentUser!;
    //user.delete();

    /// Delete user from postgres and firestore
    FireStoreUserDB().deleteUser(user);

    /// Reset data
    SqliteDB().deleteAll();
    SharedPref().reset();

    /// Add table created
    /// so, it wont try to create again
    await SharedPref().put("tableCreated", "int", 1);

    /// Return
    return {"status": "success"};
  }
}
