# AG2 - Changelog

## Version 2.7.1 (depuis v2.7.0)

### Améliorations majeures

**Refactorisation de l'architecture interne :**
- Ajout d'un système de filtrage pour les formes (interface IShapeFilter) pour améliorer la modularité
- Implémentation d'un cache pour les formes et leurs dépendances dans ObjectsList
- Centralisation des méthodes utilitaires dans le module OperationHelpers
- Harmonisation et amélioration de la méthode GetShape dans plusieurs classes

**Robustesse et gestion des erreurs :**
- Renforcement des vérifications de sécurité dans les opérations critiques (Modifier, Flecher, Pointer, Tracer)
- Amélioration de la validation des paramètres dans FigsList
- Meilleure gestion des exceptions et codes d'erreur
- Corrections du système de gestion des intersections et des points

**Optimisations de performance :**
- Réduction de la duplication de code
- Optimisation des redimensionnements de tableaux (classe BiBPoint)
- Amélioration de la gestion des propriétés 'createTrace' et 'tracept'
- Meilleure lisibilité et maintenabilité globale

### Corrections de bugs

- Correction de computeintercercles : vérification des bornes avant assignation
- Correction de GetRealId : gestion de l'ID manquant
- Harmonisation de Prolonger : corrections de logique et renommages
- Amélioration du test de prolongation pour les Lacet
- Corrections du système de traçage des points
- Optimisations du chargement des formes
- Corrections d'affichage et d'intersection

### Nouvelles méthodes

- UpdatePointSurPosition dans la classe Point pour gérer la mise à jour des points selon leur position
- FilterVisibleByChoixValide dans OperationHelpers pour centraliser la validation des choix

### Compatibilité

- Correction de compatibilité Linux avec lisoup3
- Optimisation et nettoyage du code pour meilleure compatibilité multiplateforme


