<?php
/**
 * Fichier de désinstallation du plugin Fliz Video Generator
 *
 * Ce fichier est exécuté lors de la suppression du plugin depuis l'admin WordPress.
 * Il supprime toutes les données créées par le plugin.
 *
 * @package Fliz_Video_Generator
 */

// Vérifier que c'est une vraie désinstallation WordPress
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Supprimer les options
delete_option( 'fliz_settings' );
delete_option( 'fliz_db_version' );

// Supprimer les post meta
global $wpdb;

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query( "DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_fliz_%'" );

// Supprimer la table des logs
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}fliz_video_logs" );

// Nettoyer les tâches cron
wp_clear_scheduled_hook( 'fliz_check_pending_videos' );
