<?php
/**
 * Classe Fliz_Public
 *
 * Gère les fonctionnalités publiques du plugin.
 *
 * @package Fliz_Video_Generator
 */

// Empêcher l'accès direct
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Classe Fliz_Public
 */
class Fliz_Public {

	/**
     * Charger les styles frontend
	 */
	public function enqueue_styles() {
        // Vérifier si on est sur un post avec un shortcode Fliz
        if ( ! is_singular() ) {
			return;
		}

        global $post;
        if ( ! $post || false === strpos( $post->post_content, '[fliz_video' ) ) {
            // Vérifier aussi les post meta
            $video_id = get_post_meta( $post->ID, '_fliz_video_id', true );
            if ( empty( $video_id ) ) {
                return;
            }
        }

		wp_enqueue_style(
			'fliz-video',
			FLIZ_PLUGIN_URL . 'public/css/fliz-video.css',
			array(),
			FLIZ_VERSION
		);
	}

	/**
     * Charger les scripts frontend
	 */
	public function enqueue_scripts() {
        // Vérifier si on est sur un post avec un shortcode Fliz
        if ( ! is_singular() ) {
			return;
		}

        global $post;
        if ( ! $post || false === strpos( $post->post_content, '[fliz_video' ) ) {
            // Vérifier aussi les post meta
            $video_id = get_post_meta( $post->ID, '_fliz_video_id', true );
            if ( empty( $video_id ) ) {
                return;
            }
        }

		wp_enqueue_script(
			'fliz-video',
			FLIZ_PLUGIN_URL . 'public/js/fliz-video.js',
			array( 'jquery' ),
			FLIZ_VERSION,
			true
		);

		wp_localize_script(
			'fliz-video',
			'flizVideo',
			array(
				'ajaxUrl' => admin_url( 'admin-ajax.php' ),
				'nonce'   => wp_create_nonce( 'fliz_video_nonce' ),
			)
		);
	}
}
