<?php
/**
 * Classe Fliz_Loader
 *
 * Enregistre toutes les actions et filtres du plugin.
 *
 * @package Fliz_Video_Generator
 */

// Empêcher l'accès direct
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Classe Fliz_Loader
 *
 * Gère l'enregistrement des hooks WordPress.
 */
class Fliz_Loader {

	/**
     * Actions enregistrées
	 *
	 * @var array
	 */
	protected $actions;

	/**
     * Filtres enregistrés
	 *
	 * @var array
	 */
	protected $filters;

	/**
     * Constructeur
	 */
	public function __construct() {
		$this->actions = array();
		$this->filters = array();
	}

	/**
     * Ajouter une action
	 *
	 * @param string $hook          Nom du hook WordPress.
     * @param object $component     Référence à l'instance de l'objet.
     * @param string $callback      Nom de la méthode callback.
     * @param int    $priority      Priorité (optionnel).
     * @param int    $accepted_args Nombre d'arguments (optionnel).
	 */
	public function add_action( $hook, $component, $callback, $priority = 10, $accepted_args = 1 ) {
		$this->actions = $this->add( $this->actions, $hook, $component, $callback, $priority, $accepted_args );
	}

	/**
     * Ajouter un filtre
	 *
	 * @param string $hook          Nom du hook WordPress.
     * @param object $component     Référence à l'instance de l'objet.
     * @param string $callback      Nom de la méthode callback.
     * @param int    $priority      Priorité (optionnel).
     * @param int    $accepted_args Nombre d'arguments (optionnel).
	 */
	public function add_filter( $hook, $component, $callback, $priority = 10, $accepted_args = 1 ) {
		$this->filters = $this->add( $this->filters, $hook, $component, $callback, $priority, $accepted_args );
	}

	/**
     * Utilitaire pour enregistrer actions et filtres
	 *
     * @param array  $hooks         Collection de hooks existants.
     * @param string $hook          Nom du hook WordPress.
     * @param object $component     Référence à l'instance de l'objet.
     * @param string $callback      Nom de la méthode callback.
	 * @param int    $priority      Priorité.
	 * @param int    $accepted_args Nombre d'arguments.
     * @return array Collection mise à jour.
	 */
	private function add( $hooks, $hook, $component, $callback, $priority, $accepted_args ) {
		$hooks[] = array(
			'hook'          => $hook,
			'component'     => $component,
			'callback'      => $callback,
			'priority'      => $priority,
			'accepted_args' => $accepted_args,
		);

		return $hooks;
	}

	/**
     * Enregistrer les filtres et actions avec WordPress
	 */
	public function run() {
		foreach ( $this->filters as $hook ) {
			add_filter(
				$hook['hook'],
				array( $hook['component'], $hook['callback'] ),
				$hook['priority'],
				$hook['accepted_args']
			);
		}

		foreach ( $this->actions as $hook ) {
			add_action(
				$hook['hook'],
				array( $hook['component'], $hook['callback'] ),
				$hook['priority'],
				$hook['accepted_args']
			);
		}
	}
}
