<?php
/**
 * Classe Fliz_I18n
 *
 * Gère l'internationalisation du plugin.
 *
 * Note: Depuis WordPress 4.6, load_plugin_textdomain() n'est plus nécessaire
 * pour les plugins hébergés sur WordPress.org. WordPress charge automatiquement
 * les traductions basées sur le text domain du plugin.
 *
 * @package Fliz_Video_Generator
 * @since   2.0.0
 */

// Empêcher l'accès direct.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Classe Fliz_I18n
 */
class Fliz_I18n {

	/**
	 * Initialiser l'internationalisation.
	 *
	 * Note: Cette méthode est conservée pour compatibilité mais n'effectue
	 * plus d'action car WordPress charge automatiquement les traductions.
	 */
	public function load_plugin_textdomain() {
		// WordPress 4.6+ charge automatiquement les traductions pour les plugins
		// hébergés sur WordPress.org. Cette méthode est conservée pour compatibilité.
	}
}
