<?php
/**
 * Classe Fliz_Activator
 *
 * Actions exécutées à l'activation du plugin.
 *
 * @package Fliz_Video_Generator
 */

// Empêcher l'accès direct
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Classe Fliz_Activator
 */
class Fliz_Activator {

	/**
     * Actions à l'activation
	 */
	public static function activate() {
		self::create_tables();
		self::set_default_options();
	}

	/**
     * Créer les tables nécessaires
	 */
	private static function create_tables() {
		global $wpdb;

		$charset_collate = $wpdb->get_charset_collate();
		$table_name      = $wpdb->prefix . 'fliz_video_logs';

		$sql = "CREATE TABLE $table_name (
			id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
			post_id bigint(20) unsigned NOT NULL,
			video_id varchar(36) NOT NULL DEFAULT '',
			status varchar(50) NOT NULL DEFAULT 'pending',
			message text,
			created_at datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
			updated_at datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
			PRIMARY KEY  (id),
			KEY post_id (post_id),
			KEY video_id (video_id),
			KEY status (status)
		) $charset_collate;";

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta( $sql );

        // Stocker la version de la BDD
		update_option( 'fliz_db_version', '1.0.0' );
	}

	/**
     * Options par défaut
	 */
	private static function set_default_options() {
		$defaults = array(
			'api_key'                   => '',
			'default_format'            => 'size_16_9',
			'default_category'          => 'article',
			'default_lang'              => 'en',
			'default_script_style'      => 'news_social_media_style',
			'default_image_style'       => 'hyperrealistic',
			'default_voice_id'          => '',
			'default_is_male_voice'     => false,
			'default_music_id'          => '',
			'default_music_volume'      => 15,
			'default_caption_style'     => 'animated_background',
			'default_caption_position'  => 'bottom',
			'default_caption_font'      => 'poppins',
			'default_caption_color'     => '#FFFFFF',
			'default_caption_uppercase' => false,
			'watermark_url'             => '',
			'auto_generate'             => false,
			'is_automatic'              => true,
		);

		if ( false === get_option( 'fliz_settings' ) ) {
			add_option( 'fliz_settings', $defaults );
		}
	}
}
