<?php
/**
 * Template de la page de réglages
 *
 * @package Fliz_Video_Generator
 */

// Empêcher l'accès direct
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap fliz-settings-wrap">
    <h1 class="fliz-page-title">
        <span class="fliz-logo-icon">
            <?php Fliz_Settings::echo_menu_icon_svg(); ?>
        </span>
        <?php esc_html_e( 'Fliz Video Generator', 'fliz-video-generator' ); ?>
        <span class="fliz-version"><?php echo esc_html( 'v' . FLIZ_VERSION ); ?></span>
    </h1>

    <?php settings_errors(); ?>

    <div class="fliz-settings-container">
        <form method="post" action="options.php" class="fliz-settings-form">
            <?php
            settings_fields( 'fliz_options_group' );
            do_settings_sections( 'fliz-settings' );
            submit_button( __( 'Save Changes', 'fliz-video-generator' ) );
            ?>
        </form>

        <div class="fliz-settings-sidebar">
            <div class="fliz-sidebar-card">
                <h3><?php esc_html_e( 'Need Help?', 'fliz-video-generator' ); ?></h3>
                <p><?php esc_html_e( 'Check out our documentation for detailed instructions.', 'fliz-video-generator' ); ?></p>
                <a href="https://fliz.ai/faq" target="_blank" rel="noopener noreferrer" class="button">
                    <?php esc_html_e( 'View Documentation', 'fliz-video-generator' ); ?>
                </a>
            </div>

            <div class="fliz-sidebar-card">
                <h3><?php esc_html_e( 'Get Your API Key', 'fliz-video-generator' ); ?></h3>
                <p><?php esc_html_e( 'Sign up for a Fliz account to get your API key.', 'fliz-video-generator' ); ?></p>
                <a href="https://app.fliz.ai/api-keys" target="_blank" rel="noopener noreferrer" class="button button-primary">
                    <?php esc_html_e( 'Get API Key', 'fliz-video-generator' ); ?>
                </a>
            </div>

            <div class="fliz-sidebar-card">
                <h3><?php esc_html_e( 'Support', 'fliz-video-generator' ); ?></h3>
                <p><?php esc_html_e( 'Having issues? Contact our support team.', 'fliz-video-generator' ); ?></p>
                <a href="https://fliz.ai/contact" target="_blank" rel="noopener noreferrer" class="button">
                    <?php esc_html_e( 'Contact Support', 'fliz-video-generator' ); ?>
                </a>
            </div>
        </div>
    </div>
</div>
