<?php
/**
 * Template de la page Bulk Generator
 *
 * @package Fliz_Video_Generator
 */

// Empêcher l'accès direct
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$fliz_counts     = Fliz_Bulk_Generator::get_counts();
$fliz_categories = get_categories( array( 'hide_empty' => false ) );
$fliz_enums      = Fliz_API_Client::get_enums();
$fliz_options    = get_option( 'fliz_settings', array() );
?>
<div class="wrap fliz-bulk-wrap">
    <h1 class="fliz-page-title">
        <span class="fliz-logo-icon">
            <?php Fliz_Settings::echo_menu_icon_svg(); ?>
        </span>
        <?php esc_html_e( 'Bulk Video Generator', 'fliz-video-generator' ); ?>
    </h1>

    <!-- Filtres de statut -->
    <ul class="subsubsub fliz-status-filters">
        <li>
            <a href="#" class="fliz-filter-link current" data-filter="all">
                <?php esc_html_e( 'All', 'fliz-video-generator' ); ?>
                <span class="count">(<?php echo esc_html( $fliz_counts['total'] ); ?>)</span>
            </a> |
        </li>
        <li>
            <a href="#" class="fliz-filter-link" data-filter="without_video">
                <?php esc_html_e( 'Without Video', 'fliz-video-generator' ); ?>
                <span class="count">(<?php echo esc_html( $fliz_counts['without_video'] ); ?>)</span>
            </a> |
        </li>
        <li>
            <a href="#" class="fliz-filter-link" data-filter="with_video">
                <?php esc_html_e( 'With Video', 'fliz-video-generator' ); ?>
                <span class="count">(<?php echo esc_html( $fliz_counts['with_video'] ); ?>)</span>
            </a>
        </li>
    </ul>

    <!-- Filtres avancés -->
    <div class="fliz-filters-bar tablenav top">
        <div class="alignleft actions">
            <select id="fliz-filter-category">
                <option value="0"><?php esc_html_e( 'All Categories', 'fliz-video-generator' ); ?></option>
                <?php foreach ( $fliz_categories as $fliz_category ) : ?>
                    <option value="<?php echo esc_attr( $fliz_category->term_id ); ?>">
                        <?php echo esc_html( $fliz_category->name ); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button type="button" class="button" id="fliz-apply-filters">
                <?php esc_html_e( 'Filter', 'fliz-video-generator' ); ?>
            </button>
        </div>
        <div class="alignright">
            <input type="search" id="fliz-search-posts" placeholder="<?php esc_attr_e( 'Search posts...', 'fliz-video-generator' ); ?>" />
        </div>
    </div>

    <!-- Tableau des posts -->
    <table class="wp-list-table widefat fixed striped fliz-posts-table">
        <thead>
            <tr>
                <td class="manage-column column-cb check-column">
                    <input type="checkbox" id="fliz-select-all" />
                </td>
                <th class="manage-column column-title"><?php esc_html_e( 'Title', 'fliz-video-generator' ); ?></th>
                <th class="manage-column column-author"><?php esc_html_e( 'Author', 'fliz-video-generator' ); ?></th>
                <th class="manage-column column-categories"><?php esc_html_e( 'Categories', 'fliz-video-generator' ); ?></th>
                <th class="manage-column column-video"><?php esc_html_e( 'Video', 'fliz-video-generator' ); ?></th>
                <th class="manage-column column-date"><?php esc_html_e( 'Date', 'fliz-video-generator' ); ?></th>
            </tr>
        </thead>
        <tbody id="fliz-posts-list">
            <tr class="fliz-loading-row">
                <td colspan="6">
                    <div class="fliz-spinner"></div>
                    <span><?php esc_html_e( 'Loading posts...', 'fliz-video-generator' ); ?></span>
                </td>
            </tr>
        </tbody>
        <tfoot>
            <tr>
                <td class="manage-column column-cb check-column">
                    <input type="checkbox" id="fliz-select-all-bottom" />
                </td>
                <th class="manage-column column-title"><?php esc_html_e( 'Title', 'fliz-video-generator' ); ?></th>
                <th class="manage-column column-author"><?php esc_html_e( 'Author', 'fliz-video-generator' ); ?></th>
                <th class="manage-column column-categories"><?php esc_html_e( 'Categories', 'fliz-video-generator' ); ?></th>
                <th class="manage-column column-video"><?php esc_html_e( 'Video', 'fliz-video-generator' ); ?></th>
                <th class="manage-column column-date"><?php esc_html_e( 'Date', 'fliz-video-generator' ); ?></th>
            </tr>
        </tfoot>
    </table>

    <!-- Pagination -->
    <div class="tablenav bottom">
        <div class="tablenav-pages" id="fliz-pagination">
            <span class="displaying-num"></span>
            <span class="pagination-links"></span>
        </div>
    </div>

    <!-- Actions en masse -->
    <div class="fliz-bulk-actions">
        <span class="fliz-selected-count">
            <?php esc_html_e( 'Selected:', 'fliz-video-generator' ); ?>
            <strong id="fliz-selected-count">0</strong>
        </span>
        <button type="button" class="button button-primary button-large" id="fliz-bulk-generate-btn" disabled>
            <span class="dashicons dashicons-video-alt3"></span>
            <?php esc_html_e( 'Generate Videos', 'fliz-video-generator' ); ?>
        </button>
    </div>

    <!-- Modal de configuration -->
    <div id="fliz-bulk-modal" class="fliz-modal" style="display: none;">
        <div class="fliz-modal-content">
            <div class="fliz-modal-header">
                <h2><?php esc_html_e( 'Generate Videos', 'fliz-video-generator' ); ?></h2>
                <button type="button" class="fliz-modal-close">&times;</button>
            </div>
            <div class="fliz-modal-body">
                <p class="fliz-modal-info">
                    <?php esc_html_e( 'You are about to generate videos for', 'fliz-video-generator' ); ?>
                    <strong id="fliz-modal-count">0</strong>
                    <?php esc_html_e( 'posts.', 'fliz-video-generator' ); ?>
                </p>

                <div class="fliz-field">
                    <label class="fliz-field-label"><?php esc_html_e( 'Format', 'fliz-video-generator' ); ?></label>
                    <div class="fliz-format-selector">
                        <?php
                        $fliz_default_format = isset( $fliz_options['default_format'] ) ? $fliz_options['default_format'] : 'size_16_9';
                        foreach ( $fliz_enums['formats'] as $fliz_format_value => $fliz_format_label ) :
                            ?>
                            <label class="fliz-format-option">
                                <input 
                                    type="radio" 
                                    name="fliz_bulk_format" 
                                    value="<?php echo esc_attr( $fliz_format_value ); ?>"
                                    <?php checked( $fliz_default_format, $fliz_format_value ); ?>
                                />
                                <span class="fliz-format-btn"><?php echo esc_html( $fliz_format_label ); ?></span>
                            </label>
                        <?php endforeach; ?>
                    </div>
                </div>

            </div>
            <div class="fliz-modal-footer">
                <button type="button" class="button fliz-modal-cancel">
                    <?php esc_html_e( 'Cancel', 'fliz-video-generator' ); ?>
                </button>
                <button type="button" class="button button-primary" id="fliz-confirm-generate">
                    <?php esc_html_e( 'Generate', 'fliz-video-generator' ); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Overlay de progression -->
    <div id="fliz-progress-overlay" class="fliz-overlay" style="display: none;">
        <div class="fliz-progress-content">
            <div class="fliz-spinner"></div>
            <h3><?php esc_html_e( 'Generating Videos...', 'fliz-video-generator' ); ?></h3>
            <p id="fliz-progress-text"><?php esc_html_e( 'Please wait...', 'fliz-video-generator' ); ?></p>
            <div class="fliz-progress-bar">
                <div class="fliz-progress-fill" id="fliz-progress-fill" style="width: 0%;"></div>
            </div>
            <p class="fliz-progress-count">
                <span id="fliz-progress-current">0</span> / <span id="fliz-progress-total">0</span>
            </p>
        </div>
    </div>
</div>
