<?php
/**
 * Classe Fliz_Admin
 *
 * Gère les fonctionnalités admin du plugin.
 *
 * @package Fliz_Video_Generator
 */

// Empêcher l'accès direct
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Classe Fliz_Admin
 */
class Fliz_Admin {

    /**
     * Charger les styles admin
     *
     * @param string $hook Page courante.
     */
    public function enqueue_styles( $hook ) {
        // Style commun admin
        wp_enqueue_style(
            'fliz-admin',
            FLIZ_PLUGIN_URL . 'admin/css/fliz-admin.css',
            array(),
            FLIZ_VERSION
        );

        // Styles spécifiques selon la page
        if ( strpos( $hook, 'fliz' ) !== false ) {
            wp_enqueue_style(
                'fliz-settings',
                FLIZ_PLUGIN_URL . 'admin/css/fliz-settings.css',
                array( 'fliz-admin' ),
                FLIZ_VERSION
            );
        }

        // Style metabox sur les pages d'édition d'article
        if ( in_array( $hook, array( 'post.php', 'post-new.php' ), true ) ) {
            wp_enqueue_style(
                'fliz-metabox',
                FLIZ_PLUGIN_URL . 'admin/css/fliz-metabox.css',
                array( 'fliz-admin' ),
                FLIZ_VERSION
            );
        }

        // Style bulk generator
        if ( strpos( $hook, 'fliz-bulk' ) !== false ) {
            wp_enqueue_style(
                'fliz-bulk',
                FLIZ_PLUGIN_URL . 'admin/css/fliz-bulk.css',
                array( 'fliz-admin' ),
                FLIZ_VERSION
            );
        }
    }

    /**
     * Charger les scripts admin
     *
     * @param string $hook Page courante.
     */
    public function enqueue_scripts( $hook ) {
        // Script commun
        wp_enqueue_script(
            'fliz-admin',
            FLIZ_PLUGIN_URL . 'admin/js/fliz-admin.js',
            array( 'jquery' ),
            FLIZ_VERSION,
            true
        );

        // Scripts spécifiques selon la page
        $is_fliz_page = ( strpos( $hook, 'fliz' ) !== false );
        
        if ( $is_fliz_page ) {
            // Inclure le media uploader pour toutes les pages Fliz
            wp_enqueue_media();

            wp_enqueue_script(
                'fliz-settings',
                FLIZ_PLUGIN_URL . 'admin/js/fliz-settings.js',
                array( 'jquery', 'fliz-admin', 'wp-color-picker', 'media-upload' ),
                FLIZ_VERSION,
                true
            );

            wp_enqueue_style( 'wp-color-picker' );

            wp_localize_script(
                'fliz-settings',
                'flizSettings',
                array(
                    'ajaxUrl' => admin_url( 'admin-ajax.php' ),
                    'nonce'   => wp_create_nonce( 'fliz_settings_nonce' ),
                    'strings' => array(
                        'testing'      => __( 'Testing connection...', 'fliz-video-generator' ),
                        'success'      => __( 'Connection successful!', 'fliz-video-generator' ),
                        'error'        => __( 'Connection failed.', 'fliz-video-generator' ),
                        'saving'       => __( 'Saving...', 'fliz-video-generator' ),
                        'saved'        => __( 'Settings saved!', 'fliz-video-generator' ),
                        'refreshing'   => __( 'Refreshing options...', 'fliz-video-generator' ),
                        'refreshed'    => __( 'Options refreshed!', 'fliz-video-generator' ),
                        'confirmReset' => __( 'Are you sure you want to reset all settings?', 'fliz-video-generator' ),
                        'selectImage'  => __( 'Select Watermark Image', 'fliz-video-generator' ),
                        'useImage'     => __( 'Use this image', 'fliz-video-generator' ),
                        'noImage'      => __( 'No image selected', 'fliz-video-generator' ),
                    ),
                )
            );
        }

        // Script metabox
        if ( in_array( $hook, array( 'post.php', 'post-new.php' ), true ) ) {
            $screen = get_current_screen();
            $supported_post_types = apply_filters( 'fliz_supported_post_types', array( 'post' ) );

            if ( $screen && in_array( $screen->post_type, $supported_post_types, true ) ) {
                // Récupérer l'ID du post de manière fiable
                $post_id = get_the_ID();
                if ( ! $post_id ) {
                    global $post;
                    $post_id = $post ? $post->ID : 0;
                }

                wp_enqueue_script(
                    'fliz-metabox',
                    FLIZ_PLUGIN_URL . 'admin/js/fliz-metabox.js',
                    array( 'jquery', 'fliz-admin' ),
                    FLIZ_VERSION,
                    true
                );

                wp_localize_script(
                    'fliz-metabox',
                    'flizMetabox',
                    array(
                        'ajaxUrl' => admin_url( 'admin-ajax.php' ),
                        'nonce'   => wp_create_nonce( 'fliz_metabox_ajax' ),
                        'postId'  => $post_id,
                        'strings' => array(
                            'generating'  => __( 'Generating video...', 'fliz-video-generator' ),
                            'checking'    => __( 'Checking status...', 'fliz-video-generator' ),
                            'error'       => __( 'An error occurred. Please try again.', 'fliz-video-generator' ),
                            'timeout'     => __( 'Request timed out. The server may be busy. Please try again.', 'fliz-video-generator' ),
                            'copySuccess' => __( 'Shortcode copied!', 'fliz-video-generator' ),
                            'retry'       => __( 'Retry', 'fliz-video-generator' ),
                            'complete'    => __( 'Video ready!', 'fliz-video-generator' ),
                            'saveFirst'   => __( 'Please save the post first before generating a video.', 'fliz-video-generator' ),
                            'configure'   => __( 'Configure Fliz', 'fliz-video-generator' ),
                        ),
                    )
                );
            }
        }

        // Script bulk generator
        if ( strpos( $hook, 'fliz-bulk' ) !== false ) {
            wp_enqueue_script(
                'fliz-bulk',
                FLIZ_PLUGIN_URL . 'admin/js/fliz-bulk.js',
                array( 'jquery', 'fliz-admin' ),
                FLIZ_VERSION,
                true
            );

            wp_localize_script(
                'fliz-bulk',
                'flizBulk',
                array(
                    'ajaxUrl' => admin_url( 'admin-ajax.php' ),
                    'nonce'   => wp_create_nonce( 'fliz_bulk_nonce' ),
                    'strings' => array(
                        'confirmGenerate' => __( 'Are you sure you want to generate videos for the selected posts?', 'fliz-video-generator' ),
                        'generating'      => __( 'Generating...', 'fliz-video-generator' ),
                        'complete'        => __( 'Generation complete!', 'fliz-video-generator' ),
                        'error'           => __( 'An error occurred.', 'fliz-video-generator' ),
                        'noSelection'     => __( 'Please select at least one post.', 'fliz-video-generator' ),
                    ),
                )
            );
        }
    }
}
