<?php
/**
 * Plugin Name:       Fliz Video Generator
 * Plugin URI:        https://fliz.ai/wordpress
 * Description:       Generate AI-powered videos from your blog posts with Fliz. Transform any article into engaging video content in seconds.
 * Version:           2.0.0
 * Requires at least: 5.8
 * Requires PHP:      7.4
 * Author:            Fliz.ai
 * Author URI:        https://fliz.ai
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       fliz-video-generator
 * Domain Path:       /languages
 *
 * @package Fliz_Video_Generator
 */

// Empêcher l'accès direct
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Définir les constantes du plugin
define( 'FLIZ_VERSION', '2.0.0' );
define( 'FLIZ_PLUGIN_FILE', __FILE__ );
define( 'FLIZ_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'FLIZ_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'FLIZ_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Code à exécuter à l'activation du plugin.
 */
function fliz_activate() {
require_once FLIZ_PLUGIN_PATH . 'includes/class-fliz-activator.php';
    Fliz_Activator::activate();
}
register_activation_hook( __FILE__, 'fliz_activate' );

/**
 * Code à exécuter à la désactivation du plugin.
 */
function fliz_deactivate() {
require_once FLIZ_PLUGIN_PATH . 'includes/class-fliz-deactivator.php';
    Fliz_Deactivator::deactivate();
}
register_deactivation_hook( __FILE__, 'fliz_deactivate' );

/**
 * Classe principale du plugin
 *
 * Note: load_plugin_textdomain() n'est plus nécessaire depuis WordPress 4.6
 * pour les plugins hébergés sur WordPress.org. WordPress charge automatiquement
 * les traductions.
 */
class Fliz_Video_Generator {

	/**
     * Instance unique
	 *
	 * @var Fliz_Video_Generator|null
	 */
	private static $instance = null;

	/**
     * Loader pour les hooks
	 *
	 * @var Fliz_Loader
	 */
	protected $loader;

	/**
     * Obtenir l'instance unique
	 *
	 * @return Fliz_Video_Generator
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
     * Constructeur privé
	 */
	private function __construct() {
        $this->load_dependencies();
		$this->define_admin_hooks();
		$this->define_public_hooks();
	}

	/**
     * Charger les dépendances
	 */
    private function load_dependencies() {
        // Core
        require_once FLIZ_PLUGIN_PATH . 'includes/class-fliz-loader.php';
        require_once FLIZ_PLUGIN_PATH . 'includes/class-fliz-logger.php';

        // API
        require_once FLIZ_PLUGIN_PATH . 'includes/api/class-fliz-api-client.php';

        // Admin
        require_once FLIZ_PLUGIN_PATH . 'includes/admin/class-fliz-admin.php';
        require_once FLIZ_PLUGIN_PATH . 'includes/admin/class-fliz-settings.php';
        require_once FLIZ_PLUGIN_PATH . 'includes/admin/class-fliz-metabox.php';
        require_once FLIZ_PLUGIN_PATH . 'includes/admin/class-fliz-bulk-generator.php';
        require_once FLIZ_PLUGIN_PATH . 'includes/admin/class-fliz-logs.php';
        require_once FLIZ_PLUGIN_PATH . 'includes/admin/class-fliz-auto-generator.php';

        // Public
        require_once FLIZ_PLUGIN_PATH . 'includes/public/class-fliz-public.php';
        require_once FLIZ_PLUGIN_PATH . 'includes/public/class-fliz-shortcode.php';

        $this->loader = new Fliz_Loader();
	}

	/**
     * Définir les hooks admin
	 */
	private function define_admin_hooks() {
		$admin = new Fliz_Admin();
		$this->loader->add_action( 'admin_enqueue_scripts', $admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $admin, 'enqueue_scripts' );

		$settings = new Fliz_Settings();
		$settings->init();

		$metabox = new Fliz_Metabox();
		$metabox->init();

        $bulk_generator = new Fliz_Bulk_Generator();
        $bulk_generator->init();

		$logs = new Fliz_Logs();
		$logs->init();

		$auto_generator = new Fliz_Auto_Generator();
		$auto_generator->init();
	}

	/**
     * Définir les hooks public
	 */
	private function define_public_hooks() {
		$public = new Fliz_Public();
		$this->loader->add_action( 'wp_enqueue_scripts', $public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $public, 'enqueue_scripts' );

		$shortcode = new Fliz_Shortcode();
		$shortcode->init();
	}

	/**
     * Exécuter le plugin
	 */
	public function run() {
		$this->loader->run();
	}
}

/**
 * Démarrer le plugin
 */
function fliz_run() {
    $plugin = Fliz_Video_Generator::get_instance();
    $plugin->run();
}
add_action( 'plugins_loaded', 'fliz_run', 20 );
