/**
 * Fliz Video Generator - Scripts Admin Communs
 *
 * @package Fliz_Video_Generator
 */

/* global jQuery */

(function($) {
    'use strict';

    /**
     * Utilitaires Fliz communs
     */
    window.FlizAdmin = {
        /**
         * Afficher une notification
         *
         * @param {string} message Message à afficher.
         * @param {string} type    Type (success, error, warning, info).
         */
        showNotice: function(message, type) {
            type = type || 'info';
            var $notice = $('<div class="notice notice-' + type + ' is-dismissible"><p>' + message + '</p></div>');
            
            $('.wrap h1').first().after($notice);
            
            // Auto-dismiss après 5 secondes
            setTimeout(function() {
                $notice.fadeOut(300, function() {
                    $(this).remove();
                });
            }, 5000);
        },

        /**
         * Copier du texte dans le presse-papiers
         *
         * @param {string} text Texte à copier.
         * @return {Promise}
         */
        copyToClipboard: function(text) {
            if (navigator.clipboard) {
                return navigator.clipboard.writeText(text);
            } else {
                // Fallback pour les anciens navigateurs
                return new Promise(function(resolve, reject) {
                    var $temp = $('<input>');
                    $('body').append($temp);
                    $temp.val(text).select();
                    
                    try {
                        document.execCommand('copy');
                        resolve();
                    } catch (err) {
                        reject(err);
                    }
                    
                    $temp.remove();
                });
            }
        },

        /**
         * Formater les secondes en durée lisible
         *
         * @param {number} seconds Nombre de secondes.
         * @return {string}
         */
        formatDuration: function(seconds) {
            var mins = Math.floor(seconds / 60);
            var secs = seconds % 60;
            return mins + ':' + (secs < 10 ? '0' : '') + secs;
        }
    };

    /**
     * Initialisation au chargement du DOM
     */
    $(document).ready(function() {
        // Activer les boutons de suppression de notices
        $(document).on('click', '.notice-dismiss', function() {
            $(this).closest('.notice').fadeOut(300, function() {
                $(this).remove();
            });
        });
    });

})(jQuery);
