
<?php

global $wp;
$current_url = home_url(add_query_arg(array($_GET), $wp->request));
$shareUrl = $current_url;
$fcrmDefaultImageUrl = get_option('fcrm_tributes_default_image');
$fcrmShowLocation = get_option('fcrm_tributes_show_location');
$dateFormat = get_option('fcrm_tributes_date_format');
$dateLocale = get_option('fcrm_tributes_date_locale');
if (!$dateFormat) {
  $dateFormat = 'm/d/Y';
}
if (empty($fcrmShowLocation)) {
  $fcrmShowLocation = false;
} else if ($fcrmShowLocation == false || $fcrmShowLocation == '1') {
  $fcrmShowLocation = true;
} else {
  $fcrmShowLocation = false;
}
?>

<div class="firehawk-crm firehawk-crm-tributes firehawk-tributes">
  <div class="tribute-display <?php echo $layout; ?>">
    <div class="banner <?php echo (isset($headingLayout) ? $headingLayout : "") ?>">
      <?php if (isset($client->bannerImage)): ?>
        <a class="banner-bg gallery-selector" data-src="<?php echo $client->bannerImage; ?>" style="background-image: url('<?php echo $client->bannerImage; ?>')">
          <img style="display: none;" src="<?php echo $client->bannerImage; ?>"></img>
        </a>
      <?php else: ?>
        <div class="banner-bg"></div>
      <?php endif; ?>

      <?php if (isset($shareUrl)) { ?>
        <button type="button" title="Share" class="share-btn social-share"><i class="far fa-share"></i></button>
        <div class="firehawk-tributes-social-menu social-menu" role="tooltip">
          <button class="button" data-sharer="facebook" data-url="<?php echo $shareUrl; ?>" title="Share to Facebook"><i class="fab fa-facebook-f"></i></button>

          <button class="button" data-sharer="twitter" data-title="<?php echo 'Service for '.$client->fullName; ?>" data-url="<?php echo $shareUrl; ?>" title="Share to Twitter"><i class="fab fa-twitter"></i></button>

          <button class="button" data-sharer="email" data-to="" data-subject="<?php echo 'Service for '.$client->fullName; ?>" data-title="<?php echo 'Here is the service details for '.$client->fullName; ?>" data-url="<?php echo $shareUrl; ?>" title="Share via email"><i class="fas fa-envelope"></i></button>

          <button class="button copy-btn" data-clipboard-text="<?php echo $shareUrl; ?>" title="Copy"><i class="fas fa-copy"></i></button>
        </div>
      <?php } ?>

      <?php if (isset($client->displayImage)) : ?>
        <a class="display-image gallery-selector" href="<?php echo $client->displayImage; ?>" style="background-image: url('<?php echo $client->displayImage; ?>')">
          <img style="display: none;" src="<?php echo $client->displayImage; ?>"></img>
        </a>
      <?php elseif ($fcrmDefaultImageUrl && strlen($fcrmDefaultImageUrl)) : ?>
        <div class="display-image" style="background-image: url('<?php echo $fcrmDefaultImageUrl; ?>')"></div>
      <?php else: ?>
        <div class="display-image" style="background: #f1f1f1;"></div>
      <?php endif; ?>

      <div class="heading">
        <div class="title">
          <?php echo (isset($client->fullName) ? $client->fullName : ""); ?>
        </div>
        <?php if (isset($client->clientDateOfBirth) && isset($client->clientDateOfDeath) && get_option('fcrm_tributes_hide_dob') != true) {
            $date1 = new DateTime($client->clientDateOfBirth);
            $date2 = new DateTime($client->clientDateOfDeath);

            $dateFormat = "F jS Y";
            $customDateFormat = get_option('fcrm_tributes_dob_format');
            if (isset($customDateFormat)) {
              $dateFormat = $customDateFormat;
            }
            echo '<div class="dates">'.$date1->format($dateFormat) . " - " . $date2->format($dateFormat) . '</div>';
        } elseif (isset($client->clientDateOfDeath)) {
            $date1 = new DateTime($client->clientDateOfDeath);
            $dateFormat = "F jS Y";
            $customDateFormat = get_option('fcrm_tributes_dob_format');
            if (isset($customDateFormat)) {
              $dateFormat = $customDateFormat;
            }
            echo '<div class="dates">' . $date1->format($dateFormat) . '</div>';
        } ?>
      </div>
    </div>

    <?php if (isset($client->formatted_content)):?>
      <div class="tribute-content">
          <?php echo $client->formatted_content; ?>
      </div>
    <?php endif; ?>

    <?php if (isset($client->events)): ?>
      <div class="tribute-row events-row">
        <?php foreach ($client->events as $event): ?>
          <div class="tribute-row-col">
              <?php include(plugin_dir_path(__FILE__) . 'tribute-event-card.php'); ?>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>

    <?php
      if (isset($client->tributeGallery) && count($client->tributeGallery) > 0) {
        echo '<div class="page-divider"></div>';
        $gallery = $client->tributeGallery;
        include( plugin_dir_path( __FILE__ ) . 'fcrm-tribute-gallery.php');
      } else if (isset($client->gallery) && count($client->gallery) > 0) {
        echo '<div class="page-divider"></div>';
        $gallery = $client->gallery;
        include( plugin_dir_path( __FILE__ ) . 'fcrm-tribute-gallery.php');
      }
    ?>

    <div class="page-divider my-3"></div>

    <?php if ($showMenuTabs === true): ?>
      <div class="tribute-row menu-row">
        <div class="tribute-row-col">
          <div class="menu-header">
            <ul class="nav nav-pills ms-0" id="fcrm-tributes-page-menu">
              <?php if ($client->displayTributeMessages === true) { ?>
                <li class="nav-item">
                  <a class="nav-link active" aria-current="page" href="#" data-page="messages">Messages</a>
                </li>
              <?php } ?>

              <?php if ($client->displayTributeTrees === true) { ?>
                <li class="nav-item">
                  <a class="nav-link" href="#" data-page="trees">Trees</a>
                </li>
              <?php } ?>

              <?php if ($canMakeDonations === true): ?>
                <li class="nav-item">
                  <a class="nav-link" href="#" data-page="donations">Donations</a>
                </li>
              <?php elseif (isset($client->donationsUrl)): ?>
                <li class="nav-item">
                  <a class="nav-link" href="<?php echo $client->donationsUrl; ?>" target="_blank">Make a Donation</a>
                </li>
              <?php endif; ?>

              <?php if (isset($client->donationLinks)): ?>
                <?php foreach ($client->donationLinks as $link): ?>
                  <li class="nav-item">
                    <a class="nav-link" href="<?php echo $link->url; ?>" target="_blank"><?php echo $link->name ?></a>
                  </li>
                <?php endforeach; ?>
              <?php endif ?>

              <?php if (isset($client->serviceSheetUrl)): ?>
                <li class="nav-item">
                  <a class="nav-link" href="<?php echo $client->serviceSheetUrl; ?>" target="_blank">
                    <?php
                      $printingButtonLabel = rtrim(get_option('fcrm_tributes_page_options_printing_button', "Printing"));

                      if (empty($printingButtonLabel)) {
                        echo "Printing";
                      } else {
                        echo $printingButtonLabel;
                      }
                      ?>
                  </a>
                </li>
              <?php endif; ?>
              
              <?php if (isset($client->graphicsLinks)): ?>
                <?php foreach ($client->graphicsLinks as $link): ?>
                  <li class="nav-item">
                    <a class="nav-link" href="<?php echo $link->url; ?>" target="_blank"><?php echo $link->name ?></a>
                  </li>
                <?php endforeach; ?>
              <?php endif ?>

              <?php if ($can_deliver_flowers) { ?>
                <li class="nav-item">
                  <a class="nav-link <?php $client->displayTributeMessages != true ? 'active': ''; ?>" href="#" data-page="flowers">Send Flowers</a>
                </li>
              <?php } ?>

              <?php if (isset($client->fragmentTributeUrl)) { ?>
                <li class="nav-item">
                  <a class="nav-link" href="#" data-page="social-tributes">Social Tribute</a>
                </li>
              <?php } else if (isset($client->tributeVideoEmbedCode)) { ?>
                <li class="nav-item">
                  <a class="nav-link" href="#" data-page="social-tribute-embed">Social Tribute</a>
                </li>
              <?php } ?>

              <?php if (($client->displayLiveStream && $client->liveStreamEmbedUrl) || isset($client->tributeLiveStreamEmbedCode)): ?>
                <li class="nav-item live-stream-link">
                  <a class="nav-link" href="#" data-page="view-funeral-stream">Livestream</a>
                </li>
              <?php elseif (isset($client->liveStreamUrl)): ?>
                <li class="nav-item live-stream-link">
                  <a class="nav-link" href="<?php echo $client->liveStreamUrl; ?>" target="_blank">Livestream</a>
                </li>
              <?php endif; ?>

              <?php if (isset($client->additionalLiveStreams)): ?>
                <?php foreach ($client->additionalLiveStreams as $key=>$liveStream): ?>
                  <?php if ($liveStream->type == "url" && $liveStream->url): ?>
                    <li class="nav-item live-stream-link">
                      <a class="nav-link dynamic-live-stream-link" href="<?php echo $liveStream->url; ?>" target="_blank"><?php echo $liveStream->name ?></a>
                    </li>
                  <?php elseif ($liveStream->type == "embed"): ?>
                    <li class="nav-item live-stream-link">
                      <a class="nav-link dynamic-live-stream-link" href="#" data-page="funeral-stream-<?php echo $key?>"><?php echo $liveStream->name ?></a>
                    </li>
                  <?php endif; ?>
                <?php endforeach; ?>
              <?php endif ?>

              <?php if (isset($client->slideshowUrl)): ?>
                <li class="nav-item">
                  <a class="nav-link" href="<?php echo $client->slideshowUrl; ?>" target="_blank">Photo Tribute</a>
                </li>
              <?php endif; ?>

              <?php if (isset($shareUrl)) { ?>
                <li class="nav-item">
                  <button type="button" title="Share Tribute" class="nav-link social-share" target="_blank">Share Tribute</button>

                  <div class="firehawk-tributes-social-menu social-menu" role="tooltip">
                    <button class="button" data-sharer="facebook" data-url="<?php echo $shareUrl; ?>" title="Share to Facebook"><i class="fab fa-facebook-f"></i></button>

                    <button class="button" data-sharer="twitter" data-title="<?php echo 'Tribute for '.$client->fullName; ?>" data-url="<?php echo $shareUrl; ?>" title="Share to Twitter"><i class="fab fa-twitter"></i></button>

                    <button class="button" data-sharer="email" data-to="" data-subject="<?php echo 'Tribute for '.$client->fullName; ?>" data-title="<?php echo 'Here is the tribute page for '.$client->fullName; ?>" data-url="<?php echo $shareUrl; ?>" title="Share via email"><i class="fas fa-envelope"></i></button>

                    <button class="button copy-btn" data-clipboard-text="<?php echo $shareUrl; ?>" title="Copy"><i class="fas fa-copy"></i></button>
                  </div>
                </li>
              <?php } ?>

              <?php if (isset($client->tributePaymentTypeContribute) && $client->tributePaymentTypeContribute == true): ?>
                <li class="nav-item">
                  <a class="nav-link" href="<?php echo get_option('fcrm_tributes_contribute_page'); ?>" target="_blank">Contribute</a>
                </li>
              <?php endif; ?>
            </ul>

            <div class="menu-actions">
              <?php if ($showMenuTabs && $client->displayTributeMessages === true) { ?>
                <button class="btn btn-light add-btn write-message-btn">Write Message<i class="fas fa-xs fa-pencil mb-1 ms-1"></i></button>
              <?php } ?>

              <?php if ($showMenuTabs && $canPlantTrees === true && $canProcessPayments) { ?>
                <button class="btn btn-light add-btn plant-tree-btn" style="display: none;">Plant a Tree<i class="fas fa-xs fa-seedling mb-1 ms-1"></i></button>
              <?php } ?>

              <?php if ($showMenuTabs && $canMakeDonations) { ?>
                <button class="btn btn-light add-btn make-donation-btn" style="display: none;">Make a Donation<i class="fas fa-xs fa-hand-holding-heart mb-1 ms-1"></i></button>
              <?php } ?>
            </div>
          </div>
        </div>
      </div>

      <div class="page-divider my-3"></div>
    <?php endif; ?>

    <div class="tab-pages">
      <?php if ($client->displayTributeMessages === true) { ?>
        <div class="firehawk-crm-tribute-messages tab-page<?php echo ($can_deliver_flowers ? " pt-2" : ''); ?>">

          <?php if (!$showMenuTabs) { ?>
            <div class="messages-header">
              <h4>Messages</h4>
              <button class="btn btn-light add-btn write-message-btn">Write Message<i class="fas fa-xs fa-pencil mb-1 ms-1"></i></button>
            </div>
          <?php } ?>
          <div class="firehawk-crm-tribute-messages-list row" id="tributes-list"></div>
          <div class="fcrm-pagination mb-4 text-center" id="fcrm-list-pagination"></div>
        </div>

        <div class="modal fade create-tribute-modal action-modal" tabindex="-1" style="display: none;" aria-hidden="true" id="message-modal">
    			<div class="modal-dialog modal-lg modal-dialog-centered">
    				<div class="modal-content">
    					<div class="modal-header px-4">
    						<h5 class="modal-title">Write your message</h5>
    						<button type="button" class="btn-close close-modal-btn" data-bs-dismiss="modal" aria-label="Close" style="font-size: 12px;"></button>
    					</div>
    					<div class="modal-body px-4">
                <form id="tribute-form">
                  <div class="row mb-3">
                    <div class="col">
                      <label class="form-label" for="firstName">First name</label>
                      <input type="text" class="form-control" id="firstName" name="firstName" required>
                    </div>
                    <div class="col">
                      <label class="form-label" for="lastName">Last name</label>
                      <input type="text" class="form-control" id="lastName" name="lastName" required>
                    </div>
                  </div>
                  <div class="row mb-2">
                    <div class="col">
                      <label class="form-label" for="email">Email</label>
                      <input type="email" class="form-control" id="email" name="email" required>
                    </div>
                    <div class="col">
                      <label class="form-label" for="phone">Phone</label>
                      <input type="tel" class="form-control" id="phone" name="phone">
                    </div>
                  </div>

                  <div class="form-text mb-3">
                    Your phone number and email address will not be published
                  </div>
                  <div class="row mb-3">
                    <div class="col">
                      <label class="form-label" for="message">Your message</label>
                      <textarea class="form-control" id="message" name="message" rows="4" required></textarea>
                    </div>
                  </div>

                  <button class="btn btn-light toggle-candle-btn mb-3" type="button" data-bs-toggle="collapse" data-bs-target="#candleRow" aria-expanded="false" aria-controls="candleRow">Add Candle</button>

                  <div class="row mb-3 collapse" id="candleRow">
                    <div class="col-auto pe-0">
                      <div class="candle"><i class="fak fa-long-candle-outline"></i></div>
                    </div>

                    <div class="col">
                      <div class="candle-color-picker">
                        <input class="form-control" type="color" name="candleColor">
                        <label class="form-label mb-0">Candle Color</label></div>
                    </div>
                  </div>

                  <div class="bd-callout bd-callout-danger error-callout" style="display: none;"></div>

                  <div class="modal-footer border-0 pt-3 px-0 pb-0">
                    <button type="submit" class="btn btn-primary submit-btn">Submit</button>
                  </div>
    						</form>

                <form id="verify-form" style="display: none;">
                  <p>In order to publish your message, we need to verify your email address. We’ve sent you a six digit code in an email. Please check your inbox, if its not there, please also your spam.</p>

                  <div class="row mb-3">
                    <div class="col text-center">
                      <label class="form-label" for="code">Verification Code</label>
                      <div class="pin-input">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                      </div>
                    </div>
                  </div>

                  <div class="bd-callout bd-callout-danger error-callout" style="display: none;"></div>

                  <div class="modal-footer border-0 pt-3 px-0 pb-0">
                    <button type="button" class="btn btn-secondary close-modal-btn" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary submit-btn">Submit</button>
                  </div>
    						</form>
    					</div>
    				</div>
    			</div>
    		</div>

        <div class="modal fade edit-message-modal action-modal" tabindex="-1" style="display: none;" aria-hidden="true" id="edit-message-modal">
    			<div class="modal-dialog modal-lg modal-dialog-centered">
    				<div class="modal-content">
    					<div class="modal-header px-4">
    						<h5 class="modal-title">Edit your message</h5>
    						<button type="button" class="btn-close close-modal-btn" data-bs-dismiss="modal" aria-label="Close" style="font-size: 12px;"></button>
    					</div>
    					<div class="modal-body px-4">
                <form id="tribute-form">
                  <div class="row mb-3">
                    <div class="col">
                      <label class="form-label" for="message">Your message</label>
                      <textarea class="form-control" id="message" name="message" rows="4" required></textarea>
                    </div>
                  </div>

                  <div class="bd-callout bd-callout-danger error-callout" style="display: none;"></div>

                  <div class="modal-footer border-0 pt-3 px-0 pb-0">
                    <button type="submit" class="btn btn-primary submit-btn">Submit</button>
                  </div>
    						</form>

                <form id="verify-form" style="display: none;">
                  <p>In order to edit your message, we need to verify your email address. We’ve sent you a six digit code in an email. Please check your inbox, if its not there, please also your spam.</p>

                  <div class="row mb-3">
                    <div class="col text-center">
                      <label class="form-label" for="code">Verification Code</label>
                      <div class="pin-input">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                        <input type="tel" maxlength="1" pattern="[0-9]" class="form-control">
                      </div>
                    </div>
                  </div>

                  <div class="bd-callout bd-callout-danger error-callout" style="display: none;"></div>

                  <div class="modal-footer border-0 pt-3 px-0 pb-0">
                    <button type="button" class="btn btn-secondary close-modal-btn" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary submit-btn">Submit</button>
                  </div>
    						</form>
    					</div>
    				</div>
    			</div>
    		</div>
      <?php } ?>

      <?php if ($client->displayTributeTrees === true): ?>
        <div class="firehawk-crm-tribute-trees-page tab-page mt-4" style="display: none;">
          <?php if (!$showMenuTabs): ?>
            <div class="trees-header">
              <h4>Trees</h4>
              <?php if ($canPlantTrees): ?>
                <button class="btn btn-light add-btn plant-tree-btn">Plant a Tree<i class="fas fa-xs fa-pencil mb-1 ms-1"></i></button>
              <?php endif; ?>
            </div>
          <?php endif; ?>

          <div class="firehawk-crm-tribute-trees-list row" id="tribute-trees-list"></div>
          <div class="fcrm-pagination mb-4 text-center" id="fcrm-trees-list-pagination"></div>
        </div>
      <?php endif; ?>

      <?php if ($canMakeDonations === true): ?>
        <div class="firehawk-crm-tribute-donations-page tab-page mt-4" style="display: none;">
          <?php if (!$showMenuTabs): ?>
            <div class="trees-header">
              <h4>Donations</h4>
              <?php if ($canMakeDonations): ?>
                <button class="btn btn-light add-btn make-donation-btn">Make a Donation<i class="fas fa-xs fa-pencil mb-1 ms-1"></i></button>
              <?php endif; ?>
            </div>
          <?php endif; ?>

          <div class="firehawk-crm-tribute-donations-list row" id="tribute-donations-list"></div>
          <div class="fcrm-pagination mb-4 text-center" id="fcrm-donations-list-pagination"></div>
        </div>
      <?php endif; ?>

      <?php if ($can_deliver_flowers): ?>
        <div class="firehawk-crm-tribute-flowers-page tab-page mt-4" <?php echo ($client->displayTributeMessages === true ? 'style="display: none;"' : ''); ?>>
          <?php echo do_shortcode('[show_crm_tributes_flower_delivery]'); ?>
        </div>
      <?php endif; ?>

      <?php if (isset($client->fragmentTributeUrl)): ?>
        <div class="firehawk-crm-tribute-social-page tab-page mt-4" style="display: none;">
          <div class="tribute-row video-row">
            <div class="tribute-row-col">
              <div class="fragment-video-wrapper">
                <iframe class="fragment-video" width="720" height="480" allowfullscreen="true" mozallowfullscreen="true" webkitallowfullscreen="true" src="<?php echo $client->fragmentTributeUrl; ?>" style="border:none"></iframe>
              </div>
            </div>
          </div>
        </div>
      <?php elseif (isset($client->tributeVideoEmbedCode)): ?>
        <div class="firehawk-crm-tribute-social-embed-page tab-page mt-4" style="display: none;">
          <div class="tribute-row video-row">
            <div class="tribute-row-col">
              <div class="fragment-video-wrapper">
                <?php echo $client->tributeVideoEmbedCode ?>
              </div>
            </div>
          </div>
        </div>
      <?php endif; ?>

      <?php if (isset($client->displayLiveStream) || isset($client->tributeLiveStreamEmbedCode)): ?>
        <div class="firehawk-crm-tribute-stream-page tab-page mt-4" style="display: none;">
          <div class="tribute-row stream-row">
            <div class="tribute-row-col">
              <div class="live-stream-video-wrapper">
                <?php if ($client->liveStreamEmbedUrl) { ?>
                  <iframe class="livestream-video" width="100%" height="600" allowfullscreen="true" mozallowfullscreen="true" webkitallowfullscreen="true" src="<?php echo $client->liveStreamEmbedUrl; ?>" style="border:none"></iframe>
                <?php } else if ($client->tributeLiveStreamEmbedCode) { ?>
                  <?php echo $client->tributeLiveStreamEmbedCode ?>
                <?php } ?>

              </div>
            </div>
          </div>
        </div>
      <?php endif; ?>

    
      <?php if (isset($client->additionalLiveStreams)): ?>
        <?php foreach ($client->additionalLiveStreams as $key=>$liveStream): ?>
          <div class="firehawk-crm-tribute-stream-page tab-page mt-4" style="display: none;" id="funeral-stream-<?php echo $key?>">
            <div class="tribute-row stream-row">
              <div class="tribute-row-col">
                <div class="live-stream-video-wrapper">
                  <?php if ($liveStream->embedUrl): ?>
                    <iframe class="livestream-video" width="100%" height="600" allowfullscreen="true" mozallowfullscreen="true" webkitallowfullscreen="true" src="<?php echo $liveStream->embedUrl; ?>" style="border:none"></iframe>
                  <?php elseif ($liveStream->embedCode): ?>
                    <?php echo $liveStream->embedCode ?>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      <?php endif ?>
    </div>
  </div>
</div>

<script>
  const flowerDeliver = new FirehawkCRMTributeFlowerDelivery();

  document.addEventListener("load", function(){
    let queryParamId = <?php echo json_encode($redirect_query_parameter); ?>;
    let page_id = <?php echo json_encode($page_id); ?>;
    let is_get_param = <?php echo json_encode($is_get_param); ?>;
    let detailPage = <?php echo json_encode($detailPage); ?>;
    if(queryParamId && queryParamId.length && is_get_param && page_id && page_id.length && detailPage && detailPage.length) {
      history.pushState({}, null, '/<?php echo $detailPage; ?>/?' + queryParamId + '/<?php echo $page_id; ?>--');
    }
  });
</script>

<script>
  jQuery(".firehawk-crm.firehawk-tributes #fcrm-tributes-page-menu").on("click", ".nav-link", function(e) {
    const page = jQuery(this).data("page");
    if (!page) {
      return
    }

    e.preventDefault();

    jQuery(".firehawk-crm.firehawk-tributes #fcrm-tributes-page-menu .nav-link").removeClass("active")
    jQuery(this).addClass("active");

    var dynamicLink = jQuery(this).hasClass("dynamic-live-stream-link")

    if (dynamicLink) {
      jQuery(".firehawk-crm.firehawk-tributes .tab-pages .tab-page").hide()
      jQuery(".firehawk-crm.firehawk-tributes .tab-pages #" + page).show()
    } else {
      switch (page) {
      case "messages":
        jQuery(".firehawk-crm.firehawk-tributes .tab-pages .tab-page").hide()
        jQuery(".firehawk-crm.firehawk-tributes .firehawk-crm-tribute-messages").show()
        if (tributeMessages) {
          tributeMessages.shuffle.update()
        }
        break;
      case "social-tributes":
        jQuery(".firehawk-crm.firehawk-tributes .tab-pages .tab-page").hide()
        jQuery(".firehawk-crm.firehawk-tributes .firehawk-crm-tribute-social-page").show()
        break;

      case "social-tribute-embed":
        jQuery(".firehawk-crm.firehawk-tributes .tab-pages .tab-page").hide()
        jQuery(".firehawk-crm.firehawk-tributes .firehawk-crm-tribute-social-embed-page").show()
        break;
      case "flowers":
        jQuery(".firehawk-crm.firehawk-tributes .tab-pages .tab-page").hide()
        jQuery(".firehawk-crm.firehawk-tributes .firehawk-crm-tribute-flowers-page").show()
        jQuery("#fcrm-tribute-flowers-menu-link-1").click()
        break;
      case "trees":
        jQuery(".firehawk-crm.firehawk-tributes .tab-pages .tab-page").hide()
        jQuery(".firehawk-crm.firehawk-tributes .firehawk-crm-tribute-trees-page").show()
        if (tributeTrees) {
          tributeTrees.shuffle.update()
        }
        break;
      case "donations":
        jQuery(".firehawk-crm.firehawk-tributes .tab-pages .tab-page").hide()
        jQuery(".firehawk-crm.firehawk-tributes .firehawk-crm-tribute-donations-page").show()
        if (tributeDonations) {
          tributeDonations.shuffle.update()
        }
        break;
      case "view-funeral-stream":
        jQuery(".firehawk-crm.firehawk-tributes .tab-pages .tab-page").hide()
        jQuery(".firehawk-crm.firehawk-tributes .firehawk-crm-tribute-stream-page").show()
        break;
        default: break;
     }
    }

    if (page == "messages") {
      jQuery(".firehawk-crm.firehawk-tributes .menu-header .write-message-btn").show()
    } else {
      jQuery(".firehawk-crm.firehawk-tributes .menu-header .write-message-btn").hide()
    }

    if (page == "trees") {
      jQuery(".firehawk-crm.firehawk-tributes .menu-header .plant-tree-btn").show()
    } else {
      jQuery(".firehawk-crm.firehawk-tributes .menu-header .plant-tree-btn").hide()
    }

    if (page == "donations") {
      jQuery(".firehawk-crm.firehawk-tributes .menu-header .make-donation-btn").show()
    } else {
      jQuery(".firehawk-crm.firehawk-tributes .menu-header .make-donation-btn").hide()
    }
  })

  jQuery('.firehawk-crm.firehawk-tributes .social-share').each(function() {
    var tippyButton = this;
    var menu = jQuery(this).next(".social-menu")[0]
    var activeClipboard = null
    var tip = tippy(tippyButton, {
      content: menu,
      trigger: 'click',
      interactive: true,
      onShown(instance) {
        window.Sharer.init();
        var copyBtn = jQuery(menu).find(".copy-btn")[0];
        if (copyBtn) {
          activeClipboard = new ClipboardJS(copyBtn);
        }
      },
      onHide(instance) {
        if (activeClipboard) {
          activeClipboard.destroy()
          activeClipboard = null
        }
      }
    });

    jQuery(menu).children(".button").click(function() {
      if (tip) {
        setTimeout(function() {
          tip.hide();
        }, 200);
      }
    })
  });

  var gallery = jQuery('.firehawk-crm.firehawk-tributes')[0]
  lightGallery(gallery, {
  	selector: '.gallery-selector',
  	share: false,
  	pager: false
  })

  jQuery('.firehawk-crm.firehawk-tributes .event-card .more-info-btn').on("click", function() {
    const modalTarget = jQuery(this).data("target")
    const modalElement = jQuery(modalTarget)
    const actionModal = new bootstrap.Modal(document.getElementById(modalElement.attr('id')), {})
    actionModal.show()
  })
</script>

<?php if ($carouselGallery == true): ?>
<script>
  var slickopts = {
    slidesToShow: 5,
    slidesToScroll: 5,
    rows: 2,
    accessibility: false,
    centerMode: false,
    responsive: [
      {
        breakpoint: 992,
        settings: {
          slidesToShow: 4,
          slidesToScroll: 4,
        }
      },
      { breakpoint: 776,
        settings: {
          slidesToShow: 3,
          slidesToShow: 3,
          rows: 2
        }
      },
      { breakpoint: 610,
        settings: {
          slidesToShow: 2,
          slidesToShow: 2,
          rows: 2
        }
      },
      { breakpoint: 490,
        settings: {
          slidesToShow: 1,
          slidesToShow: 1,
          rows: 2
        }
      }
    ]
  };
  jQuery(".firehawk-crm.firehawk-tributes .firehawk-tributes-gallery").slick(slickopts);
</script>
<?php endif; ?>

<?php if ($client->displayTributeMessages === true): ?>
<script>
  const tributeMessages = new FirehawkCRMServiceTribute(jQuery(".firehawk-crm-tribute-messages .firehawk-crm-tribute-messages-list"), jQuery(".firehawk-crm-tribute-messages .fcrm-pagination"), jQuery(".firehawk-tributes #message-modal"), jQuery(".firehawk-tributes #edit-message-modal"), <?php echo json_encode($client->id); ?>)
  tributeMessages.dateLocale = <?php echo json_encode($dateLocale); ?>;
  tributeMessages.team = <?php echo json_encode($team); ?>;
  tributeMessages.reloadView(0)

  jQuery(".firehawk-crm.firehawk-tributes .write-message-btn").on("click", function(event) {
    tributeMessages.showWriteMessageModal()
  })
</script>
<?php endif; ?>

<?php if ($client->displayTributeTrees === true) { ?>
<script>
  const tributeTrees = new FirehawkCRMServiceTributeTrees(jQuery(".firehawk-crm-tribute-trees-page .firehawk-crm-tribute-trees-list"), jQuery(".firehawk-crm-tribute-trees-page .fcrm-pagination"), <?php echo json_encode($client->id); ?>)
  tributeTrees.dateLocale = <?php echo json_encode($dateLocale); ?>;
  tributeTrees.team = <?php echo json_encode($team); ?>;
  tributeTrees.checkoutCartUrl = "<?php echo $checkoutCartUrl; ?>";
  tributeTrees.clientName = "<?php echo (isset($client->fullName) ? $client->fullName : ""); ?>";
  tributeTrees.country = "<?php echo (isset($client->country) ? $client->country : ""); ?>";
  tributeTrees.reloadView(0)

  jQuery(".firehawk-crm.firehawk-tributes .plant-tree-btn").on("click", function(event) {
    tributeTrees.showTreePurchaseModal()
  })
</script>
<?php } ?>

<?php if ($canMakeDonations === true) { ?>
<script>
  const tributeDonations = new FirehawkCRMServiceTributeDonations(jQuery(".firehawk-crm-tribute-donations-page .firehawk-crm-tribute-donations-list"), jQuery(".firehawk-crm-tribute-donations-page .fcrm-pagination"), <?php echo json_encode($client->id); ?>)
  tributeDonations.charityNotFound = function() {
    jQuery(".firehawk-crm.firehawk-tributes .make-donation-btn").addClass("d-none")
  }
  tributeDonations.dateLocale = <?php echo json_encode($dateLocale); ?>;
  tributeDonations.team = <?php echo json_encode($team); ?>;
  tributeDonations.checkoutCartUrl = "<?php echo $checkoutCartUrl; ?>";
  tributeDonations.clientName = "<?php echo (isset($client->fullName) ? $client->fullName : ""); ?>";
  tributeDonations.setupView()

  jQuery(".firehawk-crm.firehawk-tributes .make-donation-btn").on("click", function(event) {
    tributeDonations.showDonationPurchaseModal()
  })
</script>
<?php } ?>

<?php
if (function_exists('service_buttons_check') == false) {
  include( plugin_dir_path( __FILE__ ) . '../service-buttons-functions.php');
}
?>

<?php

function replace_tags($string, $tags, $force_lower = false) {
  return preg_replace_callback('/\\{\\{([^{}]+)\}\\}/',
    function($matches) use ($force_lower, $tags)
    {
      $key = $force_lower ? strtolower($matches[1]) : $matches[1];
      return array_key_exists($key, $tags) 
        ? $tags[$key] 
        : ''
        ;
    }
    , $string);
}

$client->name = $client->fullName;
$newtitle = "Tribute - ".$client->fullName;
if (get_option('fcrm_tributes_meta_title')) {
  $newtitle = replace_tags(get_option('fcrm_tributes_meta_title'), json_decode(json_encode($client), true));
}
echo '<script type="text/javascript">
    var newTitle = document.createElement("title")
    newTitle.innerText = "' . $newtitle . '"
    window.onload = function() {

    }
    let allTitles = document.getElementsByTagName("title"); 
    for (let i=0; i<allTitles.length; i++ ) {
        allTitles[i].remove()
    }
    document.head.prepend(newTitle)
    </script>';
?>
