<?php
/**
 * @link       https://www.floristone.com
 * @since      1.0.0
 *
 * @package    Florist_One_Flower_Delivery
 * @subpackage Florist_One_Flower_Delivery/public/partials
 */
?>

<div class="fcrm-tributes-flower-single-product">
  <div class="fcrm-tributes-flower-page-header">
    <div class="title w-100">
      <h3 class="text-center"><?php echo $api_response_body['PRODUCTS'][0]['NAME'] ?></h3>
    </div>
  </div>
  <div class="row">
    <div class="col-12 col-md-4 image-col">
      <img class="display-image" src=" <?php echo $api_response_body['PRODUCTS'][0]['LARGE'] ?>" />
    </div>

    <div class="col-12 col-md-8 content-col">
      <div class="description"><?php echo $api_response_body['PRODUCTS'][0]['DESCRIPTION'] ?></div>

      <div id="fcrm-tribute-flowers-plant-a-tree-container">
        <h3>A Group of Five Trees</h3>

        <div class="fcrm-tribute-flowers-plant-a-tree-select card">
          <table class="table table-borderless" id="fcrm-tribute-flowers-plant-a-tree-select-from">
            <tbody>
              <?php
                for ($x = 0; $x <= 0; $x++) { ?>
                  <tr>
                    <td>
                      <div class="checkbox-group">
                        <input type="radio" class="form-check-input" data-price='<?php echo $api_response_body['Group' . ($x + 1) .'Pricing']['price'] ?>' data-name="<?php echo $api_response_body['Group' . ($x + 1) .'Pricing']['displayText'] ?>" name="fcrm-tribute-flowers-plant-a-tree-select-from-number" value="<?php echo preg_replace('/[^0-9]/', '',$api_response_body['Group' . ($x + 1) .'Pricing']['displayText'])?>" <?php if ($x == 0){echo 'checked="checked"';} ?>>
                        <label class="form-check-label" for="fcrm-tribute-flowers-plant-a-tree-select-from-numbe"></label>
                      </div>
                    </td>

                    <td class="group_of"><?php echo $api_response_body['Group' . ($x + 1) .'Pricing']['displayText'] ?></td>

                    <td class="text-end">$<?php echo number_format( $api_response_body['Group' . ($x + 1) .'Pricing']['price'], 2, '.', '') ?></td>
                  </tr>
              <?php } ?>
            </tbody>
          </table>

          <div class="card-body text-end py-2 d-flex justify-content-between">
            <span>Total</span>
            <p class="price mb-0">$<?php echo number_format( $api_response_body['PRODUCTS'][0]['PRICE'], 2, '.', '')?></p>
          </div>
        </div>

        <p class="text-end">
          <a href="#" class="fcrm-tribute-flowers-add-to-cart btn btn-primary add-to-cart-btn" id="plant-a-tree-add-to-cart1" data-name="<?php echo $api_response_body['Group1Pricing']['displayText'] ?>" data-code="<?php echo $api_response_body['Group1Pricing']['displayText'] ?>" data-price="<?php echo $api_response_body['PRODUCTS'][0]['PRICE'] ?>" data-number="5">Add To Cart</a>
        </p>
        <h3>Select Your Own Number of Trees</h3>
        <div class="fcrm-tribute-flowers-plant-a-tree-select">
          <div class="input-group mb-3">
            <input class="form-control" id="fcrm-tribute-flowers-plant-a-tree-select-your-own" name="fcrm-tribute-flowers-plant-a-tree-select-your-own" type="number" min="5">
            <a href="#" class="fcrm-tribute-flowers-plant-a-tree-select-your-own-calculate btn btn-primary" id="fcrm-tribute-flowers-add-to-cart-<?php echo $api_response_body['PRODUCTS'][0]['CODE'] ?>-2" data-code="<?php echo $api_response_body['PRODUCTS'][0]['CODE'] ?>">Calculate Price</a>
          </div>
          <div id="calculate-msg"></div>
        </div>
      </div>
    </div>
  </div>
</div>
