<?php
/**
 * @link       https://www.floristone.com
 * @since      1.0.0
 *
 * @package    Florist_One_Flower_Delivery
 * @subpackage Florist_One_Flower_Delivery/public/partials
 */
?>

<?php $f1_aff_id = get_option('fcrm_tributes_f1_aff_id'); ?>
<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

<?php
  if ($f1_aff_id == 0) {
      echo '<div class="fcrm-tribute-flowers-ssl-warning">&#9888; A valid Florist One AffiliateID is required for the Florist One Flower Delivery plugin to work!</div>';
  }
?>

<div class="fcrm-tribute-flowers-menu">
  <?php
    $categories = array();
    array_push($categories, array('short' => 'fa', 'long' => 'Table Arrangements'));
    array_push($categories, array('short' => 'fb', 'long' => 'Baskets'));
    array_push($categories, array('short' => 'fs', 'long' => 'Sprays'));
    array_push($categories, array('short' => 'fp', 'long' => 'Plants'));
    array_push($categories, array('short' => 'fl', 'long' => 'Inside Casket'));
    array_push($categories, array('short' => 'fw', 'long' => 'Wreaths'));
    array_push($categories, array('short' => 'fh', 'long' => 'Hearts'));
    array_push($categories, array('short' => 'fx', 'long' => 'Crosses'));
    array_push($categories, array('short' => 'fc', 'long' => 'Casket Sprays'));
    array_push($categories, array('short' => 'fu', 'long' => 'Urn Arrangements'));
  ?>

  <ul class="fcrm-tribute-flowers-menu-desktop-menu all nav nav-pills">
    <li class="fcrm-tribute-flowers-menu-link-last nav-item">
      <a href="#" id="fcrm-tribute-flowers-menu-link-0" class="nav-link fcrm-tribute-flowers-menu-plant-a-tree-link" data-category="pt">Plant a Tree</a>
    </li>

    <?php for ($i=0; $i < count($categories); $i++) { ?>
      <li class="nav-item">
        <a href="#" id="fcrm-tribute-flowers-menu-link-<?php echo ($i+1); ?>" class="nav-link fcrm-tribute-flowers-menu-link" data-page="1" data-category="<?php echo $categories[$i]['short']; ?>">
          <?php echo $categories[$i]['long'] ?>
        </a>
      </li>
    <?php } ?>

    <li class="fcrm-tribute-flowers-menu-link-last nav-item">
      <a href="#" id="fcrm-tribute-flowers-menu-link-99" class="nav-link fcrm-tribute-flowers-menu-customer-service-link" data-category="">Customer Service</a>
    </li>

    <li class="fcrm-tribute-flowers-menu-cart nav-item">
      <a href="#" id="fcrm-tribute-flowers-menu-link-100" class="nav-link fcrm-tribute-flowers-menu-cart" data-category="">
        <i class="far fa-shopping-basket me-1"></i>
        <span class="me-2">My Cart</span>
        <span class="badge rounded-pill bg-danger" id="fcrm-tribute-flower-cart-count"></span>
      </a>
    </li>
 </ul>
</div>
