<?php
/**
 * @link       https://www.floristone.com
 * @since      1.0.0
 *
 * @package    Florist_One_Flower_Delivery
 * @subpackage Florist_One_Flower_Delivery/public/partials
 */
?>

<?php

if (!function_exists('fcrm_build_pagination')) {
  function fcrm_build_pagination($current_page, $total_items, $category) {
    $htmlString = "";
    $pages = ceil($total_items / 12);
    $pages_shown = 0;
    $start_at = 1;
    $end_at = $start_at + 9;
    if ($pages > 9 && $current_page >= 5 && $current_page <= $pages - 4) {
        $start_at = $current_page - 4;
        $end_at = $start_at + 9;
    } elseif ($pages > 9 && $current_page >= 5) {
        $start_at = $current_page - (8 - ($pages - $page));
        $end_at = $start_at + 9;
    } elseif ($pages <= 9) {
        $start_at = 1;
        $end_at = $pages;
    }
    if ($current_page != 1) {
        $prev_page = $current_page - 1;
        $htmlString = $htmlString.'<li class="page-item" data-category="' . $category . '"><a href="#" class="page-link" data-page="' . $prev_page . '" data-category="' . $category . '">Previous</a></li>';
    }

    for ($i=$start_at;$i<=$end_at;$i++) {
      $activeClass = "";
      if ($current_page === $i.'') {
        $activeClass = " active";
      }

        if ($pages_shown < 9) {
            $htmlString = $htmlString.'<li class="page-item'. $activeClass . '" id="page-item-' . $i . '" data-category="' . $category . '"><a href="#" class="page-link"  data-page="' . $i . '" data-category="' . $category . '">' . $i . '</a></i>';
        }

        $pages_shown++;
    }
    if ($current_page <= $pages && $current_page != $pages) {
        $next_page = $current_page + 1;
        $htmlString = $htmlString.'<li class="page-item"><a href="#" class="page-link" id="fcrm-tribute-flowers-menu-link-next-' . $next_page . '" data-page="' . $next_page . '" data-category="' . $category . '">Next</a></li>';
    }

    return $htmlString;
  }
}
?>
<div class="fcrm-tributes-flower-page-header">
  <div class="title w-100">
    <h3 class="fcrm-tribute-flowers-many-products-category text-center">
      <?php
        switch ($category) {
          case 'fa':
            echo 'Table Arrangements';
            break;
          case 'fb':
            echo 'Baskets';
            break;
          case 'fs':
            echo 'Sprays';
            break;
          case 'fp':
            echo 'Plants';
            break;
          case 'fl':
            echo 'Inside Casket';
            break;
          case 'fw':
            echo 'Wreaths';
            break;
          case 'fh':
            echo 'Hearts';
            break;
          case 'fx':
            echo 'Crosses';
            break;
          case 'fc':
            echo 'Casket Sprays';
            break;
          case 'ao':
            echo 'Everyday Arrangements';
            break;
          case 'gw':
            echo 'Get Well';
            break;
          case 'nb':
            echo 'New Baby';
            break;
          case 'bd':
            echo 'Birthday';
            break;
          case 'ty':
            echo 'Thank You';
            break;
          case 'lr':
            echo 'Love &amp; Romance';
            break;
          case 'an':
            echo 'Anniversary';
            break;
          case 'sy':
            echo 'Funeral & Sympathy';
            break;
          case 'v':
            echo 'Vase Arrangements';
            break;
          case 'p':
            echo 'Plants';
            break;
          case 'b':
            echo 'Balloons';
            break;
          case 'r':
            echo 'Roses';
            break;
          case 'c':
            echo 'Centerpieces';
            break;
          case 'o':
            echo 'One Sided Arrangements';
            break;
          case 'x':
            echo 'Fruit Baskets';
            break;
          case 'u60':
            echo 'Under $60';
            break;
          case 'bt60-80':
            echo '$60 - $80';
            break;
          case 'bt80-100':
            echo '$80 - $100';
            break;
          case 'o100':
            echo 'Over $100';
            break;
          case 'fu':
            echo 'Urn Arrangements';
            break;
        }
      ?>
    </h3>
  </div>
</div>

<div class="fcrm-tributes-flower-grid row">
  <?php for ($i = 0; $i < count($api_response_body["PRODUCTS"]); $i++) { ?>
    <?php $product = $api_response_body["PRODUCTS"][$i]; ?>
    <div class="col-6 col-md-4 col-lg-3">
      <div class="fcrm-tributes-flower-grid-item fcrm-tributes-flower-single-product">
        <a href="#" id="<?php echo $product["CODE"]; ?>-1" class="display-image-link view-item-btn" data-code="<?php  echo $product["CODE"]; ?>">
          <div class="display-image"><img src="<?php echo $product["SMALL"]; ?>" /></div>
        </a>
        <div class="content">
          <div class="display-name"><span> <?php echo $product["NAME"]; ?></span></div>
          <div class="display-price">$<?php echo $product["PRICE"] ;?></div>
          <a href="#" class="btn btn-light add-to-cart-btn" id="flower-delivery-add-to-cart-<?php echo $product["CODE"]; ?>" data-code="<?php echo $product["CODE"]; ?>">Add To Cart</a>
        </div>
        <!-- <div class="grid-actions">
          <a href="#" id="<?php echo $product["CODE"]; ?>-2" class="btn btn-light view-item-btn" data-code="<?php echo $product["CODE"]; ?>">View Item</a>
          <a href="#" class="btn btn-light add-to-cart-btn" id="flower-delivery-add-to-cart-<?php echo $product["CODE"]; ?>" data-code="<?php echo $product["CODE"]; ?>">Add To Cart</a>
        </div> -->
      </div>
    </div>
  <?php } ?>
</div>

<div class="pagination-container text-center">
  <ul class="pagination fcrm-tributes-flower-pagination center pt-4">
  <?php echo fcrm_build_pagination($page, $api_response_body["TOTAL"], $category); ?>
  </ul>
</div>
