<?php
/**
 * @link       https://www.floristone.com
 * @since      1.0.0
 *
 * @package    Florist_One_Flower_Delivery
 * @subpackage Florist_One_Flower_Delivery/public/partials
 */
?>

<div class="fcrm-tributes-flower-page-header">
  <div class="title w-100">
    <h3 class="text-center">Checkout 4/4</h3>
  </div>
</div>

<h3 class="fcrm-tribute-flowers-checkout-heading mb-3">Review Your Order</h3>

<p class="fcrm-tribute-flowers-review-error-message" style="display: none; color: red; text-align: center;">Please correct the fields in red below and then click on 'Process Order'.</p>

<?php $dont_show_remove_button=1 ?>

<table class="fcrm-tribute-flowers-review-order half">
  <?php
    function createRow($label,$info,$tree){
      $section = substr($_SESSION['fcrm-tribute-flowers-tree-certificate'], 5) . "-";
      $class = "";
      $display = "";
      if ($label == "edit button"){ // edit button
        $edit_page = ($tree)? "1" : "2"; // page to go for edit
        $type =  ($tree)? "Trees" : "Flower";
        $label = '<a href="#" id="fcrm-tribute-flowers-checkout-page-edit-' . $edit_page . '" class="fcrm-tribute-flowers-checkout-page-edit" data-page="' . $edit_page .'" data-edit-type="' . $type .'">Edit</a>';
      } else {
        if (is_array($label)){ // check if more than one label
          for ($x =0; $x < count($label);$x++){
            $seperate = ($x == 0) ? ", " : " ";
            $display .= $_SESSION["fcrm-tribute-flowers-recipient-" . strtolower(str_replace(' ', '-', $label[$x]))] . $seperate ;
          }
          $class = "fcrm-tribute-flowers-review-recipient-" . $label[0];
          $label = "";
        } else { // only one label
          $field =  strtolower(str_replace(' ', '-', $label));
          $id = ($tree)? "fcrm-tribute-flowers-tree-certificate-" . $section . $field : "fcrm-tribute-flowers-recipient-" . $field;
          if ($label == "Name of Loved One"){
            $id = "fcrm-tribute-flowers-tree-certificate-" . $field;
          }
          if ($label == "Delivery Method") {
            $display = ($section == "they-email-") ? "You Email Certificate" : "We Email Certificate";
          } else {
            $display = ($info)? $_SESSION[$id] : "&nbsp;";
          }
          $class = ($info)? ($tree) ?"fcrm-tribute-flowers-review-tree-certificate-" . $section .  $field : "fcrm-tribute-flowers-review-recipient-" . $field : "";
        }
      }
      $colon = ($label == "")? "" : ($info)?":":"";
      echo '<tr><td' . (($info)? '': ' colspan="2"') .'>' . $label . $colon . '</td>';
      if ($info){ echo '<td class ="' . $class . '">' . $display . '</td></tr>';}
    }
    if ( $_SESSION['fcrm-tribute-flowers-tree-certificate'] != ""){// do if plant a tree
      $section = substr($_SESSION['fcrm-tribute-flowers-tree-certificate'], 5);
      createRow("<span class='fcrm-tribute-flowers-review-section'>Tree Certificate Information</span>",false,true);
      createRow("Delivery Method",true,true);
      if ($section == "they-email") {
        createRow("Name of Loved One",true,true);
      } else {
        createRow("Name of Loved One",true,true);
        createRow("Recipient Name",true,true);
        createRow("Recipient Email",true,true);
        createRow("Message To Recipient",true,true);
      }
      createRow('edit button',false, true);
    } else { // do if not plant a tree
      createRow("<span class='fcrm-tribute-flowers-review-section'>Deliver To</span>", false,false);
      $deliver_to_fields = array("Name","Institution","Address 1","Address 2",array('city','state','postal code'),"Phone");
      for ($d = 0; $d < count($deliver_to_fields);$d++){
        createRow($deliver_to_fields[$d], true,false);
      }
      createRow('edit button',false, false);
    } ?>
</table>

<table class="fcrm-tribute-flowers-review-order half">
  <?php
    function createRowBillTo($label){// bill to table
      $field = strtolower(str_replace(' ', '-', $label));
      $prefix = 'fcrm-tribute-flowers-customer-';//field
      $stylePre = 'fcrm-tribute-flowers-review-customer-';//class
      $id = $prefix . $field;
      if (is_array($label)){ // check if more than one label
        for ($x =0; $x < count($label);$x++){
          $seperate = ($x == 0) ? ", " : " ";
          $display .= $_SESSION[$prefix . strtolower(str_replace(' ', '-', $label[$x]))] . $seperate ;
        }
        $class = $stylePre . $label[0];
        $label = "";
      } else {//only one label
         $display = $_SESSION[$id];
         $class = $stylePre . $field;
      }
      echo '<tr><td>' . $label . ($label == "" ? "":":") . '</td><td class="' . $class . '">' . $display . '</td></tr>';
    }
    createRow("<span class='fcrm-tribute-flowers-review-section'>Bill To</span>",false,false);
    $bill_fields = array("Name", "Address 1", "Address 2", array('City','State','Postal Code'), "Phone","Email");
    for ($f = 0; $f < count($bill_fields);$f++){
      createRowBillTo($bill_fields[$f]);
    }
    createRow('<a href="#" id="fcrm-tribute-flowers-checkout-page-edit-3" class="fcrm-tribute-flowers-checkout-page-edit" data-page="3">Edit</a>',false,false);
  ?>
</table>

<?php if ($_SESSION['fcrm-tribute-flowers-tree-certificate'] == ""){ // don't show if plant a tree ?>

  <table class="fcrm-tribute-flowers-review-order full">
    <tr>
      <td><span class='fcrm-tribute-flowers-review-section'>Gift Card Message</span></td>
    </tr>
    <tr>
      <td class="fcrm-tribute-flowers-review-card-message"><?php echo $_SESSION['fcrm-tribute-flowers-card-message'] ?></td>
    </tr>
    <tr>
      <td>
        <a href="#" id="fcrm-tribute-flowers-checkout-page-edit-1" class="fcrm-tribute-flowers-checkout-page-edit" data-page="1">Edit</a>
      </td>
    </tr>
  </table>

  <table class="fcrm-tribute-flowers-review-order full">
    <tr>
      <td><span class='fcrm-tribute-flowers-review-section'>Special Instructions</span></td>
    </tr>
    <tr>
      <td class="fcrm-tribute-flowers-review-special-instructions"><?php echo $_SESSION['fcrm-tribute-flowers-special-instructions'] ?></td>
    </tr>
    <tr>
      <td>
        <a href="#" id="fcrm-tribute-flowers-checkout-page-edit-1-3" class="fcrm-tribute-flowers-checkout-page-edit" data-page="1">Edit</a>
      </td>
    </tr>

  </table>

  <table class="fcrm-tribute-flowers-review-order full">
    <tr>
      <td><span class='fcrm-tribute-flowers-review-section'>Delivery Date</span></td>
    </tr>
    <tr>
      <td class="fcrm-tribute-flowers-review-delivery-date"><?php echo $_SESSION['fcrm-tribute-flowers-delivery-date'] ?></td>
    </tr>
    <tr>
      <td>
        <a href="#" id="fcrm-tribute-flowers-checkout-page-edit-1-2" class="fcrm-tribute-flowers-checkout-page-edit" data-page="1">Edit</a>
      </td>
    </tr>
  </table>

<?php }  ?>

<?php
  include 'flower-delivery-cart-body.php';
  $affiliate_id = get_option('fcrm_tributes_f1_aff_id');

  if(count($products_for_display) > 0){

    $amount = number_format($get_total_response_body['ORDERTOTAL'], 2);
    $redirect_url = $_SERVER['HTTP_REFERER'];
    $treeDeliveryMethod = $_SESSION['fcrm-tribute-flowers-tree-certificate'];

    $products = array();

    // check for trees
    if ($products_for_display[0]['CODE'] == "TREE"){ // just for trees
       $customer = array(
        'first_name' => $_SESSION['fcrm-tribute-flowers-customer-name'],
        'last_name' => "",
        'address' => $_SESSION['fcrm-tribute-flowers-customer-address-1'] . " " . $_SESSION['fcrm-tribute-flowers-customer-address-2'] ,
        'city' => $_SESSION['fcrm-tribute-flowers-customer-city'],
        'state' => $_SESSION['fcrm-tribute-flowers-customer-state'],
        'zipcode' => $_SESSION['fcrm-tribute-flowers-customer-postal-code'],
        'country' => $_SESSION['fcrm-tribute-flowers-customer-country'],
        'phone' => $_SESSION['fcrm-tribute-flowers-customer-phone'],
        'email' => $_SESSION['fcrm-tribute-flowers-customer-email'],
        'ip' => $_SERVER['REMOTE_ADDR']
      );
      $recipient = array(
        'message' => ($treeDeliveryMethod == "Cert-email-behalf") ? $_SESSION['fcrm-tribute-flowers-tree-certificate-email-behalf-message-to-recipient'] : "",
        'first_name' => ($treeDeliveryMethod == "Cert-email-behalf") ?$_SESSION['fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-name'] : "",
        'last_name' => "",
        'email' => ($treeDeliveryMethod == "Cert-email-behalf") ? $_SESSION['fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-email']:"",
        'send_certificate' => ($treeDeliveryMethod == "Cert-email-behalf") ? 1 : 0
      );
        $product = array(
            'code' => $products_for_display[0]['CODE'],
            'amount' => $products_for_display[0]['PRICE'],
            'number' =>    intval(preg_replace('/[^0-9.]+/', '', $vars["products"][0]["NAME"])),
          );
    } else { // all but trees

       $customer = array(
        'name' => $_SESSION["fcrm-tribute-flowers-customer-name"],
        'address1' => $_SESSION["fcrm-tribute-flowers-customer-address-1"],
        'address2' => $_SESSION["fcrm-tribute-flowers-customer-address-2"],
        'city' => $_SESSION["fcrm-tribute-flowers-customer-city"],
        'state' => $_SESSION["fcrm-tribute-flowers-customer-state"],
        'zipcode' => $_SESSION["fcrm-tribute-flowers-customer-postal-code"],
        'country' => $_SESSION["fcrm-tribute-flowers-customer-country"],
        'email' => $_SESSION["fcrm-tribute-flowers-customer-email"],
        'phone' => $_SESSION["fcrm-tribute-flowers-customer-phone"],
        'ip' => $_SERVER['REMOTE_ADDR']
      );
      $recipient = array(
        'name' => $_SESSION["fcrm-tribute-flowers-recipient-name"],
        'institution' => $_SESSION['fcrm-tribute-flowers-recipient-institution'],
        'address1' => $_SESSION["fcrm-tribute-flowers-recipient-address-1"],
        'address2' => $_SESSION["fcrm-tribute-flowers-recipient-address-2"],
        'city' => $_SESSION["fcrm-tribute-flowers-recipient-city"],
        'state' => $_SESSION["fcrm-tribute-flowers-recipient-state"],
        'zipcode' => $_SESSION["fcrm-tribute-flowers-recipient-postal-code"],
        'country' => $_SESSION["fcrm-tribute-flowers-recipient-country"],
        'phone' => $_SESSION["fcrm-tribute-flowers-recipient-phone"]
      );

      for ($i=0;$i<count($products_for_display);$i++){
        array_push(
          $products,
          array(
            'code' => $products_for_display[$i]['CODE'],
            'price' => $products_for_display[$i]['PRICE'],
            'recipient' => $recipient,
            'deliverydate' => $_SESSION["fcrm-tribute-flowers-delivery-date"],
            'cardmessage' => $_SESSION["fcrm-tribute-flowers-card-message"],
            'specialinstructions' => $_SESSION["fcrm-tribute-flowers-special-instructions"]
          )
        );
      }
    }
    
    if ($products_for_display[0]['CODE'] == "TREE"){//payload for Tree
      $payload = array(
        'customer' => $customer,
        'recipient' => $recipient,
        'product' => $product,
        'referring_affiliate_id' => $affiliate_id,
        'deceased_display_name' => $_SESSION["fcrm-tribute-flowers-tree-certificate-name-of-loved-one"],
        'apikey' => Fcrm_Tributes_Flowers_Api::$username
      );
    } else {
      $payload = array(
        'customer' => $customer,
        'products' => $products,
        'f1_aff_id' => $affiliate_id,
        'apikey' => Fcrm_Tributes_Flowers_Api::$username
      );
    }

    $fingerprint = Fcrm_Tributes_Flowers_Api::generateAuthorizeNetKey();

    echo '<form method="post" action="https://accept.authorize.net/payment/payment">';

    echo '<input type="hidden" name="token" value="' . $fingerprint['body']['token'] . '" />';

    echo '<div class="text-end"><input type="submit" class="btn btn-primary" value="Continue To Payment Gateway" /></div>';

    echo '</form>';

  }
  else{
    echo '<table><tr><td><h5>Shopping Cart</h5></td></tr><tr><td>Your shopping cart is empty.</td></tr></table>';
  }

?>
