<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       firehawkcrm.com
 * @since      1.0.0
 *
 * @package    Fcrm_Tributes
 * @subpackage Fcrm_Tributes/public/partials
 */

?>
<?php
    function clean_string($string) {
        $string = str_replace('-', '', $string); // Removes all hyphens.
        $string = preg_replace('/\s+/', '', $string); // Removes all spaces.
        $string = preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
 
        return strtolower(preg_replace('/-+/', '', $string)); // Replaces multiple hyphens with single one.
     }

    function format_client_permalink($client, $detailPage)
    {
      if (!isset($detailPage) || !isset($client)) {
        return null;
      }

      $use_custom_link = get_option("fcrm_tributes_readable_permalinks");

      if (empty($use_custom_link) || $use_custom_link == false || $use_custom_link == 0) {
        $use_custom_link = false;
      } else {
        $use_custom_link = true;
      }

      $permalink = $detailPage.'/'.$client->id;
      $url_parts = array();

      if ($use_custom_link === true) {
        if (!isset($client->fileNumber)) {
          return null;
        }

        if (isset($client->firstName)) {
          array_push($url_parts, clean_string($client->firstName));
        } else {
          array_push($url_parts, "1");
        }

        if (isset($client->lastName)) {
          array_push($url_parts, clean_string($client->lastName));
        } else {
          array_push($url_parts, "1");
        }

        $fileNumber = str_replace('/', "%2F", $client->fileNumber);
        array_push($url_parts, $fileNumber);
        return home_url($detailPage.'/'.join("-", $url_parts));
      }

      $permalink = $detailPage.'/'.$client->id .'/';
      return home_url($permalink);
    }

    global $wp_query; //Load $wp_query object
    $page_value = $wp_query->query_vars['fhf_tributes_sitemap'];
    $page_num = (int)$page_value;

    $from = $page_num - 1;
    if($from < 0) {
      $from = 0;
    }

    $client_data = Fcrm_Tributes_Api::get_tributes_sitemap($from);
    $tribute_items = [];
    if(isset($client_data) && isset($client_data->results)) {
      foreach($client_data->results as $client) {
        $tributePage = get_option('fcrm_tributes_single_page');
        $permalink = format_client_permalink($client, $tributePage);
        $tribute_items[] = [ "permalink" => $permalink ];
      }
    }
?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"; ?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    <?php foreach ($tribute_items as $tribute_item) { ?>
        <?php $tributeUrl = rawurlencode($tribute_item['permalink'] . '/'); ?>
        <?php $tributeUrl = str_replace("%2F", "/", $tributeUrl); ?>
        <?php $tributeUrl = str_replace("%3A", ":", $tributeUrl); ?>
        <url>
            <loc><?php echo $tributeUrl; ?></loc>
            <lastmod><?php echo date("Y-m-d\TH:i:sP"); ?></lastmod>
	    </url>
    <?php } ?>
</urlset>