<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       firehawkcrm.com
 * @since      1.0.0
 *
 * @package    Fcrm_Tributes
 * @subpackage Fcrm_Tributes/public/partials
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<?php
$fcrmDefaultImageUrl = get_option('fcrm_tributes_default_image');
$fcrmShowLocation = get_option('fcrm_tributes_show_location');
if (empty($fcrmShowLocation)) {
  $fcrmShowLocation = false;
} else if ($fcrmShowLocation == false || $fcrmShowLocation == '1') {
  $fcrmShowLocation = true;
} else {
  $fcrmShowLocation = false;
}
 ?>

<?php
if (function_exists('current_location') == false) {
  function current_location()
  {
      if (isset($_SERVER['HTTPS']) &&
          ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) ||
          isset($_SERVER['HTTP_X_FORWARDED_PROTO']) &&
          $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https') {
          $protocol = 'https://';
      } else {
          $protocol = 'http://';
      }
      return $protocol . $_SERVER['HTTP_HOST'];
  }
}
?>
<div class="firehawk-crm firehawk-crm-large-grid">
  <?php if (sizeof($clients) > 0): ?>
    <div class="firehawk-crm-large-grid-view">
      <?php foreach ($clients as $client): ?>
        <div class="grid-col">
          <?php $openModalId = 'fcrm-tributes-modal-'.uniqid(); ?>
          <div class="grid-item <?php echo $layout; ?> <?php if (isset($client->permalink) && $clickAction != "modal") { echo 'linked'; }?> <?php if ($clickAction == "modal") { echo 'modal-link'; }; ?>" data-modal-id="<?php echo $openModalId; ?>" <?php if (isset($client->permalink)) { echo 'data-link="'. current_location().'/'.$client->permalink.'"'; } ?> tabindex="0">
            <?php if ($layout === "compact" || $layout === "compact-large") {
              include(plugin_dir_path(__FILE__) . 'compact-grid-item.php');
            } else {
              include(plugin_dir_path(__FILE__) . 'basic-grid-item.php');
            }
            ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
    <div class="load-more-footer">
      <div class="load-more-button" type="button" tabindex="0">
        View more
      </div>
    </div>
    <div class="load-more-indicator" style="display: none;">
      <span class="fcrms-spinner primary"></span>
    </div>
  <?php else: ?>
    <div class="empty-message">
      No upcoming services
    </div>
  <?php endif; ?>
</div>


<script>
  var layout = "<?php echo $layout; ?>";
  var imageStyle = "<?php echo $imageStyle; ?>";
  var detailsPage = "<?php echo $detailPage; ?>";
  var searchRange = <?php echo json_encode($searchRange); ?>;
  var currentPage = 1
  var pageSize = <?php echo $pageSize; ?>;
  var onItemClickAction = "<?php echo $clickAction; ?>"

  function loadData(from) {
    jQuery(".firehawk-crm .load-more-indicator").show()
    jQuery(".firehawk-crm .load-more-footer").hide()
    jQuery.ajax({
  			method: 'post',
  			url: ajax_var.url,
  			data: {
  				action: 'large_grid_fetch_more',
          size: pageSize,
  				from: from || 0,
          layout: layout,
          detailsPage: detailsPage,
          imageStyle: imageStyle,
          "click-action": onItemClickAction,
          "range-months": searchRange.months ? +searchRange.months : null,
          "range-days": searchRange.days ? +searchRange.days : null,
          "range-hours": searchRange.hours ? +searchRange.hours : null,
  			}
  		}).done((response) => {
        jQuery(".firehawk-crm .load-more-indicator").hide()
        if (!response || !response.length) {
          jQuery(".firehawk-crm .load-more-footer").hide()
        } else {
          currentPage += 1
          let items = jQuery(response)
          if (items.length >= pageSize) {
            jQuery(".firehawk-crm .load-more-footer").show()
          }
          jQuery(".firehawk-crm .firehawk-crm-large-grid-view").append(response)
          observeItemClick()
        }
  		})
  };

  function openGridItemModal(item) {
    const modalId = jQuery(item).data("modal-id");
    if (!modalId) return;
    const itemModal = jQuery("#" + modalId)
    const modal = itemModal.modal()

    itemModal.find(".modal-close").on("click", function(e) {
      e.preventDefault()
      jQuery.modal.getCurrent().close();
    })

    itemModal.find(".close-modal").on("click", function(e) {
      e.preventDefault()
      jQuery.modal.getCurrent().close();
    })
  }

  function observeItemClick() {
    jQuery(".firehawk-crm .grid-item").on("click", function(e) {

      if (jQuery(e.target).parents(".service-button").length || (e.target && e.target.href && e.target.href.length)) {
        return
      }

      if (onItemClickAction == "modal") {
        if (jQuery(e.target).hasClass("top-img") == false) {
          return
        }
        event.preventDefault();
        this.blur();
        openGridItemModal(this)
      } else {
        const contentLink = jQuery(this).data("link")
        if (contentLink) {
          if (e.ctrlKey || e.metaKey) {
            window.open(contentLink, "_blank")
          } else {
            document.location = contentLink
          }
        }
      }
    })

    jQuery(".firehawk-crm .grid-item").on("keypress",function(e) {
      if (onItemClickAction == "modal") {
        if (jQuery(e.target).hasClass("top-img") == false) {
          return
        }
        event.preventDefault();
        this.blur();
        openGridItemModal(this)
      } else {
        const contentLink = jQuery(this).data("link")
        if (e.which == 13 && contentLink) {
          document.location = contentLink
        }
      }
    });
  }

  observeItemClick()

  jQuery(".firehawk-crm .load-more-footer").on("click", function() {
    loadData(pageSize * currentPage)
  })
</script>

<?php
if (function_exists('service_buttons_check') == false) {
  include( plugin_dir_path( __FILE__ ) . 'service-buttons-functions.php');
}
?>
