<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       firehawkcrm.com
 * @since      1.0.0
 *
 * @package    Fcrm_Tributes
 * @subpackage Fcrm_Tributes/public/partials
 */
?>
<?php
$fcrmDefaultImageUrl = get_option('fcrm_tributes_default_image');
$fcrmShowLocation = get_option('fcrm_tributes_show_location');
if (empty($fcrmShowLocation)) {
  $fcrmShowLocation = false;
} else if ($fcrmShowLocation == false || $fcrmShowLocation == '1') {
  $fcrmShowLocation = true;
} else {
  $fcrmShowLocation = false;
}
 ?>

<?php
if (function_exists('current_location') == false) {
  function current_location()
  {
      if (isset($_SERVER['HTTPS']) &&
          ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) ||
          isset($_SERVER['HTTP_X_FORWARDED_PROTO']) &&
          $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https') {
          $protocol = 'https://';
      } else {
          $protocol = 'http://';
      }
      return $protocol . $_SERVER['HTTP_HOST'];
  }
}
?>

<?php foreach ($clients as $client): ?>
  <div class="grid-col">
    <?php $openModalId = 'fcrm-tributes-modal-'.uniqid(); ?>
    <div class="grid-item <?php echo $layout; ?> <?php if (isset($client->permalink) && $clickAction != "modal") { echo 'linked'; }?> <?php if ($clickAction == "modal") { echo 'modal-link'; }; ?>" data-modal-id="<?php echo $openModalId; ?>" <?php if (isset($client->permalink)) { echo 'data-link="'. current_location().'/'.$client->permalink.'"'; } ?> tabindex="0">
      <?php if ($layout === "compact" || $layout === "compact-large") {
        include(plugin_dir_path(__FILE__) . 'compact-grid-item.php');
      } else {
        include(plugin_dir_path(__FILE__) . 'basic-grid-item.php');
      }
      ?>
    </div>
  </div>
<?php endforeach; ?>
