<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       firehawkcrm.com
 * @since      1.0.0
 *
 * @package    Fcrm_Tributes
 * @subpackage Fcrm_Tributes/public/partials
 */
?>
<?php

$dateLocale = get_option('fcrm_tributes_date_locale');

if (!$dateLocale || empty($dateLocale)) {
  $dateLocale = null;
}
$uniqueElementId = uniqid();
?>

<div class="firehawk-crm-tributes" id="fcrm-<?php echo $uniqueElementId ?>">
    <div class="search-options">
      <div class="date-picker">
        <div class="icon"><i class="far fa-calendar-alt"></i></div>
        <input class="form-control" id="datepicker" placeholder="Select Dates">
        <button class="btn reset-btn" type="reset" tabindex="-1"><i class="far fa-times-circle"></i></button>
      </div>
      <form class="fcrm-search-bar">
        <input class="form-control" type="search" id="grid-search" placeholder="Search...">
        <button class="btn reset-btn" type="reset" tabindex="-1"><i class="far fa-times-circle"></i></button>
        <button class="btn btn-primary submit-btn" type="submit">Search</button>
      </form>
    </div>
    <div class="firehawk-crm firehawk-crm-large-grid" id="tributes-list"></div>
    <div class="fcrm-pagination mb-4 text-center" id="fcrm-grid-pagination"></div>
</div>

<!-- <?php var_dump($userRoles); ?> -->

<script type="application/javascript">
(function( $ ) {
	'use strict';
  var size = <?php echo $size ? $size : 16; ?>;

  const entityList = new FirehawkCRMTributesGrid($('#fcrm-<?php echo $uniqueElementId ?> #tributes-list'), $('#fcrm-<?php echo $uniqueElementId ?> #fcrm-grid-pagination'))
  entityList.sortByService = <?php echo json_encode($sortByService); ?>;
  entityList.team = <?php echo json_encode($team); ?>;
  entityList.dateLocale = <?php echo json_encode($dateLocale); ?>;
  entityList.nameFormat = <?php echo json_encode($nameFormat); ?>;
  entityList.dateFormat = <?php echo json_encode($dateFormat); ?>;
  entityList.displayServiceInfo = <?php echo json_encode($displayServiceInfo); ?>;
  entityList.hideDateOfBirth = <?php echo json_encode($hideDateOfBirth); ?>;
  entityList.setupView(size)

  const datePicker = new Litepicker({
    element: document.getElementById('datepicker'),
    singleMode: false,
    plugins: ['mobilefriendly'],
    maxDays: 100,
    dropdowns: {
      minYear: 1980,
      years: true
    },
    format: "<?php echo $dateFormat != null ? $dateFormat : "DD-MM-YYYY" ?>",
    tooltipText: {
      one: 'day',
      other: 'days'
    },
    tooltipNumber: function(totalDays) {
      return totalDays - 1;
    },
    setup: (picker) => {
      picker.on('selected', function(date1, date2) {
       console.log(date1, date2)
       entityList.applyDateRange(date1.timestamp(), date2.timestamp())
       jQuery('#fcrm-<?php echo $uniqueElementId ?> .date-picker').addClass("has-value")
      });
    }
  })

  jQuery('#fcrm-<?php echo $uniqueElementId ?> .fcrm-search-bar').on("submit", function(e) {
    e.preventDefault()
    const value = jQuery('#fcrm-<?php echo $uniqueElementId ?> #grid-search').val()
    entityList.search(value);
  })

  jQuery('#fcrm-<?php echo $uniqueElementId ?> .fcrm-search-bar .submit-btn').on("click", function(e) {
    e.preventDefault()
    const value = jQuery('#fcrm-<?php echo $uniqueElementId ?> #grid-search').val()
    entityList.search(value);
  })

  jQuery('#fcrm-<?php echo $uniqueElementId ?> .fcrm-search-bar .reset-btn').on("click", function(e) {
    e.preventDefault()
    jQuery('#fcrm-<?php echo $uniqueElementId ?> #grid-search').val(null)
    entityList.search(null);
  })

  jQuery('#fcrm-<?php echo $uniqueElementId ?> .date-picker .reset-btn').on("click", function(e) {
    e.preventDefault()
    jQuery('#fcrm-<?php echo $uniqueElementId ?> #datepicker').val(null)
    jQuery('#fcrm-<?php echo $uniqueElementId ?> .date-picker').removeClass("has-value")
    entityList.applyDateRange(null, null)
    datePicker.clearSelection()
  })

  jQuery('#fcrm-<?php echo $uniqueElementId ?> .date-picker .form-control').on("change", function(e) {
    e.preventDefault()
    const value = jQuery('#fcrm-<?php echo $uniqueElementId ?> #datepicker').val()
    if (value) {
      jQuery('#fcrm-<?php echo $uniqueElementId ?> .date-picker').addClass("has-value")
    } else {
      jQuery('#fcrm-<?php echo $uniqueElementId ?> .date-picker').removeClass("has-value")
    }
  })


})( jQuery );

</script>
