<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       firehawkcrm.com
 * @since      1.0.0
 *
 * @package    Fcrm_Tributes
 * @subpackage Fcrm_Tributes/public/partials
 */
?>
<?php

$uniqueElementId = uniqid();

if (function_exists('current_location') == false) {
  function current_location()
  {
      if (isset($_SERVER['HTTPS']) &&
          ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) ||
          isset($_SERVER['HTTP_X_FORWARDED_PROTO']) &&
          $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https') {
          $protocol = 'https://';
      } else {
          $protocol = 'http://';
      }
      return $protocol . $_SERVER['HTTP_HOST'];
  }
}

$currentLocation = current_location();
?>

<div class="firehawk-crm-tributes firehawk-crm-tributes-carousel" id="fcrm-<?php echo $uniqueElementId ?>">
  <?php if (sizeof($clients) > 0): ?>
    <div class="glide">
      <div data-glide-el="track" class="glide__track">
        <ul class="glide__slides">
          <?php foreach ($clients as $client): ?>
          <li class="glide__slide">
            <?php
              $permalink = "";
              if (isset($client->permalink)) {
                $permalink = current_location() . '/' . $client->permalink;
              }
            ?>

            <div class="grid-item compact linked" data-link="<?php echo $permalink; ?>" tabindex="0">
                <?php include(plugin_dir_path(__FILE__) . 'compact-grid-item.php'); ?>
              </div>
          </li>
          <?php endforeach; ?>
        </ul>
      </div>
      <div class="glide__arrows" data-glide-el="controls">
        <button class="glide__arrow glide__arrow--left btn btn-outline-dark" data-glide-dir="<">Prev</button>
        <button class="glide__arrow glide__arrow--right btn btn-outline-dark" data-glide-dir=">">Next</button>
      </div>
    </div>
  <?php else: ?>
    <div class="empty-message">
      No recent tributes
    </div>
  <?php endif; ?>
</div>

<script type="application/javascript">
(function( $ ) {
	'use strict';

  const glideElement = $('#fcrm-<?php echo $uniqueElementId ?> .glide')
  if (glideElement.get(0)) {
    var glide = new Glide('#fcrm-<?php echo $uniqueElementId ?> .glide', {
      type: 'slider',
      perView: 3,
      gap: 20,
      startAt: 0,
      breakpoints: {
        800: {
          perView: 1
        },
        1140: {
          perView: 2
        }
      }
    })
  }


  glide.mount()

  function observeItemClick() {
    $('#fcrm-<?php echo $uniqueElementId ?> .glide .grid-item').on("click", function(e) {
      const contentLink = jQuery(this).data("link")
      if (contentLink && contentLink.length > 0) {
        if (e.ctrlKey || e.metaKey) {
          window.open(contentLink, "_blank")
        } else {
          document.location = contentLink
        }
      }
    })

    $('#fcrm-<?php echo $uniqueElementId ?> .glide .grid-item').on("keypress", function(e) {
      const contentLink = jQuery(this).data("link")
			if (event.which == 13 && contentLink && contentLink.length > 0) {
				document.location = contentLink
			}
    });
  }

  observeItemClick()
})( jQuery );

</script>
