"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var FirehawkCRMVerifyInput = /*#__PURE__*/function () {
  function FirehawkCRMVerifyInput(form) {
    var _this = this;

    _classCallCheck(this, FirehawkCRMVerifyInput);

    _defineProperty(this, "form", null);

    _defineProperty(this, "inputs", null);

    _defineProperty(this, "KEYBOARDS", {
      backspace: 8,
      arrowLeft: 37,
      arrowRight: 39
    });

    this.form = form;
    this.inputs = form.querySelectorAll('input');
    this.form.addEventListener('input', function (e) {
      _this.handleInput(e);
    });
    this.inputs[0].addEventListener('paste', function (e) {
      _this.handlePaste(e);
    });
    this.inputs.forEach(function (input) {
      input.addEventListener('focus', function (e) {
        setTimeout(function () {
          e.target.select();
        }, 0);
      });
      input.addEventListener('keydown', function (e) {
        switch (e.keyCode) {
          case _this.KEYBOARDS.backspace:
            _this.handleBackspace(e);

            break;

          case _this.KEYBOARDS.arrowLeft:
            _this.handleArrowLeft(e);

            break;

          case _this.KEYBOARDS.arrowRight:
            _this.handleArrowRight(e);

            break;

          default:
        }
      });
    });
  }

  _createClass(FirehawkCRMVerifyInput, [{
    key: "handleInput",
    value: function handleInput(e) {
      var input = e.target;
      var nextInput = input.nextElementSibling;

      if (nextInput && input.value) {
        nextInput.focus();

        if (nextInput.value) {
          nextInput.select();
        }
      }
    }
  }, {
    key: "handlePaste",
    value: function handlePaste(e) {
      e.preventDefault();
      var paste = e.clipboardData.getData('text');
      this.inputs.forEach(function (input, i) {
        input.value = paste[i] || '';
      });
    }
  }, {
    key: "handleBackspace",
    value: function handleBackspace(e) {
      var input = e.target;

      if (input.value) {
        input.value = '';
        return;
      }

      input.previousElementSibling.focus();
    }
  }, {
    key: "handleArrowLeft",
    value: function handleArrowLeft(e) {
      var previousInput = e.target.previousElementSibling;
      if (!previousInput) return;
      previousInput.focus();
    }
  }, {
    key: "handleArrowRight",
    value: function handleArrowRight(e) {
      var nextInput = e.target.nextElementSibling;
      if (!nextInput) return;
      nextInput.focus();
    }
  }, {
    key: "value",
    value: function value() {
      var value = "";
      this.inputs.forEach(function (input, i) {
        value += "".concat(input.value);
      });
      return value.trim();
    }
  }]);

  return FirehawkCRMVerifyInput;
}();