"use strict";

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Shuffle = window.Shuffle;

var FirehawkCRMServiceTribute = /*#__PURE__*/function () {
  function FirehawkCRMServiceTribute(element, pagination, messageModal, editModal, client) {
    _classCallCheck(this, FirehawkCRMServiceTribute);

    _defineProperty(this, "listElement", null);

    _defineProperty(this, "pagination", null);

    _defineProperty(this, "messageModal", null);

    _defineProperty(this, "editModal", null);

    _defineProperty(this, "loadingOverlay", null);

    _defineProperty(this, "entityType", null);

    _defineProperty(this, "category", null);

    _defineProperty(this, "randomSorting", null);

    _defineProperty(this, "randomSortKey", null);

    _defineProperty(this, "totalPages", 0);

    _defineProperty(this, "totalItems", 0);

    _defineProperty(this, "page", -1);

    _defineProperty(this, "pageSize", 12);

    _defineProperty(this, "nextPageButton", null);

    _defineProperty(this, "searchRequest", null);

    _defineProperty(this, "filterMyItems", false);

    _defineProperty(this, "actionModal", null);

    _defineProperty(this, "actionModalElement", null);

    _defineProperty(this, "team", null);

    _defineProperty(this, "client", null);

    _defineProperty(this, "pageItems", []);

    _defineProperty(this, "verifyCode", null);

    _defineProperty(this, "verifyId", null);

    _defineProperty(this, "tributeMessageData", null);

    _defineProperty(this, "verifyInput", null);

    _defineProperty(this, "editVerifyInput", null);

    _defineProperty(this, "shuffle", null);

    _defineProperty(this, "itemsWaiting", {});

    _defineProperty(this, "dateLocale", null);

    this.listElement = element;
    this.pagination = pagination;
    this.messageModal = messageModal;
    this.editModal = editModal;
    this.client = client;
    this.loadingOverlay = jQuery("<div class=\"loading-overlay\"><i class=\"far fa-spinner-third fa-spin\"></i></div>");
    this.listElement.addClass("loading");
    this.listElement.append(this.loadingOverlay);
    this.addListeners();
    this.verifyInput = new FirehawkCRMVerifyInput(jQuery(this.messageModal).find("#verify-form")[0]);
    this.editVerifyInput = new FirehawkCRMVerifyInput(jQuery(this.editModal).find("#verify-form")[0]);
    this.shuffle = new Shuffle(element, {
      itemSelector: '.grid-item',
      sizer: '.my-sizer-element'
    });
  }

  _createClass(FirehawkCRMServiceTribute, [{
    key: "buildItem",
    value: function buildItem(item) {
      var name = "";

      if (item.firstName) {
        name += item.firstName;

        if (item.lastName) {
          name += " " + item.lastName;
        }
      }

      var isLiked = false;
      var likesCount = item.likes > 0 ? item.likes : 0;

      if (this.getCookie("tribute-".concat(item.id, "-liked"))) {
        isLiked = true;
      }

      var title = "<div class=\"item-title\"><div class=\"title\"><h5>".concat(name, "</h5>");

      if (item.timestamp) {
        var dateTime = "";

        if (this.dateLocale && this.dateLocale == "en-US") {
          dateTime = moment(item.timestamp).format("MM/DD/YYYY");
        } else {
          dateTime = moment(item.timestamp).format("DD/MM/YYYY");
        }

        title += "<small class=\"item-date text-muted\">".concat(dateTime, "</small>");
      }

      title += "</div>";
      title += "<div class=\"actions\"><a class=\"edit-btn\"><i class=\"far fa-pencil\"></i></a></div>";
      title += "</div>";
      var itemMessage = (item.message || "").replace(/(?:\r\n|\r|\n)/g, '<br>');
      var message = "<div class=\"item-message\">".concat(itemMessage, "</div>");
      var footer = "<div class=\"item-footer\"><div class=\"likes\"><a class=\"like-btn ".concat(isLiked ? "liked" : "", "\"><i class=\"far fa-heart\"></i></a><span class=\"counter\">").concat(likesCount, "</span></div>");

      if (item.hasCandle) {
        footer += "<div class=\"candle\" style=\"".concat(item.candleColor ? "color: " + item.candleColor : "", "\"><i class=\"fak fa-long-candle-outline\"></i></div>");
      }

      footer += "</div>";
      var content = "\n\t\t\t<div class=\"item-view tribute-item\" id=\"tribute-item-".concat(item.id, "\" data-tribute-id=\"").concat(item.id, "\">\n\t\t\t\t<div class=\"row\">\n\t\t\t\t\t<div class=\"col\">\n\t\t\t\t\t\t<div class=\"item-content\">\n\t\t\t\t\t\t\t").concat(title, "\n\t\t\t\t\t\t\t").concat(message, "\n\t\t\t\t\t\t\t").concat(footer, "\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t");
      return content;
    }
  }, {
    key: "onEditItem",
    value: function onEditItem(item) {
      this.showEditMessageModal(item);
    }
  }, {
    key: "insertNewItem",
    value: function insertNewItem(item) {
      var _this = this;

      var gridItems = [];
      var view = this.buildItem(item);
      gridItems.push(jQuery("<div class=\"grid-item col-12 col-sm-6 col-lg-4\">".concat(view, "</div>")).get(0));
      gridItems.forEach(function (element) {
        jQuery(_this.listElement).prepend(element);
      });
      this.shuffle.add(gridItems);
      this.shuffle.update();
    }
  }, {
    key: "updateItemMessage",
    value: function updateItemMessage(id, message) {
      for (var _i2 = 0, _this$pageItems2 = this.pageItems; _i2 < _this$pageItems2.length; _i2++) {
        var item = _this$pageItems2[_i2];

        if (item.id == id) {
          item.message = message;
          break;
        }
      }
    }
  }, {
    key: "clearCurrentList",
    value: function clearCurrentList() {
      var items = _toConsumableArray(this.shuffle.items);

      this.shuffle.remove(items.map(function (e) {
        return e.element;
      }));
    }
  }, {
    key: "buildEntityListView",
    value: function buildEntityListView(items) {
      var _this2 = this;

      var gridItems = [];

      for (var _i4 = 0; _i4 < items.length; _i4++) {
        var item = items[_i4];
        var view = this.buildItem(item);
        gridItems.push(jQuery("<div class=\"grid-item col-12 col-sm-6 col-lg-4\">".concat(view, "</div>")).get(0));
      }

      gridItems.forEach(function (element) {
        jQuery(_this2.listElement).append(element);
      });
      this.shuffle.add(gridItems);
      this.shuffle.update();
    }
  }, {
    key: "addListeners",
    value: function addListeners() {
      var _this3 = this;

      jQuery(this.pagination).delegate('.fcrm-pagination-page', 'click', function (event) {
        event.preventDefault();
        var current = jQuery(event.currentTarget);
        var pageNumber = jQuery.trim(current.attr('data-num'));
        if (!pageNumber || current.hasClass('disabled') || current.hasClass('active')) return;
        var newPage = pageNumber - 1;

        _this3.getEntities(_this3.pageSize * newPage);
      }); // Previous button click

      jQuery(this.pagination).delegate('.fcrm-pagination-previous', 'click', function (event) {
        event.preventDefault();
        var current = jQuery(event.currentTarget);
        var pageNumber = jQuery.trim(current.attr('data-num'));
        if (!pageNumber || current.hasClass('disabled')) return;
        var newPage = pageNumber - 1;

        _this3.getEntities(_this3.pageSize * newPage);
      }); // Next button click

      jQuery(this.pagination).delegate('.fcrm-pagination-next', 'click', function (event) {
        event.preventDefault();
        var current = jQuery(event.currentTarget);
        var pageNumber = jQuery.trim(current.attr('data-num'));
        if (!pageNumber || current.hasClass('disabled')) return;
        var newPage = pageNumber - 1;

        _this3.getEntities(_this3.pageSize * newPage);
      });
      jQuery(this.listElement).delegate(".tribute-item .edit-btn", "click", function (event) {
        var item = jQuery(event.currentTarget);
        var tributeId = item.parents(".tribute-item").data("tribute-id");
        console.log(tributeId);
        if (!tributeId) return;

        var tribute = _this3.pageItems.filter(function (item) {
          return item.id == tributeId;
        })[0];

        if (tribute) {
          _this3.onEditItem(tribute);
        }

        console.log(tribute);
      });
      jQuery(this.listElement).delegate(".tribute-item .like-btn", "click", function (event) {
        var item = jQuery(event.currentTarget);
        var tributeId = item.parents(".tribute-item").data("tribute-id");
        if (_this3.itemsWaiting[tributeId]) return;

        if (item.hasClass("liked")) {
          item.removeClass("liked");

          _this3.setCookie("tribute-".concat(tributeId, "-liked"), "false", -1);

          _this3.unlikeTributeMessage(tributeId);
        } else {
          item.addClass("liked"); // 24 hours x 30 = 30 days

          var cookieExpiry = 24 * 30;

          _this3.setCookie("tribute-".concat(tributeId, "-liked"), "true", cookieExpiry);

          _this3.likeTributeMessage(tributeId);
        }
      });
    }
  }, {
    key: "getEvent",
    value: function getEvent(eventId) {
      if (!eventId || !eventId.length) return null;
      return this.pageItems.filter(function (e) {
        return e.id == eventId;
      })[0];
    }
  }, {
    key: "handleEventAction",
    value: function handleEventAction(action, eventId, hostId) {
      var eventItem = this.getEvent(eventId);
      if (!eventItem) return;
      var clientId = null;

      if (typeof eventItem.client == "string") {
        clientId = eventItem.client;
      } else if (eventItem.client && eventItem.client.key) {
        clientId = eventItem.client.key;
      }

      switch (action) {
        case "send-quote":
          this.showSendQuoteModal(eventItem, clientId);
          break;

        default:
          break;
      }
    }
  }, {
    key: "getEntities",
    value: function getEntities(from) {
      var _this4 = this;

      if (!this.client) {
        this.listElement.removeClass("loading");
        this.loadingOverlay.remove();
        return;
      }

      this.listElement.addClass("loading");
      this.listElement.append(this.loadingOverlay);
      var params = {
        size: this.pageSize || 16,
        from: from || 0,
        client: this.client || null
      };
      var page = (from || 0) / this.pageSize || 0;
      this.page = page;

      if (this.searchRequest) {
        this.searchRequest.abort();
      }

      this.searchRequest = jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'get_tribute_messages',
          params: params
        }
      }).done(function (response) {
        var results = [];
        var total = 0;

        if (response) {
          var data = JSON.parse(response);

          if (data && data.results) {
            total = data.total || 0;
            results = data.results;
          }
        }

        _this4.totalItems = total;
        _this4.totalPages = Math.ceil(total / _this4.pageSize);
        _this4.pageItems = results;

        _this4.clearCurrentList();

        _this4.updatePagination();

        _this4.buildEntityListView(results);

        if (!results.length) {
          _this4.showEmptyListView();
        }

        _this4.loadingOverlay.remove();

        _this4.listElement.removeClass("loading");
      }).fail(function () {
        this.listElement.removeClass("loading");
      });
    }
  }, {
    key: "showEmptyListView",
    value: function showEmptyListView() {
      var emptyView = jQuery("<div class=\"empty-view\">No results found</div>");
      jQuery(this.listElement).html(emptyView);
    }
  }, {
    key: "updatePagination",
    value: function updatePagination() {
      if (!this.pagination) return;
      var self = this;
      var currentPage = self.page + 1;
      var pageRange = 2;
      var totalPage = self.totalPages;
      var rangeStart = currentPage - pageRange;
      var rangeEnd = currentPage + pageRange;

      if (rangeEnd > totalPage) {
        rangeEnd = totalPage;
        rangeStart = totalPage - pageRange * 2;
        rangeStart = rangeStart < 1 ? 1 : rangeStart;
      }

      if (rangeStart <= 1) {
        rangeStart = 1;
        rangeEnd = Math.min(pageRange * 2 + 1, totalPage);
      }

      var pageLink = '';
      var prevText = '&laquo;';
      var nextText = '&raquo;';
      var ellipsisText = '...';
      var activeClassName = 'active';
      var disableClassName = 'disabled';
      var showFirstOnEllipsisShow = true;
      var showLastOnEllipsisShow = true;
      var html = '';
      var i; // Whether to display header

      html += '<div class="fcrm-pagination-pages">';
      html += '<ul>'; // Whether to display the Previous button

      if (currentPage <= 1) {} else {
        html += '<li class="fcrm-pagination-previous" data-num="' + (currentPage - 1) + '" title="Previous page"><a href="' + pageLink + '">' + prevText + '<\/a><\/li>';
      } // Whether to display the pages


      if (rangeStart <= 3) {
        for (i = 1; i < rangeStart; i++) {
          if (i == currentPage) {
            html += '<li class="fcrm-pagination-page ' + activeClassName + '" data-num="' + i + '"><a>' + i + '<\/a><\/li>';
          } else {
            html += '<li class="fcrm-pagination-page" data-num="' + i + '"><a href="' + pageLink + '">' + i + '<\/a><\/li>';
          }
        }
      } else {
        if (showFirstOnEllipsisShow) {
          html += '<li class="fcrm-pagination-first fcrm-pagination-page" data-num="1"><a href="' + pageLink + '">1<\/a><\/li>';
        }

        html += '<li class="fcrm-pagination-ellipsis ' + disableClassName + '"><a>' + ellipsisText + '<\/a><\/li>';
      }

      for (i = rangeStart; i <= rangeEnd; i++) {
        if (i == currentPage) {
          html += '<li class="fcrm-pagination-page ' + activeClassName + '" data-num="' + i + '"><a>' + i + '<\/a><\/li>';
        } else {
          html += '<li class="fcrm-pagination-page" data-num="' + i + '"><a href="' + pageLink + '">' + i + '<\/a><\/li>';
        }
      }

      if (rangeEnd >= totalPage - 2) {
        for (i = rangeEnd + 1; i <= totalPage; i++) {
          html += '<li class="fcrm-pagination-page" data-num="' + i + '"><a href="' + pageLink + '">' + i + '<\/a><\/li>';
        }
      } else {
        html += '<li class="fcrm-pagination-ellipsis ' + disableClassName + '"><a>' + ellipsisText + '<\/a><\/li>';

        if (showLastOnEllipsisShow) {
          html += '<li class="fcrm-pagination-last fcrm-pagination-page" data-num="' + totalPage + '"><a href="' + pageLink + '">' + totalPage + '<\/a><\/li>';
        }
      }

      if (currentPage >= totalPage) {} else {
        html += '<li class="fcrm-pagination-next" data-num="' + (currentPage + 1) + '" title="Next page"><a href="' + pageLink + '">' + nextText + '<\/a><\/li>';
      }

      html += '<\/ul><\/div>';

      if (totalPage > 1) {
        jQuery(this.pagination).html(html);
      } else {
        jQuery(this.pagination).html();
      }
    }
  }, {
    key: "reloadView",
    value: function reloadView(from) {
      this.buildEntityListView([]);
      this.getEntities(from);
    }
  }, {
    key: "setupView",
    value: function setupView(category, size) {
      this.pageSize = size ? +size : 16;
      this.category = category;
      this.reloadView(0);
    }
  }, {
    key: "resetTributesModal",
    value: function resetTributesModal() {
      if (!this.actionModalElement) return;
      this.actionModalElement.undelegate();
      this.actionModalElement.find("form .modal-footer .submit-btn").prop("disabled", false).html("Submit");
      this.actionModalElement.find("#tribute-form").show().trigger("reset");
      this.actionModalElement.find("#verify-form").hide().trigger("reset");
      this.tributeMessageData = null;
      this.verifyCode = null;
    }
  }, {
    key: "closeActionModal",
    value: function closeActionModal() {
      var destroy = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

      if (this.actionModal) {
        this.actionModal.hide();
      }

      this.actionModal = null;
      this.resetTributesModal();
    }
  }, {
    key: "showWriteMessageModal",
    value: function showWriteMessageModal() {
      var _this5 = this;

      this.closeActionModal(true);
      var modalElement = jQuery(this.messageModal);
      this.actionModalElement = modalElement;
      this.actionModal = new bootstrap.Modal(document.getElementById(modalElement.attr('id')), {});
      this.actionModal.show();
      this.actionModalElement.delegate(".action-modal .close-modal-btn", "click", function (event) {
        _this5.closeActionModal();

        _this5.resetTributesModal();
      });
      this.actionModalElement.on('hidden.bs.modal', function (event) {
        _this5.resetTributesModal();
      });
      this.actionModalElement.delegate("form#tribute-form", "submit", function (event) {
        event.preventDefault();
        var form = jQuery(event.target);
        form.find(".error-callout").hide().html("");

        if (!_this5.team || !_this5.team.length || !_this5.client) {
          form.find(".error-callout").show().html("Something went wrong, please try again.");
          return;
        }

        var submitButton = form.find(".modal-footer .submit-btn");
        submitButton.prop("disabled", true);
        submitButton.html("<span class=\"spinner-border spinner-border-sm\" role=\"status\" aria-hidden=\"true\">");
        var formData = new FormData(event.target);
        formData.append("client", _this5.client);
        formData.append("team", _this5.team);
        _this5.tributeMessageData = formData;

        if (form.find("#candleRow").hasClass("show")) {
          formData.append("hasCandle", true);
        } else {
          formData["delete"]("candleColor");
        }

        _this5.requestVerificationCode(formData.get("email"));
      });
      this.actionModalElement.delegate("form#tribute-form .candle-color-picker input", "change", function (event) {
        var input = jQuery(event.target);

        _this5.actionModalElement.find("form#tribute-form .candle").css("color", input.val());
      });
      this.actionModalElement.delegate("form#tribute-form .toggle-candle-btn", "click", function (event) {
        var input = jQuery(event.target);

        _this5.actionModalElement.find("form#tribute-form .candle").css("color", input.val());
      });
      var candleCollapse = this.actionModalElement.find("form#tribute-form #candleRow").get(0);

      if (candleCollapse) {
        candleCollapse.addEventListener('hide.bs.collapse', function () {
          _this5.actionModalElement.find("form#tribute-form .toggle-candle-btn").html("Add Candle");
        });
        candleCollapse.addEventListener('show.bs.collapse', function () {
          _this5.actionModalElement.find("form#tribute-form .toggle-candle-btn").html("Remove Candle");
        });
      }

      this.actionModalElement.delegate("form#verify-form", "submit", function (event) {
        event.preventDefault();
        var form = jQuery(event.target);
        form.find(".error-callout").hide().html("");

        if (!_this5.team || !_this5.team.length || !_this5.client) {
          form.find(".error-callout").show().html("Something went wrong, please try again.");
          return;
        }

        var submitButton = form.find(".modal-footer .submit-btn");
        submitButton.prop("disabled", true);
        submitButton.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true">');
        var formData = new FormData(event.target);

        var verifyCode = _this5.verifyInput.value();

        if (verifyCode == "".concat(_this5.verifyCode) && _this5.verifyCode != null) {
          _this5.createTributeMessage(_this5.tributeMessageData);
        } else {
          form.find(".error-callout").show().html("Verification code is invalid");
          submitButton.prop("disabled", false);
          submitButton.html("Submit");
        }
      });
    }
  }, {
    key: "createTributeMessage",
    value: function createTributeMessage(formData) {
      var _this6 = this;

      formData.append("action", "create_tribute_message");
      jQuery.ajax({
        type: "POST",
        url: ajax_var.url,
        data: formData,
        contentType: false,
        cache: false,
        processData: false
      }).done(function (response) {
        if (!response) {
          _this6.actionModalElement.find("#verify-form .error-callout").show().html("Error: Unknown error");
        } else {
          var data = JSON.parse(response);

          if (data && data.error) {
            var errorMessage = data.error || "Unknown error";

            _this6.actionModalElement.find("#verify-form .error-callout").show().html("Error: " + errorMessage);
          } else if (data && data.status == "Published") {
            _this6.insertNewItem(data);

            _this6.closeActionModal(true);
          } else {
            _this6.closeActionModal(true);
          }
        }
      }).fail(function (error) {
        if (error.responseJSON) {
          var errorMessage = error.responseJSON.error || error.responseJSON.message || "";

          _this6.actionModalElement.find("#verify-form .error-callout").show().html("Error: " + errorMessage);
        } else {
          _this6.actionModalElement.find("#verify-form .error-callout").show().html("Something went wrong, please try again.");
        }
      }).always(function () {
        var submitButton = _this6.actionModalElement.find("#verify-form .modal-footer .submit-btn");

        submitButton.prop("disabled", false);
        submitButton.html("Submit");
      });
    }
  }, {
    key: "showVerificationModal",
    value: function showVerificationModal() {
      if (!this.actionModalElement) return;
      this.actionModalElement.find("#tribute-form").hide();
      this.actionModalElement.find("#verify-form").show();
    }
  }, {
    key: "requestVerificationCode",
    value: function requestVerificationCode(email) {
      var _this7 = this;

      jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'verify_tribute_email',
          params: {
            client: this.client,
            teamId: this.team,
            email: email
          }
        }
      }).done(function (response) {
        if (response) {
          var data = JSON.parse(response);

          if (data && data.code) {
            _this7.verifyCode = data.code;

            _this7.showVerificationModal();
          } else {}

          console.log(data);
        }
      }).fail(function () {}).always(function () {
        var submitButton = _this7.actionModalElement.find("#tribute-form .modal-footer .submit-btn");

        submitButton.prop("disabled", false);
        submitButton.html("Submit");
      });
    }
  }, {
    key: "formDataToJSON",
    value: function formDataToJSON(formData) {
      var convertedJSON = {};
      formData.forEach(function (value, key) {
        if (!value || value.length == 0) {} else {
          convertedJSON[key] = value;
        }
      });
      return convertedJSON;
    } // Edit message

  }, {
    key: "showEditMessageModal",
    value: function showEditMessageModal(tribute) {
      var _this8 = this;

      this.closeActionModal(true);
      var tributeId = tribute.id;
      var modalElement = jQuery(this.editModal);
      this.actionModalElement = modalElement;
      this.actionModal = new bootstrap.Modal(document.getElementById(modalElement.attr('id')), {});
      this.actionModal.show();
      modalElement.find("textarea#message").val(tribute.message);
      this.actionModalElement.delegate(".close-modal-btn", "click", function (event) {
        _this8.closeActionModal();

        _this8.resetTributesModal();
      });
      this.actionModalElement.on('hidden.bs.modal', function (event) {
        _this8.resetTributesModal();
      });
      this.actionModalElement.delegate("form#tribute-form", "submit", function (event) {
        event.preventDefault();
        var form = jQuery(event.target);
        form.find(".error-callout").hide().html("");

        if (!_this8.team || !_this8.team.length || !_this8.client) {
          form.find(".error-callout").show().html("Something went wrong, please try again.");
          return;
        }

        var submitButton = form.find(".modal-footer .submit-btn");
        submitButton.prop("disabled", true);
        submitButton.html("<span class=\"spinner-border spinner-border-sm\" role=\"status\" aria-hidden=\"true\">");
        var formData = new FormData(event.target);
        formData.append("team", _this8.team);
        formData.append("id", tributeId);
        _this8.tributeMessageData = formData;

        _this8.requestEditVerificationCode(tributeId);
      });
      this.actionModalElement.delegate("form#tribute-form .candle-color-picker input", "change", function (event) {
        var input = jQuery(event.target);
        console.log(input.val());

        _this8.actionModalElement.find("form#tribute-form .candle").css("color", input.val());
      });
      this.actionModalElement.delegate("form#verify-form", "submit", function (event) {
        event.preventDefault();
        var form = jQuery(event.target);
        form.find(".error-callout").hide().html("");

        if (!_this8.team || !_this8.team.length || !_this8.client) {
          form.find(".error-callout").show().html("Something went wrong, please try again.");
          return;
        }

        var submitButton = form.find(".modal-footer .submit-btn");
        submitButton.prop("disabled", true);
        submitButton.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true">');
        var formData = new FormData(event.target);

        var verifyCode = _this8.editVerifyInput.value();

        jQuery.ajax({
          method: 'post',
          url: ajax_var.url,
          data: {
            action: 'verify_tribute_code',
            params: {
              code: verifyCode,
              id: _this8.verifyId
            }
          }
        }).done(function (response) {
          var success = false;

          if (response) {
            var data = JSON.parse(response);
            console.log(data);

            if (data && data.success) {
              success = true;
            }
          }

          if (success) {
            _this8.updateTributeMessage(_this8.tributeMessageData);
          } else {
            form.find(".error-callout").show().html("Verification code is invalid");
            submitButton.prop("disabled", false);
            submitButton.html("Submit");
          }
        }).fail(function () {
          form.find(".error-callout").show().html("Verification code is invalid");
          submitButton.prop("disabled", false);
          submitButton.html("Submit");
        });
      });
    }
  }, {
    key: "updateTributeMessage",
    value: function updateTributeMessage(formData) {
      var _this9 = this;

      var tributeId = formData.get("id") || "";
      var tributeItem = jQuery(this.listElement).find("#tribute-item-".concat(tributeId, " .item-message"));
      formData.append("action", "edit_tribute_message");
      jQuery.ajax({
        type: "POST",
        url: ajax_var.url,
        data: formData,
        contentType: false,
        cache: false,
        processData: false
      }).done(function (response) {
        if (!response) {
          _this9.actionModalElement.find("#verify-form .error-callout").show().html("Error: Unknown error");
        } else {
          tributeItem.html(formData.get("message"));

          _this9.updateItemMessage(tributeId, formData.get("message"));

          _this9.closeActionModal(true);

          _this9.shuffle.update();
        }
      }).fail(function (error) {
        if (error.responseJSON) {
          var errorMessage = error.responseJSON.error || error.responseJSON.message || "";

          _this9.actionModalElement.find("#verify-form .error-callout").show().html("Error: " + errorMessage);
        } else {
          _this9.actionModalElement.find("#verify-form .error-callout").show().html("Something went wrong, please try again.");
        }
      }).always(function () {
        var submitButton = _this9.actionModalElement.find("#verify-form .modal-footer .submit-btn");

        submitButton.prop("disabled", false);
        submitButton.html("Submit");
      });
    }
  }, {
    key: "verifyEditTributeCode",
    value: function verifyEditTributeCode() {
      jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'verify_tribute_code',
          params: {
            code: this.verifyInput.value()
          }
        }
      }).done(function (response) {
        if (response) {
          var data = JSON.parse(response);
          console.log(data);
        }
      }).fail(function () {}).always(function () {// const submitButton = this.actionModalElement.find("#tribute-form .modal-footer .submit-btn")
        // submitButton.prop("disabled", false);
        // submitButton.html("Submit")
      });
    }
  }, {
    key: "requestEditVerificationCode",
    value: function requestEditVerificationCode(tributeId) {
      var _this10 = this;

      jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'verify_edit_tribute_email',
          params: {
            id: tributeId
          }
        }
      }).done(function (response) {
        if (response) {
          var data = JSON.parse(response);

          if (data && data.id) {
            _this10.verifyId = data.id;

            _this10.showVerificationModal();
          }
        }
      }).fail(function () {}).always(function () {// const submitButton = this.actionModalElement.find("#tribute-form .modal-footer .submit-btn")
        // submitButton.prop("disabled", false);
        // submitButton.html("Submit")
      });
    } // Likes

  }, {
    key: "likeTributeMessage",
    value: function likeTributeMessage(id) {
      var _this11 = this;

      if (this.itemsWaiting[id]) return;
      this.itemsWaiting[id] = true;
      jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'like_tribute_message',
          params: {
            id: id
          }
        }
      }).done(function (response) {
        var newLikesCount = null;

        if (response) {
          var data = JSON.parse(response);

          if (data && data.success && data.likes != null) {
            newLikesCount = data.likes;
            jQuery("#tribute-item-".concat(id, " .likes .counter")).html("".concat(newLikesCount));
          }
        }

        _this11.itemsWaiting[id] = null;
      }).fail(function (error) {
        this.itemsWaiting[id] = null;
      });
    }
  }, {
    key: "unlikeTributeMessage",
    value: function unlikeTributeMessage(id) {
      var _this12 = this;

      if (this.itemsWaiting[id]) return;
      this.itemsWaiting[id] = true;
      jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'unlike_tribute_message',
          params: {
            id: id
          }
        }
      }).done(function (response) {
        var newLikesCount = null;

        if (response) {
          var data = JSON.parse(response);

          if (data && data.success && data.likes != null) {
            newLikesCount = data.likes;
            jQuery("#tribute-item-".concat(id, " .likes .counter")).html("".concat(newLikesCount));
          }
        }

        _this12.itemsWaiting[id] = null;
      }).fail(function (error) {
        this.itemsWaiting[id] = null;
      });
    }
  }, {
    key: "setCookie",
    value: function setCookie(cname, cvalue, hours) {
      var d = new Date();
      d.setTime(d.getTime() + hours * 60 * 60 * 1000);
      var expires = "expires=" + d.toUTCString();
      document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }
  }, {
    key: "getCookie",
    value: function getCookie(cname) {
      var name = cname + "=";
      var decodedCookie = decodeURIComponent(document.cookie);
      var ca = decodedCookie.split(';');

      for (var i = 0; i < ca.length; i++) {
        var c = ca[i];

        while (c.charAt(0) == ' ') {
          c = c.substring(1);
        }

        if (c.indexOf(name) == 0) {
          return c.substring(name.length, c.length);
        }
      }

      return "";
    }
  }]);

  return FirehawkCRMServiceTribute;
}();