"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var FirehawkCRMTributesGrid = /*#__PURE__*/function () {
  function FirehawkCRMTributesGrid(element, pagination) {
    _classCallCheck(this, FirehawkCRMTributesGrid);

    _defineProperty(this, "listElement", null);

    _defineProperty(this, "pagination", null);

    _defineProperty(this, "loadingOverlay", null);

    _defineProperty(this, "totalPages", 0);

    _defineProperty(this, "totalItems", 0);

    _defineProperty(this, "page", -1);

    _defineProperty(this, "pageSize", 16);

    _defineProperty(this, "searchRequest", null);

    _defineProperty(this, "team", null);

    _defineProperty(this, "pageItems", []);

    _defineProperty(this, "defaultImageUrl", null);

    _defineProperty(this, "query", null);

    _defineProperty(this, "dateLocale", null);

    _defineProperty(this, "startDate", null);

    _defineProperty(this, "endDate", null);

    _defineProperty(this, "sortByService", false);

    _defineProperty(this, "nameFormat", null);

    _defineProperty(this, "hideDateOfBirth", false);

    _defineProperty(this, "dateFormat", "");

    this.listElement = element;
    this.pagination = pagination;
    this.loadingOverlay = jQuery("<div class=\"loading-overlay\"><i class=\"far fa-spinner-third fa-spin\"></i></div>");
    this.listElement.addClass("loading");
    this.listElement.append(this.loadingOverlay);
    this.addListeners();
  }

  _createClass(FirehawkCRMTributesGrid, [{
    key: "buildItem",
    value: function buildItem(item) {
      var displayImageView = "";
      var titleContainer = "";
      var displayImage = item.displayImage || this.defaultImageUrl;

      if (displayImage && displayImage.length) {
        displayImageView = "<div class=\"top-img image-basic\" style=\"background-image: url('".concat(displayImage, "')\"></div>");
      } else {
        displayImageView = '<div class="top-img placeholder image-basic" style="background: #f1f1f1;"></div>';
      }

      titleContainer += "<div class=\"title\">".concat(item.fullName, "</div>");

      if (!this.hideDateOfBirth && item.dateOfBirth && item.dateOfDeath) {
        var dob = "";
        var dod = "";
        var dFormat = "";

        if (this.dateLocale && this.dateLocale == "en-US") {
          dFormat = "MM/DD/YYYY";
        } else {
          dFormat = "DD/MM/YYYY";
        }

        if (this.dateFormat && this.dateFormat.length) {
          dFormat = this.dateFormat;
        }

        dob = moment(item.dateOfBirth).format(dFormat);
        dod = moment(item.dateOfDeath).format(dFormat);
        titleContainer += "<div class=\"dates\">".concat(dob, " - ").concat(dod, "</div>");
      } else if (item.dateOfDeath) {
        var dod = "";
        var _dFormat = "";

        if (this.dateLocale && this.dateLocale == "en-US") {
          _dFormat = "MM/DD/YYYY";
        } else {
          _dFormat = "DD/MM/YYYY";
        }

        if (this.dateFormat && this.dateFormat.length) {
          _dFormat = this.dateFormat;
        }

        dod = moment(item.dateOfDeath).format(_dFormat);
        titleContainer += "<div class=\"dates\">".concat(dod, "</div>");
      }

      var serviceInfo = "";

      if (this.displayServiceInfo == true) {
        if (item.serviceEvent && item.serviceEvent.dateTime && this.isAfterToday(new Date(item.serviceEvent.dateTime))) {
          var serviceDate = new Date(item.serviceEvent.dateTime);
          var date = "";
          var options = {
            weekday: 'short',
            year: 'numeric',
            month: 'short',
            day: 'numeric'
          };

          if (this.dateLocale) {
            date = serviceDate.toLocaleDateString(this.dateLocale, options) + " at " + serviceDate.toLocaleTimeString(this.dateLocale, {
              hour: "numeric",
              minute: "numeric"
            });
          } else {
            date = serviceDate.toLocaleDateString(options) + " at " + serviceDate.toLocaleTimeString({
              hour: "numeric",
              minute: "numeric"
            });
          }

          serviceInfo = "<div class=\"service-info\">Service: ".concat(date, "</div>");
        } else {
          serviceInfo = "<div class=\"service-info\">No Upcoming Services</div>";
        }
      }

      var permalink = null;

      if (item.permalink) {
        permalink = item.permalink;
      }

      var content = "\n\t\t\t<div class=\"grid-item compact ".concat(permalink ? "linked" : "", "\" id=\"grid-item-").concat(item.id, "\" data-grid-id=\"").concat(item.id, "\" tabindex=\"0\" ").concat(permalink ? "data-link=\"".concat(permalink, "\"") : "", " tabindex=\"0\">\n\t\t\t\t<div class=\"top-content\">\n\t\t\t\t\t\t").concat(displayImageView, "\n\t\t\t\t\t\t<div class=\"title-container\">").concat(titleContainer, "</div>\n\t\t\t\t</div>\n\t\t\t\t").concat(serviceInfo, "\n\t\t\t</div>\n\t\t");
      return content;
    }
  }, {
    key: "isAfterToday",
    value: function isAfterToday(date) {
      var today = new Date();
      today.setHours(23, 59, 59, 998);
      return date > today;
    }
  }, {
    key: "buildEntityListView",
    value: function buildEntityListView(items) {
      var gridItems = "";

      for (var _i2 = 0; _i2 < items.length; _i2++) {
        var item = items[_i2];
        var view = this.buildItem(item);
        gridItems += "<div class=\"grid-col\">".concat(view, "</div>");
      }

      var content = "\n\t\t<div class=\"firehawk-crm-large-grid-view\">\n\t\t\t\t".concat(gridItems, "\n\t\t</div>\n\t\t");
      jQuery(this.listElement).html(content);
    }
  }, {
    key: "addListeners",
    value: function addListeners() {
      var _this = this;

      jQuery(this.pagination).delegate('.fcrm-pagination-page', 'click', function (event) {
        event.preventDefault();
        var current = jQuery(event.currentTarget);
        var pageNumber = jQuery.trim(current.attr('data-num'));
        if (!pageNumber || current.hasClass('disabled') || current.hasClass('active')) return;
        var newPage = pageNumber - 1;

        _this.getEntities(_this.pageSize * newPage);
      }); // Previous button click

      jQuery(this.pagination).delegate('.fcrm-pagination-previous', 'click', function (event) {
        event.preventDefault();
        var current = jQuery(event.currentTarget);
        var pageNumber = jQuery.trim(current.attr('data-num'));
        if (!pageNumber || current.hasClass('disabled')) return;
        var newPage = pageNumber - 1;

        _this.getEntities(_this.pageSize * newPage);
      }); // Next button click

      jQuery(this.pagination).delegate('.fcrm-pagination-next', 'click', function (event) {
        event.preventDefault();
        var current = jQuery(event.currentTarget);
        var pageNumber = jQuery.trim(current.attr('data-num'));
        if (!pageNumber || current.hasClass('disabled')) return;
        var newPage = pageNumber - 1;

        _this.getEntities(_this.pageSize * newPage);
      });
      jQuery(this.listElement).delegate(".grid-item", "click", function (event) {
        var contentLink = jQuery(event.currentTarget).data("link");

        if (contentLink) {
          if (event.ctrlKey || event.metaKey) {
            window.open(contentLink, "_blank");
          } else {
            document.location = contentLink;
          }
        }
      });
      jQuery(this.listElement).delegate(".grid-item", "keypress", function (event) {
        var contentLink = jQuery(event.currentTarget).data("link");

        if (event.which == 13 && contentLink) {
          document.location = contentLink;
        }
      });
    }
  }, {
    key: "getEvent",
    value: function getEvent(eventId) {
      if (!eventId || !eventId.length) return null;
      return this.pageItems.filter(function (e) {
        return e.id == eventId;
      })[0];
    }
  }, {
    key: "getEntities",
    value: function getEntities(from) {
      var _this2 = this;

      this.listElement.addClass("loading");
      this.listElement.append(this.loadingOverlay);
      var params = {
        size: this.pageSize || 16,
        from: from || 0
      };

      if (this.displayServiceInfo == true) {
        params.displayService = true;
      }

      if (this.nameFormat && this.nameFormat.length) {
        params["nameFormat"] = this.nameFormat;
      }

      if (this.query) {
        params["query"] = this.query;
      }

      if (this.startDate) {
        params["startDate"] = this.startDate;
      }

      if (this.endDate) {
        params["endDate"] = this.endDate;
      }

      if (this.sortByService == true) {
        params["sortByService"] = true;
      }

      var page = (from || 0) / this.pageSize || 0;
      this.page = page;

      if (this.searchRequest) {
        this.searchRequest.abort();
      }

      this.searchRequest = jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'get_tributes',
          params: params
        }
      }).done(function (response) {
        var results = [];
        var total = 0;

        if (response) {
          var data = JSON.parse(response);

          if (data && data.results) {
            total = data.total || 0;
            results = data.results;
          }
        }

        _this2.totalItems = total;
        _this2.totalPages = Math.ceil(total / _this2.pageSize);
        _this2.pageItems = results;

        _this2.updatePagination();

        _this2.buildEntityListView(results);

        if (!results.length) {
          _this2.showEmptyListView();
        }
      }).fail(function () {
        _this2.loadingOverlay.hide();

        _this2.listElement.removeClass("loading");
      });
    }
  }, {
    key: "showEmptyListView",
    value: function showEmptyListView() {
      var emptyView = jQuery("<div class=\"empty-view\">No results found</div>");
      jQuery(this.listElement).html(emptyView);
    }
  }, {
    key: "getEventActions",
    value: function getEventActions(eventId) {
      var actions = [];

      if (!this.filterMyItems && this.user && this.user.roles) {
        var hasRole = false;

        for (var i in this.user.roles) {
          var index = +i;
          var role = this.user.roles[index];

          if (role == "supplier") {
            hasRole = true;
            break;
          }
        }

        if (hasRole) {
          actions.push({
            action: "send-quote",
            title: "Send Quote"
          });
        }
      }

      return actions;
    }
  }, {
    key: "updatePagination",
    value: function updatePagination() {
      if (!this.pagination) return;
      var self = this;
      var currentPage = self.page + 1;
      var pageRange = 2;
      var totalPage = self.totalPages;
      var rangeStart = currentPage - pageRange;
      var rangeEnd = currentPage + pageRange;

      if (rangeEnd > totalPage) {
        rangeEnd = totalPage;
        rangeStart = totalPage - pageRange * 2;
        rangeStart = rangeStart < 1 ? 1 : rangeStart;
      }

      if (rangeStart <= 1) {
        rangeStart = 1;
        rangeEnd = Math.min(pageRange * 2 + 1, totalPage);
      }

      var pageLink = '';
      var prevText = '&laquo;';
      var nextText = '&raquo;';
      var ellipsisText = '...';
      var activeClassName = 'active';
      var disableClassName = 'disabled';
      var showFirstOnEllipsisShow = true;
      var showLastOnEllipsisShow = true;
      var html = '';
      var i; // Whether to display header

      html += '<div class="fcrm-pagination-pages">';
      html += '<ul>'; // Whether to display the Previous button

      if (currentPage <= 1) {} else {
        html += '<li class="fcrm-pagination-previous" data-num="' + (currentPage - 1) + '" title="Previous page"><a href="' + pageLink + '">' + prevText + '<\/a><\/li>';
      } // Whether to display the pages


      if (rangeStart <= 3) {
        for (i = 1; i < rangeStart; i++) {
          if (i == currentPage) {
            html += '<li class="fcrm-pagination-page ' + activeClassName + '" data-num="' + i + '"><a>' + i + '<\/a><\/li>';
          } else {
            html += '<li class="fcrm-pagination-page" data-num="' + i + '"><a href="' + pageLink + '">' + i + '<\/a><\/li>';
          }
        }
      } else {
        if (showFirstOnEllipsisShow) {
          html += '<li class="fcrm-pagination-first fcrm-pagination-page" data-num="1"><a href="' + pageLink + '">1<\/a><\/li>';
        }

        html += '<li class="fcrm-pagination-ellipsis ' + disableClassName + '"><a>' + ellipsisText + '<\/a><\/li>';
      }

      for (i = rangeStart; i <= rangeEnd; i++) {
        if (i == currentPage) {
          html += '<li class="fcrm-pagination-page ' + activeClassName + '" data-num="' + i + '"><a>' + i + '<\/a><\/li>';
        } else {
          html += '<li class="fcrm-pagination-page" data-num="' + i + '"><a href="' + pageLink + '">' + i + '<\/a><\/li>';
        }
      }

      if (rangeEnd >= totalPage - 2) {
        for (i = rangeEnd + 1; i <= totalPage; i++) {
          html += '<li class="fcrm-pagination-page" data-num="' + i + '"><a href="' + pageLink + '">' + i + '<\/a><\/li>';
        }
      } else {
        html += '<li class="fcrm-pagination-ellipsis ' + disableClassName + '"><a>' + ellipsisText + '<\/a><\/li>';

        if (showLastOnEllipsisShow) {
          html += '<li class="fcrm-pagination-last fcrm-pagination-page" data-num="' + totalPage + '"><a href="' + pageLink + '">' + totalPage + '<\/a><\/li>';
        }
      }

      if (currentPage >= totalPage) {} else {
        html += '<li class="fcrm-pagination-next" data-num="' + (currentPage + 1) + '" title="Next page"><a href="' + pageLink + '">' + nextText + '<\/a><\/li>';
      }

      html += '<\/ul><\/div>';

      if (totalPage > 1) {
        jQuery(this.pagination).html(html);
      } else {
        jQuery(this.pagination).html(html);
      }
    }
  }, {
    key: "reloadView",
    value: function reloadView(from) {
      var query = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var startDate = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      var endDate = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
      this.query = query;
      this.startDate = startDate;
      this.endDate = endDate;
      this.buildEntityListView([]);
      this.getEntities(from);
    }
  }, {
    key: "applyDateRange",
    value: function applyDateRange(startDate, endDate) {
      this.startDate = startDate;
      this.endDate = endDate;
      this.getEntities(0);
    }
  }, {
    key: "search",
    value: function search(query) {
      this.query = query;
      this.getEntities(0);
    }
  }, {
    key: "setupView",
    value: function setupView(size) {
      this.pageSize = size ? +size : 16;
      this.reloadView(0);
    }
  }]);

  return FirehawkCRMTributesGrid;
}();