"use strict";

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var FirehawkCRMTributeFlowerDelivery = /*#__PURE__*/function () {
  function FirehawkCRMTributeFlowerDelivery() {
    _classCallCheck(this, FirehawkCRMTributeFlowerDelivery);

    _defineProperty(this, "historyBool", false);

    this.initialSetup();
  }

  _createClass(FirehawkCRMTributeFlowerDelivery, [{
    key: "initialSetup",
    value: function initialSetup() {
      var _this = this;

      jQuery(window).ready(function () {
        // set session variables for prepopulations
        _this.setSessionParameters();

        _this.setupHistory();
      });
      History.Adapter.bind(window, "statechange", function () {
        _this.onHistoryStateChange();
      });
      this.addObservers();
      jQuery(document).ready(function () {
        jQuery('.fcrm-tributes-flowers-loader').hide();

        _this.updateCartButton();

        _this.addFormValidators();
      }).ajaxStart(function () {
        jQuery('.fcrm-tributes-flowers-loader').show();
      }).ajaxStop(function () {
        jQuery('.fcrm-tributes-flowers-loader').hide();
      });
    }
  }, {
    key: "addObservers",
    value: function addObservers() {
      var _this2 = this;

      var self = this; //Pagination

      jQuery(document).on("click", ".fcrm-tributes-flower-pagination a.page-link", function (e) {
        e.preventDefault();
        var data = {
          'action': 'getProducts',
          'category': jQuery(this).attr("data-category"),
          'page': jQuery(this).attr("data-page")
        };
        History.pushState(data, "", "");
      }); //Top Menu

      jQuery(document).on("click", ".fcrm-tributes-flower-menu a.fcrm-tribute-flowers-menu-link", function (e) {
        e.preventDefault();
        var data = {
          'action': 'getProducts',
          'category': jQuery(this).attr("data-category"),
          'page': jQuery(this).attr("data-page")
        };
        History.pushState(data, "", "");
      });
      jQuery(document).on("input", "#fcrm-tribute-flowers-plant-a-tree-select-your-own", function (e) {
        self.selectYourOwnTreeCalc(null, this.value, false);
      });
      jQuery(document).on("click", ".fcrm-tribute-flowers-plant-a-tree-select-your-own-calculate", function (e) {
        e.preventDefault();
        var valInput = jQuery('#fcrm-tribute-flowers-plant-a-tree-select-your-own');
        var trees = parseInt(valInput.val().trim());
        var each = 0;

        if (trees > 4 && trees < 12) {
          each = 10;
        } else if (trees > 11 && trees < 30) {
          each = 8.33;
        } else if (trees > 29) {
          each = 8;
        }

        if (isNaN(trees) || trees < 5) {
          valInput.focus();
        } else {
          var data = {
            'action': 'getTreesTotal',
            'code': "TREE",
            'number': trees,
            'price': (trees * each).toFixed(2)
          };
          jQuery.post(ajax_var.url, data, function (response, status) {
            self.selectYourOwnTreeCalc(response, trees, true);
          }, "html");
        }
      });
      jQuery(document).on("click", "#fcrm-tribute-flowers-tree-certificate-wrapper .trees-checkout", function (e) {
        // switch radio button on input
        if (e.target.nodeName == "INPUT" || e.target.nodeName == "TEXTAREA") {
          jQuery("input:radio").eq(jQuery(".trees-checkout").index(_this2)).attr("checked", true).trigger("click");
        }
      }); // end trees

      jQuery(document).on("click", "a.fcrm-tribute-flowers-menu-plant-a-tree-link", function (e) {
        if (jQuery(this).attr("href") == '#') {
          e.preventDefault();
          var data = {
            'action': 'getTree',
            'code': "TREE"
          };
          History.pushState(data, "", "");
        }
      });
      jQuery(document).on("click", ".fcrm-tributes-flower-single-product a.view-item-btn", function (e) {
        if (jQuery(this).attr("href") == '#') {
          var thisCode = jQuery(this).attr("data-code");
          e.preventDefault();
          var data = {
            'action': thisCode == "TREE" ? 'getTree' : 'getProduct',
            'code': thisCode
          };
          History.pushState(data, "", "");
        }
      });
      jQuery(document).on("click", ".fcrm-tribute-checkout-table a.view-item-btn", function (e) {
        if (jQuery(this).attr("href") == '#') {
          var thisCode = jQuery(this).attr("data-code");
          e.preventDefault();
          var data = {
            'action': thisCode == "TREE" ? 'getTree' : 'getProduct',
            'code': thisCode
          };
          History.pushState(data, "", "");
        }
      });
      jQuery(document).on("click", ".fcrm-tributes-flower-single-product a.add-to-cart-btn", function (e) {
        if (jQuery(this).attr("href") == '#') {
          self.historyBool = true;
          e.preventDefault();
          var data = {
            'action': 'addToCart',
            'code': jQuery(this).attr("data-code")
          };
          History.pushState(data, "", "");
        }

        self.updateCartButton();
      });
      jQuery(document).on("click", ".fcrm-tribute-flowers-menu-cart", function (e) {
        e.preventDefault();
        var data = {
          'action': 'getCart',
          'code': null
        };
        History.pushState(data, "", "");
        self.updateCartButton();
      });
      jQuery(document).on("click", "a.fcrm-tribute-flowers-cart-remove-item", function (e) {
        e.preventDefault();
        self.removeFromCart(jQuery(this).attr("data-code"));
        self.updateCartButton();
      });
      jQuery(document).on("click", "a.fcrm-tribute-flowers-menu-customer-service-link", function (e) {
        e.preventDefault();
        var data = {
          'action': 'getCustomerService'
        };
        History.pushState(data, "", "");
      });
      jQuery(document).on("click", "a.fcrm-tribute-flowers-checkout", function (e) {
        e.preventDefault();
        var page = jQuery(this).attr("data-page");
        var data = {
          'action': 'checkout',
          'page': page,
          'random': Math.random(),
          'trees': jQuery(this).attr('data-code') == "TREE" ? ["Trees", jQuery('.obit_name_and_date').find('h2').text()] : ''
        };
        History.pushState(data, "", "");
      });
      jQuery(document).on("click", "a.fcrm-tribute-flowers-checkout-process-order", function (e) {
        e.preventDefault();
        self.processOrder();
      });
      jQuery(document).on("click", "a.fcrm-tribute-flowers-checkout-continue-checkout", function (e) {
        self.historyBool = true;
        e.preventDefault();
        var page = jQuery(".fcrm-tribute-flowers-checkout-page").val();
        var data = {
          'action': 'continue-checkout-' + page,
          'page': page,
          'random': Math.random()
        };
        History.pushState(data, "", "");
      });
      jQuery(document).on("click", "a.fcrm-tribute-flowers-checkout-page-edit", function (e) {
        e.preventDefault();
        var page = jQuery(this).attr("data-page");
        var editType = jQuery(this).attr("data-edit-type");
        self.checkout(page, [], editType == "Trees" ? ["Trees"] : '');
      });
      jQuery(document).on("click", ".child_window_closed", function (e) {
        e.preventDefault(); //check order & redirect user accordingly

        var data = {
          'action': 'checkOrder',
          'orderno': jQuery(".child_window_closed").val()
        };
        jQuery.post(ajax_var.url, data, function (response, status) {
          self.make_page(response, status);
        }, "html");
      });
    }
  }, {
    key: "addFormValidators",
    value: function addFormValidators() {
      jQuery.validator.addMethod("phoneUS", function (phone_number, element) {
        phone_number = phone_number.replace(/\s+/g, "");
        return this.optional(element) || phone_number.length > 9 && phone_number.match(/^\(?[\d]{3}\)?[\s-]?[\d]{3}[\s-]?[\d]{4}$/);
      }, "Please specify a valid phone number");
      jQuery.validator.addMethod("recipientZip", function (value, element) {
        return this.optional(element) || /(^\d{5}$)|(^[A-Za-z]{1}\d{1}[A-Za-z]{1} *\d{1}[A-Za-z]{1}\d{1}$)/.test(value);
      }, "This is not a valid US or Canadian ZIP");
      jQuery.validator.addMethod("CCExp", function (value, element, params) {
        var minMonth = new Date().getMonth() + 1;
        var minYear = new Date().getFullYear();
        minYear = (minYear + '').substring(2, 4);
        var month = parseInt(jQuery(params.month).val(), 10);
        var year = parseInt(jQuery(params.year).val(), 10);
        return this.optional(element) || year > minYear || year == minYear && month >= minMonth;
      }, "Your Credit Card Expiration date is invalid.");
      jQuery.validator.addMethod("CCCVV2", function (value, element, params) {
        var cc_type = jQuery(params.cc_type).val();
        var cc_cvv2 = jQuery(params.cc_cvv2).val();
        return this.optional(element) || cc_type == 'AX' && cc_cvv2.length == 4 || cc_type != 'AX' && cc_cvv2.length == 3;
      }, "Your CVV2 is invalid.");
      jQuery.validator.addMethod("creditCardNumber", function (value, element) {
        var strippedValue = value.replace(/[^0-9]+/g, '');
        return this.optional(element) || /^.{15,16}$/.test(strippedValue);
      }, "Please enter a valid credit card number.");
    }
  }, {
    key: "updateCartButton",
    value: function updateCartButton() {
      jQuery.post(ajax_var.url, {
        'action': 'getCartCount',
        'random': Math.random()
      }, function (response, status) {
        jQuery('#fcrm-tribute-flower-cart-count').html(response);
      }, "html");
    }
  }, {
    key: "setupHistory",
    value: function setupHistory() {
      var flowerMenu = jQuery(".fcrm-tribute-flowers-menu").get(0);
      if (!flowerMenu) return;
      var pagetitle = jQuery(document).find("title").text();

      if (this.getUrlParameter('viewitem')) {
        var data = {
          'action': 'getProduct',
          'code': this.getUrlParameter('viewitem'),
          'random': Math.random()
        };
      } else if (this.getUrlParameter('buyitem')) {
        var data = {
          'action': 'addToCart',
          'code': this.getUrlParameter('buyitem'),
          'random': Math.random()
        };
      } else if (jQuery(".firehawk-crm-tributes .firehawk-crm-tribute-flowers-page").attr("data-def_cat")) {
        if (jQuery(".firehawk-crm-tributes .firehawk-crm-tribute-flowers-page").attr("data-def_cat") != 'cart') {
          var data = {
            'action': 'getProducts',
            'category': jQuery(".firehawk-crm-tributes .ffirehawk-crm-tribute-lowers-page").attr("data-def_cat"),
            'page': 1,
            'random': Math.random()
          };
        } else {
          var data = {
            'action': 'getCart',
            'random': Math.random()
          };
        }
      } else if (this.getUrlParameter('revieworder')) {
        self.historyBool = true;
        var data = {
          'action': 'checkout',
          'page': 4,
          'random': Math.random()
        };
      } else if (this.getUrlParameter('orderno')) {
        checkout(5, new Array({
          name: "orderno",
          value: this.getUrlParameter('orderno')
        }));
      } else {
        if (this.getUrlParameter('show_trees') == 1) {
          var data = {
            'action': 'getTree',
            'code': 'TREE',
            'random': Math.random()
          };
        } else {
          var data = {
            'action': 'getProducts',
            'category': jQuery(".firehawk-crm-tributes .firehawk-crm-tribute-flowers-page").attr("data-def_cat") ? jQuery(".firehawk-crm-tributes .firehawk-crm-tribute-flowers-page").attr("data-def_cat") : 'default',
            'page': 1,
            'random': Math.random()
          };
        }
      }

      History.pushState(data, pagetitle, "");
    }
  }, {
    key: "onHistoryStateChange",
    value: function onHistoryStateChange() {
      var state = History.getState();

      if (state.data.action == 'getProducts') {
        jQuery(".fcrm-tributes-flower-menu a.nav-link").removeClass("active");
        jQuery("a.fcrm-tribute-flowers-menu-customer-service-link").removeClass("active");

        if (state.data.category != "default") {
          jQuery(".fcrm-tributes-flower-menu a.nav-link[data-category='" + state.data.category + "']").addClass("active");
        } else {
          jQuery("#fcrm-tribute-flowers-menu-link-1").addClass("active");
        }

        jQuery(".fcrm-tributes-flower-pagination .page-item").removeClass("active");
        jQuery(".fcrm-tributes-flower-pagination #page-item-" + state.data.page).addClass("active");
        this.getProducts(state.data.category, state.data.page);
      } else if (state.data.action == 'getProduct') {
        this.getProduct(state.data.code);
      } else if (state.data.action == 'getTree') {
        jQuery(".fcrm-tributes-flower-menu a.nav-link").removeClass("active");
        jQuery(".fcrm-tributes-flower-menu a.fcrm-tribute-flowers-menu-plant-a-tree-link").addClass("active");
        this.getTree(state.data.code);
      } else if (state.data.action == 'addToCart') {
        jQuery(".fcrm-tributes-flower-menu a.nav-link").removeClass("active");

        if (this.historyBool) {
          this.addToCart(state.data.code);
        } else {
          this.getCart(state.data.code);
        }

        this.historyBool = false;
      } else if (state.data.action == 'getCart') {
        jQuery(".fcrm-tributes-flower-menu a.nav-link").removeClass("active");
        jQuery(".fcrm-tributes-flower-menu .fcrm-tribute-flowers-menu-cart a.nav-link").addClass("active");
        this.getCart(state.data.code);
      } else if (state.data.action == 'getCustomerService') {
        jQuery(".fcrm-tributes-flower-menu a.nav-link").removeClass("active");
        jQuery("a.fcrm-tribute-flowers-menu-customer-service-link").addClass("active");
        this.showCustomerService();
      } else if (state.data.action == 'checkout') {
        jQuery(".fcrm-tributes-flower-menu a.nav-link").removeClass("active");
        this.checkout(state.data.page, state.data.formdata, state.data.trees);
      } else if (state.data.action.substring(0, 18) == 'continue-checkout-') {
        if (this.historyBool) {
          var $form = jQuery(".checkout-form");
          $form.submit();
        } else {
          this.checkout(state.data.page, state.data.formdata, state.data.trees);
        }

        this.historyBool = false;
      }
    }
  }, {
    key: "setSessionParameters",
    value: function setSessionParameters() {
      var data = {
        'action': 'setFlowerSessionData',
        'name': jQuery("#fcrm-tribute-flowers-recipient-name").val(),
        'institution': jQuery("#fcrm-tribute-flowers-recipient-institution").val(),
        'address1': jQuery("#fcrm-tribute-flowers-recipient-address-1").val(),
        'address2': jQuery("#fcrm-tribute-flowers-recipient-address-2").val(),
        'city': jQuery("#fcrm-tribute-flowers-recipient-city").val(),
        'state': jQuery("#fcrm-tribute-flowers-recipient-state").val(),
        'zip': jQuery("#fcrm-tribute-flowers-recipient-postal-code").val(),
        'country': jQuery("#fcrm-tribute-flowers-recipient-country").val(),
        'phone': jQuery("#fcrm-tribute-flowers-recipient-phone").val(),
        'random': Math.random()
      };
      jQuery.post(ajax_var.url, data);
    }
  }, {
    key: "selectYourOwnTreeCalc",
    value: function selectYourOwnTreeCalc(amount, number, calc) {
      var totalPrice = amount != null ? (Math.round(parseInt(amount) * 100) / 100).toFixed(2) : '';
      var getPrice = jQuery('.fcrm-tribute-flowers-plant-a-tree-select-your-own-price').text();
      var pricePresent = isNaN(getPrice);
      var $container = jQuery('.fcrm-tribute-flowers-plant-a-tree-select').find('#calculate-msg');
      var min = '<span class="error-msg">We’re sorry but the minimum number of trees that can be planted is a group of 5 trees.</span>';
      var price = '<div class="price-card"><div class="price-content"><span class="fcrm-tribute-flowers-plant-a-tree-select-your-own-price">$' + totalPrice + '</span>' + '<a href="#" class="fcrm-tribute-flowers-add-to-cart btn btn-primary add-to-cart-btn" id="plant-a-tree-add-to-cart2">Add To Cart</a></div></div>';
      var msg = number < 5 ? min : calc ? price : pricePresent ? getPrice : '';
      $container.html(msg);

      if (calc) {
        var treeGroup = number < 30 ? 'Group ' : 'Grove ';
        jQuery('#plant-a-tree-add-to-cart2').attr('data-number', number).attr('data-price', amount).attr('data-name', treeGroup + 'of ' + number + " Trees").attr('data-code', treeGroup + 'of ' + number + " Trees");
      }
    }
  }, {
    key: "getProducts",
    value: function getProducts(category, page) {
      var _this3 = this;

      var data = {
        'action': 'getProducts',
        'category': category,
        'page': page
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        _this3.make_page(response, status);
      }, "html");
    }
  }, {
    key: "getProduct",
    value: function getProduct(code) {
      var _this4 = this;

      var data = {
        'action': 'getProduct',
        'code': code
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        _this4.make_page(response, status);
      }, "html");
    }
  }, {
    key: "getTree",
    value: function getTree(code) {
      var _this5 = this;

      var data = {
        'action': 'getTree',
        'code': code
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        _this5.make_page(response, status);
      }, "html");
    }
  }, {
    key: "getUrlParameter",
    value: function getUrlParameter(sParam) {
      var sPageURL = decodeURIComponent(window.location.search.substring(1));
      var sURLVariables = sPageURL.split('&');
      var sParameterName = null;

      for (var variable in sURLVariables) {
        sParameterName = variable.split('=');

        if (sParameterName[0] === sParam) {
          return sParameterName[1] === undefined ? true : sParameterName[1];
        }
      }
    }
  }, {
    key: "make_page",
    value: function make_page(response, status, page) {
      var _this6 = this;

      jQuery(".fcrm-tribute-flowers-page-content").html(response);

      if (page !== undefined) {
        jQuery(document).ready(function () {
          _this6.initCheckoutFormValidation();
        });
      }
    }
  }, {
    key: "scroll_to_top",
    value: function scroll_to_top() {
      window.scrollTo(0, jQuery('.fcrm-tribute-flowers-menu').offset().top - 60);
    }
  }, {
    key: "initCheckoutFormValidation",
    value: function initCheckoutFormValidation() {
      var _rules,
          _this7 = this;

      var $form = jQuery(".checkout-form");
      $form.validate({
        rules: (_rules = {
          "fcrm-tribute-flowers-delivery-date": {
            required: true
          },
          "fcrm-tribute-flowers-tree-certificate": {
            required: true
          },
          "fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-name": {
            required: '#fcrm-tribute-flowers-tree-certificate-email-behalf[value="Cert-email-behalf"]:checked'
          },
          "fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-email": {
            required: '#fcrm-tribute-flowers-tree-certificate-email-behalf[value="Cert-email-behalf"]:checked',
            email: true
          },
          "fcrm-tribute-flowers-tree-certificate-email-behalf-message-to-recipient": {
            required: false,
            maxlength: 500
          },
          "fcrm-tribute-flowers-tree-certificate-name-of-loved-one": {
            required: true
          }
        }, _defineProperty(_rules, "fcrm-tribute-flowers-tree-certificate", {
          required: true
        }), _defineProperty(_rules, "fcrm-tribute-flowers-card-message", {
          required: true,
          maxlength: 200
        }), _defineProperty(_rules, "fcrm-tribute-flowers-special-instructions", {
          required: false,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-recipient-name", {
          required: true,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-recipient-institution", {
          required: false,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-recipient-address-1", {
          required: true,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-recipient-address-2", {
          required: false,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-recipient-city", {
          required: true,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-recipient-state", {
          required: true,
          maxlength: 2
        }), _defineProperty(_rules, "fcrm-tribute-flowers-recipient-country", {
          required: true,
          maxlength: 2
        }), _defineProperty(_rules, "fcrm-tribute-flowers-recipient-postal-code", {
          required: true,
          maxlength: 7,
          recipientZip: true
        }), _defineProperty(_rules, "fcrm-tribute-flowers-recipient-phone", {
          required: true,
          maxlength: 20,
          phoneUS: true
        }), _defineProperty(_rules, "fcrm-tribute-flowers-customer-name", {
          required: true,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-customer-address-1", {
          required: true,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-customer-address-2", {
          required: false,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-customer-city", {
          required: true,
          maxlength: 100
        }), _defineProperty(_rules, "fcrm-tribute-flowers-customer-state", {
          required: false,
          maxlength: 2
        }), _defineProperty(_rules, "fcrm-tribute-flowers-customer-country", {
          required: true,
          maxlength: 2
        }), _defineProperty(_rules, "fcrm-tribute-flowers-customer-phone", {
          required: true,
          maxlength: 20
        }), _defineProperty(_rules, "fcrm-tribute-flowers-customer-email", {
          required: true,
          maxlength: 100,
          email: true
        }), _defineProperty(_rules, "fcrm-tribute-flowers-customer-postal-code", {
          required: true,
          maxlength: 7
        }), _defineProperty(_rules, "fcrm-tribute-flowers-billing-credit-card", {
          required: true,
          maxlength: 2
        }), _defineProperty(_rules, "fcrm-tribute-flowers-billing-credit-card-no", {
          required: true,
          maxlength: 16,
          creditCardNumber: true
        }), _defineProperty(_rules, "fcrm-tribute-flowers-billing-exp-month", {
          required: true,
          maxlength: 2,
          CCExp: {
            month: '#fcrm-tribute-flowers-billing-exp-month',
            year: '#fcrm-tribute-flowers-billing-exp-year'
          }
        }), _defineProperty(_rules, "fcrm-tribute-flowers-billing-security-code", {
          required: true,
          maxlength: 4,
          CCCVV2: {
            cc_type: '#fcrm-tribute-flowers-billing-credit-card',
            cc_cvv2: '#fcrm-tribute-flowers-billing-security-code'
          }
        }), _rules),
        onkeyup: false,
        onblur: false,
        onchange: false,
        errorClass: "fcrm-tribute-flowers-error",
        invalidHandler: function invalidHandler(event, validator) {},
        showErrors: function showErrors(errorMap, errorList) {
          this.defaultShowErrors();
        },
        submitHandler: function submitHandler() {
          _this7.checkout(jQuery(".fcrm-tribute-flowers-checkout-page").val(), $form.serializeArray());
        },
        errorPlacement: function errorPlacement(error, element) {
          if (element.is(":radio")) {
            error.prependTo(element.parents('#fcrm-tribute-flowers-tree-certificate-wrapper'));
          } else {
            // This is the default behavior
            error.insertAfter(element);
          }
        },
        messages: {
          "fcrm-tribute-flowers-tree-certificate": {
            required: "Please select a delivery method."
          }
        }
      });
    }
  }, {
    key: "getTree",
    value: function getTree(code) {
      var _this8 = this;

      var data = {
        'action': 'getTree',
        'code': code
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        _this8.make_page(response, status);
      }, "html");
    }
  }, {
    key: "addToCart",
    value: function addToCart(code) {
      var _this9 = this;

      var data = {
        'action': 'addToCart',
        'code': code
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        _this9.make_page(response, status);

        _this9.updateCartButton();
      }, "html");
    }
  }, {
    key: "removeFromCart",
    value: function removeFromCart(code) {
      var _this10 = this;

      var data = {
        'action': 'removeFromCart',
        'code': code
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        _this10.make_page(response, status);

        _this10.updateCartButton();
      }, "html");
    }
  }, {
    key: "getCart",
    value: function getCart(code) {
      var _this11 = this;

      var data = {
        'action': 'getCart',
        'code': code
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        _this11.make_page(response, status);
      }, "html");
    }
  }, {
    key: "showCustomerService",
    value: function showCustomerService(code) {
      var _this12 = this;

      var data = {
        'action': 'getCustomerService'
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        _this12.make_page(response, status);
      }, "html");
    }
  }, {
    key: "checkout",
    value: function checkout(page, formdata, trees) {
      var _this13 = this;

      var data = {
        'action': 'checkout',
        'page': page,
        'formdata': formdata,
        'trees': trees
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        _this13.make_page(response, status, page);
      }, "html");
    }
  }, {
    key: "processOrder",
    value: function processOrder() {
      var _this14 = this;

      var data = {
        'action': 'processOrder'
      };
      jQuery.post(ajax_var.url, data, function (response, status) {
        if (!("errors" in response)) {
          if (response.errors.length > 0) {
            jQuery(".fcrm-tribute-flowers-review-error-message").css("display", "block");
          }

          for (var i = 0; i < response.errors.length; i++) {
            if (response.errors[i].substr(0, 21) == 'invalid delivery date') {
              jQuery(".fcrm-tribute-flowers-review-delivery-date").css("color", "red");
            } else if (response.errors[i].substr(0, 11) == 'cardmessage') {
              jQuery(".fcrm-tribute-flowers-review-card-message").css("color", "red");
            } else if (response.errors[i].substr(0, 19) == 'specialinstructions') {
              jQuery(".fcrm-tribute-flowers-review-special-instructions").css("color", "red");
            } else if (response.errors[i].substr(0, 14) == 'recipient name') {
              jQuery(".fcrm-tribute-flowers-review-recipient-name").css("color", "red");
            } else if (response.errors[i].substr(0, 21) == 'recipient institution') {
              jQuery(".fcrm-tribute-flowers-review-recipient-institution").css("color", "red");
            } else if (response.errors[i].substr(0, 18) == 'recipient address1') {
              jQuery(".fcrm-tribute-flowers-review-recipient-address-1").css("color", "red");
            } else if (response.errors[i].substr(0, 18) == 'recipient address2') {
              jQuery(".fcrm-tribute-flowers-review-recipient-address-2").css("color", "red");
            } else if (response.errors[i].substr(0, 14) == 'recipient city') {
              jQuery(".fcrm-tribute-flowers-review-recipient-city").css("color", "red");
            } else if (response.errors[i].substr(0, 15) == 'recipient state') {
              jQuery(".fcrm-tribute-flowers-review-recipient-city").css("color", "red");
            } else if (response.errors[i].substr(0, 17) == 'recipient country') {
              jQuery(".fcrm-tribute-flowers-review-recipient-country").css("color", "red");
            } else if (response.errors[i].substr(0, 15) == 'recipient phone') {
              jQuery(".fcrm-tribute-flowers-review-recipient-phone").css("color", "red");
            } else if (response.errors[i].substr(0, 17) == 'recipient zipcode') {
              jQuery(".fcrm-tribute-flowers-review-recipient-city").css("color", "red");
            } else if (response.errors[i].substr(0, 13) == 'customer name') {
              jQuery(".fcrm-tribute-flowers-review-customer-name").css("color", "red");
            } else if (response.errors[i].substr(0, 17) == 'customer address1') {
              jQuery(".fcrm-tribute-flowers-review-customer-address-1").css("color", "red");
            } else if (response.errors[i].substr(0, 17) == 'customer address2') {
              jQuery(".fcrm-tribute-flowers-review-customer-address-2").css("color", "red");
            } else if (response.errors[i].substr(0, 13) == 'customer city') {
              jQuery(".fcrm-tribute-flowers-review-customer-city").css("color", "red");
            } else if (response.errors[i].substr(0, 14) == 'customer state') {
              jQuery(".fcrm-tribute-flowers-review-customer-city").css("color", "red");
            } else if (response.errors[i].substr(0, 16) == 'customer country') {
              jQuery(".fcrm-tribute-flowers-review-customer-country").css("color", "red");
            } else if (response.errors[i].substr(0, 14) == 'customer phone') {
              jQuery(".fcrm-tribute-flowers-review-customer-phone").css("color", "red");
            } else if (response.errors[i].substr(0, 16) == 'customer zipcode') {
              jQuery(".fcrm-tribute-flowers-review-customer-city").css("color", "red");
            } else if (response.errors[i].substr(0, 14) == 'customer email') {
              jQuery(".fcrm-tribute-flowers-review-customer-email").css("color", "red");
            } else if (response.errors[i] == 'credit card number is required' || response.errors[i] == 'invalid card for american express' || response.errors[i] == 'invalid card for visa, discovery, or mastercard') {
              jQuery(".fcrm-tribute-flowers-review-credit-card-card-number").css("color", "red");
            } else if (response.errors[i] == 'credit card failure') {
              jQuery(".fcrm-tribute-flowers-review-credit-card").css("color", "red");
            } else if (response.errors[i] == 'security code is required' || response.errors[i] == 'invalid security code for american express' || response.errors[i] == 'invalid security code for visa, discovery, or mastercard') {
              jQuery(".fcrm-tribute-flowers-review-credit-card-cvv2").css("color", "red");
            } else if (response.errors[i] == 'invalid expiration year' || response.errors[i] == 'invalid expiration month' || response.errors[i] == 'credit card expiration month is required' || response.errors[i] == 'credit card expiration year is required') {
              jQuery(".fcrm-tribute-flowers-review-credit-card-expiration").css("color", "red");
            } else if (response.errors[i] == 'invalid credit card type' || response.errors[i] == 'credit card type is required') {
              jQuery(".fcrm-tribute-flowers-review-credit-card-card-type").css("color", "red");
            } else {
              alert(response.errors[i]);
            }
          }
        } else {
          _this14.checkout(5, new Array({
            name: "orderno",
            value: response.ORDERNO
          }));
        }
      }, "json");
    }
  }]);

  return FirehawkCRMTributeFlowerDelivery;
}();