"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Shuffle = window.Shuffle;

var FirehawkCRMServiceTributeDonations = /*#__PURE__*/function () {
  function FirehawkCRMServiceTributeDonations(element, pagination, client) {
    _classCallCheck(this, FirehawkCRMServiceTributeDonations);

    _defineProperty(this, "listElement", null);

    _defineProperty(this, "pagination", null);

    _defineProperty(this, "purchaseDonationModal", null);

    _defineProperty(this, "loadingOverlay", null);

    _defineProperty(this, "entityType", null);

    _defineProperty(this, "category", null);

    _defineProperty(this, "randomSorting", null);

    _defineProperty(this, "randomSortKey", null);

    _defineProperty(this, "totalPages", 0);

    _defineProperty(this, "totalItems", 0);

    _defineProperty(this, "page", -1);

    _defineProperty(this, "pageSize", 12);

    _defineProperty(this, "nextPageButton", null);

    _defineProperty(this, "searchRequest", null);

    _defineProperty(this, "filterMyItems", false);

    _defineProperty(this, "actionModal", null);

    _defineProperty(this, "actionModalElement", null);

    _defineProperty(this, "team", null);

    _defineProperty(this, "client", null);

    _defineProperty(this, "clientName", null);

    _defineProperty(this, "pageItems", []);

    _defineProperty(this, "verifyCode", null);

    _defineProperty(this, "verifyId", null);

    _defineProperty(this, "formSubmitData", {});

    _defineProperty(this, "verifyInput", null);

    _defineProperty(this, "shuffle", null);

    _defineProperty(this, "itemsWaiting", {});

    _defineProperty(this, "dateLocale", null);

    _defineProperty(this, "cartId", null);

    _defineProperty(this, "charity", null);

    _defineProperty(this, "openDonationsModalAfterFetch", false);

    _defineProperty(this, "fetchingDonationInfo", false);

    _defineProperty(this, "donationsNotFound", function () {});

    this.listElement = element;
    this.pagination = pagination;
    this.client = client;
    this.loadingOverlay = jQuery("<div class=\"loading-overlay\"><i class=\"far fa-spinner-third fa-spin\"></i></div>");
    this.listElement.addClass("loading");
    this.listElement.append(this.loadingOverlay);
    this.addListeners();
    this.shuffle = new Shuffle(element, {
      itemSelector: '.grid-item',
      sizer: '.my-sizer-element'
    });
  }

  _createClass(FirehawkCRMServiceTributeDonations, [{
    key: "buildItem",
    value: function buildItem(item) {
      var name = "";
      var currencySymbol = "$";
      var currencyIso = "USD";
      var amount = 1;

      if (item.amount) {
        amount = +item.amount;
      }

      if (this.currency && this.currency.symbol) {
        currencySymbol = this.currency.symbol;
      }

      if (this.currency && this.currency.iso) {
        currencyIso = this.currency.iso;
      }

      if (item.anonymous == "Yes" || item.anonymous == true) {
        name = "Anonymous";
      } else {
        if (item.displayName && item.displayName.length) {
          name = item.displayName;
        } else if (item.firstName) {
          name = item.firstName;
          if (item.lastName) name += " " + item.lastName;
        }
      }

      var title = "<div class=\"item-title\"><div class=\"title\"><h5>".concat(name, "</h5>");

      if (item.timestamp) {
        var dateTime = "";

        if (this.dateLocale && this.dateLocale == "en-US") {
          dateTime = moment(item.timestamp).format("MM/DD/YYYY");
        } else {
          dateTime = moment(item.timestamp).format("DD/MM/YYYY");
        }

        title += "<small class=\"item-date text-muted\">Donated ".concat(currencySymbol).concat(item.amount, " on ").concat(dateTime, "</small>");
      }

      title += "</div>";
      title += "<div class=\"actions\"></div>";
      title += "</div>";
      var isLiked = false;
      var likesCount = item.likes > 0 ? item.likes : 0;

      if (this.getCookie("tribute-".concat(item.id, "-liked"))) {
        isLiked = true;
      }

      var extraClasses = "";
      var itemMessage = (item.message || "").replace(/(?:\r\n|\r|\n)/g, '<br>');
      var message = "";

      if (itemMessage.length > 0) {
        message = "<div class=\"item-message\">".concat(itemMessage, "</div>");
      } else {
        extraClasses = "no-message";
      }

      var footer = "<div class=\"item-footer\"><div class=\"likes\"><a class=\"like-btn ".concat(isLiked ? "liked" : "", "\"><i class=\"far fa-heart\"></i></a><span class=\"counter\">").concat(likesCount, "</span></div>");
      footer += "</div>";
      var content = "\n\t\t\t<div class=\"item-view tribute-item tribute-donation ".concat(extraClasses, "\" id=\"tribute-donation-").concat(item.id, "\" data-donation-id=\"").concat(item.id, "\">\n\t\t\t\t<div class=\"donation-background normal\" aria-hidden=\"true\"></div>\n\t\t\t\t<div class=\"row\">\n\t\t\t\t\t<div class=\"col\">\n\t\t\t\t\t\t<div class=\"item-content\">\n\t\t\t\t\t\t\t").concat(title, "\n\t\t\t\t\t\t\t").concat(message, "\n\t\t\t\t\t\t\t").concat(footer, "\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t");
      return content;
    }
  }, {
    key: "insertNewItem",
    value: function insertNewItem(item) {
      var _this = this;

      var gridItems = [];
      var view = this.buildItem(item);
      gridItems.push(jQuery("<div class=\"grid-item col-12 col-md-6 col-lg-4\">".concat(view, "</div>")).get(0));
      gridItems.forEach(function (element) {
        jQuery(_this.listElement).prepend(element);
      });
      this.shuffle.add(gridItems);
      this.shuffle.update();
    }
  }, {
    key: "updateItemMessage",
    value: function updateItemMessage(id, message) {
      for (var _i2 = 0, _this$pageItems2 = this.pageItems; _i2 < _this$pageItems2.length; _i2++) {
        var item = _this$pageItems2[_i2];

        if (item.id == id) {
          item.message = message;
          break;
        }
      }
    }
  }, {
    key: "clearCurrentList",
    value: function clearCurrentList() {
      var items = _toConsumableArray(this.shuffle.items);

      items.shift();
      this.shuffle.remove(items.map(function (e) {
        return e.element;
      }));
    }
  }, {
    key: "buildEntityListView",
    value: function buildEntityListView(items) {
      var _this2 = this;

      var gridItems = [];

      for (var _i4 = 0; _i4 < items.length; _i4++) {
        var item = items[_i4];
        var view = this.buildItem(item);
        gridItems.push(jQuery("<div class=\"grid-item col-12 col-sm-6 col-lg-4\">".concat(view, "</div>")).get(0));
      }

      gridItems.forEach(function (element) {
        jQuery(_this2.listElement).append(element);
      });
      this.shuffle.add(gridItems);
      this.shuffle.update();
    }
  }, {
    key: "addListeners",
    value: function addListeners() {
      var _this3 = this;

      jQuery(this.pagination).delegate('.fcrm-pagination-page', 'click', function (event) {
        event.preventDefault();
        var current = jQuery(event.currentTarget);
        var pageNumber = jQuery.trim(current.attr('data-num'));
        if (!pageNumber || current.hasClass('disabled') || current.hasClass('active')) return;
        var newPage = pageNumber - 1;

        _this3.getEntities(_this3.pageSize * newPage);
      }); // Previous button click

      jQuery(this.pagination).delegate('.fcrm-pagination-previous', 'click', function (event) {
        event.preventDefault();
        var current = jQuery(event.currentTarget);
        var pageNumber = jQuery.trim(current.attr('data-num'));
        if (!pageNumber || current.hasClass('disabled')) return;
        var newPage = pageNumber - 1;

        _this3.getEntities(_this3.pageSize * newPage);
      }); // Next button click

      jQuery(this.pagination).delegate('.fcrm-pagination-next', 'click', function (event) {
        event.preventDefault();
        var current = jQuery(event.currentTarget);
        var pageNumber = jQuery.trim(current.attr('data-num'));
        if (!pageNumber || current.hasClass('disabled')) return;
        var newPage = pageNumber - 1;

        _this3.getEntities(_this3.pageSize * newPage);
      });
      jQuery(this.listElement).delegate(".tribute-item .like-btn", "click", function (event) {
        var item = jQuery(event.currentTarget);
        var donationId = item.parents(".tribute-item").data("donation-id");
        if (_this3.itemsWaiting[donationId]) return;

        if (item.hasClass("liked")) {
          item.removeClass("liked");

          _this3.setCookie("tribute-".concat(donationId, "-liked"), "false", -1);

          _this3.unlikeTributeDonation(donationId);
        } else {
          item.addClass("liked"); // 24 hours x 30 = 30 days

          var cookieExpiry = 24 * 30;

          _this3.setCookie("tribute-".concat(donationId, "-liked"), "true", cookieExpiry);

          _this3.likeTributeDonation(donationId);
        }
      });
    }
  }, {
    key: "getDonationsInfo",
    value: function getDonationsInfo(callback) {
      var _this4 = this;

      this.fetchingDonationInfo = true;
      jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'get_client_donation_info',
          clientId: this.client
        }
      }).done(function (response) {
        if (response && response.charity && response.currency) {
          _this4.charity = response.charity;
          _this4.currency = response.currency;
          _this4.fetchingDonationInfo = false;

          if (_this4.openDonationsModalAfterFetch) {
            _this4.openDonationsModalAfterFetch = false;

            _this4.showDonationPurchaseModal();
          }
        } else {
          _this4.charity = null;

          _this4.donationsNotFound();

          _this4.fetchingDonationInfo = false;
        }

        if (callback) callback(response);
      }).fail(function (xhr, status, error) {
        var errorMessage = "Something went wrong, please try again.";

        if (error.responseJSON) {
          errorMessage = error.responseJSON.error || error.responseJSON.message || "";
        }

        console.log(errorMessage);

        _this4.donationsNotFound();

        _this4.fetchingDonationInfo = false;
        if (callback) callback(null);
      });
    }
  }, {
    key: "getEntities",
    value: function getEntities(from) {
      var _this5 = this;

      if (!this.client || !this.currency) {
        this.listElement.removeClass("loading");
        this.loadingOverlay.remove();
        return;
      }

      this.listElement.addClass("loading");
      this.listElement.append(this.loadingOverlay);
      var params = {
        size: this.pageSize || 16,
        from: from || 0,
        client: this.client || null
      };
      var page = (from || 0) / this.pageSize || 0;
      this.page = page;

      if (this.searchRequest) {
        this.searchRequest.abort();
      }

      this.searchRequest = jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'get_tribute_donations',
          params: params
        }
      }).done(function (response) {
        var results = [];
        var total = 0;

        if (response) {
          var data = JSON.parse(response);

          if (data && data.results) {
            total = data.total || 0;
            results = data.results;
          }
        }

        _this5.totalItems = total;
        _this5.totalPages = Math.ceil(total / _this5.pageSize);
        _this5.pageItems = results;

        _this5.clearCurrentList();

        _this5.updatePagination();

        _this5.buildEntityListView(results);

        if (!results.length) {
          _this5.showEmptyListView();
        }

        _this5.loadingOverlay.remove();

        _this5.listElement.removeClass("loading");
      }).fail(function (xhr, status, error) {
        _this5.listElement.removeClass("loading");
      });
    }
  }, {
    key: "showEmptyListView",
    value: function showEmptyListView() {
      var emptyView = jQuery("<div class=\"empty-view\">No results found</div>");
      jQuery(this.listElement).html(emptyView);
    }
  }, {
    key: "updatePagination",
    value: function updatePagination() {
      if (!this.pagination) return;
      var self = this;
      var currentPage = self.page + 1;
      var pageRange = 2;
      var totalPage = self.totalPages;
      var rangeStart = currentPage - pageRange;
      var rangeEnd = currentPage + pageRange;

      if (rangeEnd > totalPage) {
        rangeEnd = totalPage;
        rangeStart = totalPage - pageRange * 2;
        rangeStart = rangeStart < 1 ? 1 : rangeStart;
      }

      if (rangeStart <= 1) {
        rangeStart = 1;
        rangeEnd = Math.min(pageRange * 2 + 1, totalPage);
      }

      var pageLink = '';
      var prevText = '&laquo;';
      var nextText = '&raquo;';
      var ellipsisText = '...';
      var activeClassName = 'active';
      var disableClassName = 'disabled';
      var showFirstOnEllipsisShow = true;
      var showLastOnEllipsisShow = true;
      var html = '';
      var i; // Whether to display header

      html += '<div class="fcrm-pagination-pages">';
      html += '<ul>'; // Whether to display the Previous button

      if (currentPage <= 1) {} else {
        html += '<li class="fcrm-pagination-previous" data-num="' + (currentPage - 1) + '" title="Previous page"><a href="' + pageLink + '">' + prevText + '<\/a><\/li>';
      } // Whether to display the pages


      if (rangeStart <= 3) {
        for (i = 1; i < rangeStart; i++) {
          if (i == currentPage) {
            html += '<li class="fcrm-pagination-page ' + activeClassName + '" data-num="' + i + '"><a>' + i + '<\/a><\/li>';
          } else {
            html += '<li class="fcrm-pagination-page" data-num="' + i + '"><a href="' + pageLink + '">' + i + '<\/a><\/li>';
          }
        }
      } else {
        if (showFirstOnEllipsisShow) {
          html += '<li class="fcrm-pagination-first fcrm-pagination-page" data-num="1"><a href="' + pageLink + '">1<\/a><\/li>';
        }

        html += '<li class="fcrm-pagination-ellipsis ' + disableClassName + '"><a>' + ellipsisText + '<\/a><\/li>';
      }

      for (i = rangeStart; i <= rangeEnd; i++) {
        if (i == currentPage) {
          html += '<li class="fcrm-pagination-page ' + activeClassName + '" data-num="' + i + '"><a>' + i + '<\/a><\/li>';
        } else {
          html += '<li class="fcrm-pagination-page" data-num="' + i + '"><a href="' + pageLink + '">' + i + '<\/a><\/li>';
        }
      }

      if (rangeEnd >= totalPage - 2) {
        for (i = rangeEnd + 1; i <= totalPage; i++) {
          html += '<li class="fcrm-pagination-page" data-num="' + i + '"><a href="' + pageLink + '">' + i + '<\/a><\/li>';
        }
      } else {
        html += '<li class="fcrm-pagination-ellipsis ' + disableClassName + '"><a>' + ellipsisText + '<\/a><\/li>';

        if (showLastOnEllipsisShow) {
          html += '<li class="fcrm-pagination-last fcrm-pagination-page" data-num="' + totalPage + '"><a href="' + pageLink + '">' + totalPage + '<\/a><\/li>';
        }
      }

      if (currentPage >= totalPage) {} else {
        html += '<li class="fcrm-pagination-next" data-num="' + (currentPage + 1) + '" title="Next page"><a href="' + pageLink + '">' + nextText + '<\/a><\/li>';
      }

      html += '<\/ul><\/div>';

      if (totalPage > 1) {
        jQuery(this.pagination).html(html);
      } else {
        jQuery(this.pagination).html();
      }
    }
  }, {
    key: "reloadView",
    value: function reloadView(from) {
      this.buildEntityListView([]);
      this.getEntities(from);
    }
  }, {
    key: "setupView",
    value: function setupView(category, size) {
      var _this6 = this;

      this.pageSize = size ? +size : 16;
      this.category = category;

      if (this.listElement) {
        this.listElement.addClass("loading");
        this.listElement.append(this.loadingOverlay);
      }

      this.getDonationsInfo(function (response) {
        if (_this6.currency) {
          _this6.reloadView(0);
        }
      });
    }
  }, {
    key: "resetDonationPurchaseModal",
    value: function resetDonationPurchaseModal() {
      if (!this.actionModalElement) return;
      this.actionModalElement.undelegate();
      this.actionModalElement.find("form .modal-footer .submit-btn").prop("disabled", false).html("Submit");
      this.actionModalElement.find("#page-1").show();
      this.actionModalElement.find("#page-1 form").trigger("reset");
      this.actionModalElement.find("#page-2").hide();
      this.actionModalElement.find("#page-2 form").trigger("reset");
      this.formSubmitData = {};
      this.verifyCode = null;
      var copyOfModal = this.actionModalElement;
      setTimeout(function () {
        if (copyOfModal) {
          copyOfModal.remove();
        }
      }, 600);
    }
  }, {
    key: "closeActionModal",
    value: function closeActionModal() {
      var destroy = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

      if (this.actionModal) {
        this.actionModal.hide();
      }

      this.actionModal = null;
      this.resetDonationPurchaseModal();
    }
  }, {
    key: "buildCreateDonationModal",
    value: function buildCreateDonationModal() {
      var modalContainer = jQuery("<div class=\"bs-modal modal fade fcrm-purchase-donation-modal\" id=\"fcrm-create-donation\" tabindex=\"-1\" style=\"display: none;\" aria-hidden=\"true\"></div>");
      var modal = jQuery('<div class="modal-dialog modal-lg modal-dialog-centered"></div>');
      var modalContent = jQuery('<div class="modal-content">');
      var modalTitle = "Make a donation";

      if (this.clientName && this.clientName.length) {
        if (this.charity.name) {
          modalTitle = "Make a donation to ".concat(this.charity.name, " on behalf of ").concat(this.clientName);
        } else {
          modalTitle = "Make a donation in memory of ".concat(this.clientName);
        }
      }

      modalContent.append("<div class=\"modal-header px-4\"><h5 class=\"modal-title\">".concat(modalTitle, "</h5><button type=\"button\" class=\"btn-close close-modal-btn\" data-bs-dismiss=\"modal\" aria-label=\"Close\" style=\"font-size: 12px;\"></button></div>")); // Setup: Modal body

      var modalBody = jQuery('<div class="modal-body px-4"></div>'); // Setup: Page 1

      var page1 = jQuery('<div class="form-page" id="page-1"></div>');
      var page1Form = jQuery('<form></form>');
      var donationAmountOptions = [5, 10, 20, 50, 100, "other"];
      var currencySymbol = "$";
      var currencyIso = "USD";

      if (this.currency && this.currency.symbol) {
        currencySymbol = this.currency.symbol;
      }

      if (this.currency && this.currency.iso) {
        currencyIso = this.currency.iso;
      }

      var amountOptions = donationAmountOptions.map(function (option, index) {
        if (option == "other") {
          return "\n\t\t\t\t<input type=\"radio\" class=\"btn-check\" name=\"amount\" id=\"amount".concat(index, "\" value=\"other\" autocomplete=\"off\">\n\t\t\t\t<label class=\"btn btn-outline-dark\" for=\"amount").concat(index, "\">Other</label>\n\t\t\t\t");
        }

        return "\n\t\t\t<input type=\"radio\" class=\"btn-check\" name=\"amount\" id=\"amount".concat(index, "\" value=\"").concat(option, "\" autocomplete=\"off\">\n\t\t\t<label class=\"btn btn-outline-dark\" for=\"amount").concat(index, "\">").concat(currencySymbol).concat(option, "</label>\n\t\t\t");
      }); // Page 1 form: Donation amount

      page1Form.append("\n\t\t\t<div class=\"row mb-3\">\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"amount\">How much would you like to donate?<small class=\"ms-2 text-muted\">(".concat(currencySymbol).concat(currencyIso, ")</small></label><br/>\n\t\t\t\t\t<div class=\"btn-group\" role=\"group\">\n\t\t\t\t\t\t").concat(amountOptions.join(""), "\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t")); // Page 1 form: Donation Other amount

      page1Form.append("\n\t\t\t<div class=\"row mb-3\" style=\"display: none\">\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"otherAmount\">Other Amount<small class=\"ms-2 text-muted\">(".concat(currencySymbol).concat(currencyIso, ")</small></label>\n\t\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t  <span class=\"input-group-text\">").concat(currencySymbol, "</span>\n\t\t\t\t\t  <input type=\"number\" class=\"form-control\" id=\"otherAmount\" name=\"otherAmount\">\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t")); // Page 1 form: Charity
      // page1Form.append(`
      // 	<div class="row mb-3">
      // 		<div class="col">
      // 			<label class="form-label" for="charity">Where would you like to plant them?</label>
      // 			<select class="charity-picker form-select" id="charity" name="charity" required></select>
      // 		</div>
      // 	</div>
      // `)
      // Page 1 form: First & Last name

      page1Form.append("\n\t\t\t<div class=\"row mb-3\">\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"firstName\">First name</label>\n\t\t\t\t\t<input type=\"text\" class=\"form-control\" id=\"firstName\" name=\"firstName\" required>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"lastName\">Last name</label>\n\t\t\t\t\t<input type=\"text\" class=\"form-control\" id=\"lastName\" name=\"lastName\" required>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t"); // Page 1 form: Email & Postcode

      page1Form.append("\n\t\t\t<div class=\"row mb-3\">\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"email\">Email</label>\n\t\t\t\t\t<input type=\"text\" class=\"form-control\" id=\"email\" name=\"email\" required>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"postcode\">Postcode</label>\n\t\t\t\t\t<input type=\"text\" class=\"form-control\" id=\"postcode\" name=\"postcode\" required>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t");
      page1Form.append("<div class=\"bd-callout bd-callout-danger error-callout\" style=\"display: none;\"></div>");
      page1Form.append("\n\t\t\t<div class=\"modal-footer justify-content-between border-0 pt-3 px-0 pb-0\">\n\t\t\t\t<button type=\"button\" class=\"btn btn-secondary close-modal-btn\" data-bs-dismiss=\"modal\">Cancel</button>\n\t\t\t\t<button type=\"submit\" class=\"btn btn-primary submit-btn\">Next</button>\n\t\t\t</div>\n\t\t");
      page1.append(page1Form);
      modalBody.append(page1); // Setup: Page 2

      var page2 = jQuery('<div class="form-page" id="page-2" style="display: none;"></div>');
      var page2Form = jQuery('<form></form>'); // Page 2 form: Anonymous

      page2Form.append("\n\t\t\t<div class=\"row mb-3\">\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"anonymous\">Anonymous (Your name will be hidden to the public)</label><br>\n\t\t\t\t\t<div class=\"btn-group\" role=\"group\">\n\t\t\t\t\t  <input type=\"radio\" class=\"btn-check\" name=\"anonymous\" id=\"anonymous1\" value=\"No\" autocomplete=\"off\" checked>\n\t\t\t\t\t  <label class=\"btn btn-outline-dark\" for=\"anonymous1\">No</label>\n\n\t\t\t\t\t  <input type=\"radio\" class=\"btn-check\" name=\"anonymous\" id=\"anonymous2\" value=\"Yes\" autocomplete=\"off\">\n\t\t\t\t\t  <label class=\"btn btn-outline-dark\" for=\"anonymous2\">Yes</label>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t"); // Page 2 form: Private

      page2Form.append("\n\t\t\t<div class=\"row mb-3\">\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"private\">Private (Your donation will be hidden to the public)</label><br>\n\t\t\t\t\t<div class=\"btn-group\" role=\"group\">\n\t\t\t\t\t\t<input type=\"radio\" class=\"btn-check\" name=\"private\" id=\"private1\" value=\"No\" autocomplete=\"off\" checked>\n\t\t\t\t\t\t<label class=\"btn btn-outline-dark\" for=\"private1\">No</label>\n\n\t\t\t\t\t\t<input type=\"radio\" class=\"btn-check\" name=\"private\" id=\"private2\" value=\"Yes\" autocomplete=\"off\">\n\t\t\t\t\t\t<label class=\"btn btn-outline-dark\" for=\"private2\">Yes</label>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t"); // Page 2 form: Display Name

      page2Form.append("\n\t\t\t<div class=\"row mb-3\">\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"displayName\">Display name (Leave blank if you want to use your full name)</label>\n\t\t\t\t\t<input type=\"text\" class=\"form-control\" id=\"displayName\" name=\"displayName\">\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t");
      var messageLabel = "Write a message of dedication<br/>(This will be emailed to the family and visible on their tribute page)";

      if (this.clientName && this.clientName.length) {
        messageLabel = "Write a message of dedication<br/>(This will be emailed to the family of ".concat(this.clientName, " and visible on their tribute page)");
      } // Page 2 form: Display Name


      page2Form.append("\n\t\t\t<div class=\"row mb-3\">\n\t\t\t\t<div class=\"col\">\n\t\t\t\t\t<label class=\"form-label\" for=\"message\">".concat(messageLabel, "</label>\n\t\t\t\t\t<div class=\"grow-wrap\">\n\t\t\t\t    <textarea class=\"form-control\" name=\"message\" id=\"message\" onInput=\"this.parentNode.dataset.replicatedValue = this.value\" maxlength=\"300\"></textarea>\n\t\t\t\t  </div>\n\t\t\t\t\t<div class=\"character-count\">0/300</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t"));
      page2Form.append("<div class=\"bd-callout bd-callout-danger error-callout\" style=\"display: none;\"></div>");
      page2Form.append("<button type=\"button\" class=\"d-none checkout-button\">Checkout</button>");
      page2Form.append("\n\t\t\t<div class=\"modal-footer justify-content-between border-0 pt-3 px-0 pb-0\">\n\t\t\t\t<button type=\"button\" class=\"btn btn-secondary back-btn\">Back</button>\n\t\t\t\t<button type=\"submit\" class=\"btn btn-primary submit-btn\">Checkout</button>\n\t\t\t</div>\n\t\t");
      page2.append(page2Form);
      modalBody.append(page2);
      modalContent.append(modalBody);
      modal.append(modalContent);
      modalContainer.append(modal);
      return modalContainer;
    }
  }, {
    key: "showDonationPurchaseModal",
    value: function showDonationPurchaseModal() {
      var _this7 = this;

      if (this.fetchingDonationInfo) {
        this.openDonationsModalAfterFetch = true;
        return;
      }

      if (!this.charity || !this.currency) {
        return;
      }

      this.closeActionModal(true);
      var modalElement = jQuery(this.buildCreateDonationModal());
      jQuery(this.listElement).parents(".firehawk-crm-tributes").append(modalElement);
      this.actionModalElement = modalElement;
      this.actionModal = new bootstrap.Modal(modalElement.get(0), {
        backdrop: "static"
      });
      this.actionModal.show();
      this.actionModalElement.delegate(".action-modal .close-modal-btn", "click", function (event) {
        _this7.closeActionModal();

        _this7.resetDonationPurchaseModal();
      });
      this.actionModalElement.on('hidden.bs.modal', function (event) {
        _this7.resetDonationPurchaseModal();
      });
      this.actionModalElement.delegate("#page-2 .back-btn", "click", function (event) {
        _this7.actionModalElement.find("#page-2").hide();

        _this7.actionModalElement.find("#page-1").show();
      });
      this.actionModalElement.find('.charity-picker').select2({
        theme: "bootstrap4",
        allowClear: false,
        placeholder: "Select charity",
        dropdownCssClass: "charity-picker-select2",
        ajax: {
          url: "https://api.firehawkcrm.com/v2/wp/tributes/charities",
          dataType: 'json',
          data: function data(params) {
            return {
              q: params.term,
              page: params.page
            };
          },
          processResults: function processResults(data) {
            var results = data.results.map(function (option) {
              return {
                "id": option.id || null,
                "text": option.name,
                "source": option
              };
            });
            return {
              results: results
            };
          }
        }
      });
      this.actionModalElement.delegate("#page-1 form", "submit", function (event) {
        event.preventDefault();
        var form = jQuery(event.target);
        form.find(".error-callout").hide().html("");

        if (!_this7.team || !_this7.team.length || !_this7.client) {
          form.find(".error-callout").show().html("Something went wrong, please try again.");
          return;
        }

        var formData = new FormData(event.target);

        var mappedData = _this7.formDataToJSON(formData);

        if (!mappedData.amount) {
          form.find(".error-callout").show().html("Please select the amount you would like to donate.");
          return;
        }

        _this7.formSubmitData = _objectSpread({}, _this7.formSubmitData, {}, mappedData);
        form.parent().hide();
        form.parent().siblings("#page-2").show();
      });
      this.actionModalElement.delegate("#page-2 form", "submit", function (event) {
        event.preventDefault();
        var form = jQuery(event.target);
        form.find(".error-callout").hide().html("");

        if (!_this7.team || !_this7.team.length || !_this7.client) {
          form.find(".error-callout").show().html("Something went wrong, please try again.");
          return;
        }

        var submitButton = form.find(".modal-footer .submit-btn");
        submitButton.prop("disabled", true);
        submitButton.html("<span class=\"spinner-border spinner-border-sm\" role=\"status\" aria-hidden=\"true\">");
        var formData = new FormData(event.target);
        formData.append("client", _this7.client);
        formData.append("team", _this7.team);

        var mappedData = _this7.formDataToJSON(formData);

        _this7.formSubmitData = _objectSpread({}, _this7.formSubmitData, {}, mappedData);

        _this7.createTributeDonation();
      });
      this.actionModalElement.delegate("#page-2 form #message", "keyup", function (event) {
        var textarea = jQuery(event.target);
        var characterCount = textarea.val().length;
        textarea.parent().siblings(".character-count").text("".concat(characterCount, " / 300"));
      });
      this.actionModalElement.delegate("#page-1 form :radio[name='amount']", "change", function (event) {
        var field = jQuery(event.target);

        var otherField = _this7.actionModalElement.find("#page-1 form #otherAmount");

        if (field.val() == "other") {
          // otherField.show()
          otherField.parents(".row").show();
          otherField.prop('required', true);
        } else {
          // otherField.hide()
          otherField.parents(".row").hide();
          otherField.prop('required', false);
        }
      });
    }
  }, {
    key: "createTributeDonation",
    value: function createTributeDonation() {
      var _this8 = this;

      var formData = new FormData();

      for (var key in this.formSubmitData) {
        var value = this.formSubmitData[key];

        if (value != null) {
          formData.append(key, value);
        }
      }

      formData.append("action", "create_tribute_donation");
      var amountOption = this.formSubmitData["amount"];
      var amount = 0;

      if (amountOption == "other") {
        amount = +(this.formSubmitData["otherAmount"] || 0);
        this.formSubmitData["amount"] = this.formSubmitData["otherAmount"];
        delete this.formSubmitData["otherAmount"];
      } else {
        amount = +(this.formSubmitData["amount"] || 0);
      }

      var tributeAction = function tributeAction(cartId, errorMessage) {
        _this8.cartId = cartId;

        if (errorMessage) {
          _this8.actionModalElement.find("#page-2 .error-callout").show().html(errorMessage);

          var submitButton = _this8.actionModalElement.find("#page-2 form .modal-footer .submit-btn");

          submitButton.prop("disabled", false);
          submitButton.html("Submit");
          return;
        }

        formData.append("checkoutCart", cartId);
        jQuery.ajax({
          type: "POST",
          url: ajax_var.url,
          data: formData,
          contentType: false,
          cache: false,
          processData: false
        }).done(function (response) {
          if (!response) {
            _this8.actionModalElement.find("#page-2 .error-callout").show().html("Error: Unknown error");
          } else {
            var data = JSON.parse(response);

            if (data && data.error) {
              var _errorMessage = data.error || "Unknown error";

              _this8.actionModalElement.find("#page-2 .error-callout").show().html("Error: " + _errorMessage);

              var _submitButton = _this8.actionModalElement.find("#page-2 .modal-footer .submit-btn");

              _submitButton.prop("disabled", false);

              _submitButton.html("Submit");
            } else {
              //Handle successful transaction
              window.location = "".concat(_this8.checkoutCartUrl || '/checkout', "?cart=").concat(_this8.cartId);
            }
          }
        }).fail(function (xhr, status, error) {
          if (error.responseJSON) {
            var _errorMessage2 = error.responseJSON.error || error.responseJSON.message || "";

            _this8.actionModalElement.find("#page-2 .error-callout").show().html("Error: " + _errorMessage2);
          } else {
            _this8.actionModalElement.find("#page-2 .error-callout").show().html("Something went wrong, please try again.");
          }

          var submitButton = _this8.actionModalElement.find("#page-2 .modal-footer .submit-btn");

          submitButton.prop("disabled", false);
          submitButton.html("Submit");
        });
      };

      if (this.cartId) {
        tributeAction(this.cartId, null);
      } else {
        this.addDonationToCart(amount, tributeAction);
      }
    }
  }, {
    key: "addDonationToCart",
    value: function addDonationToCart(amount, callback) {
      var contact = {
        firstName: this.formSubmitData.firstName,
        lastName: this.formSubmitData.lastName,
        email: this.formSubmitData.email,
        postcode: this.formSubmitData.postcode
      };
      jQuery.ajax({
        type: "POST",
        url: ajax_var.url,
        data: {
          action: "add_donation_to_cart",
          amount: amount,
          contact: contact,
          currency: this.currency && this.currency.id
        }
      }).done(function (response) {
        if (!response) {
          callback(null, "Something went wrong, please try again.");
        } else {
          if (response && response.error) {
            callback(null, "Error: " + (response.error || "Unknown error"));
          } else if (response && response.result && response.result.cart) {
            callback(response.result.cart, null);
          } else {
            callback(null, "Error: Unable to process transaction");
          }
        }
      }).fail(function (xhr, status, error) {
        if (error.responseJSON) {
          var errorMessage = error.responseJSON.error || error.responseJSON.message || "";
          callback(null, "Error: " + errorMessage);
        } else {
          callback(null, "Something went wrong, please try again.");
        }
      });
    }
  }, {
    key: "showVerificationModal",
    value: function showVerificationModal() {
      if (!this.actionModalElement) return;
      this.actionModalElement.find("#page-2").hide();
      this.actionModalElement.find("#page-1").show();
    }
  }, {
    key: "requestVerificationCode",
    value: function requestVerificationCode(email) {
      var _this9 = this;

      jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'verify_tribute_email',
          params: {
            client: this.client,
            teamId: this.team,
            email: email
          }
        }
      }).done(function (response) {
        if (response) {
          var data = JSON.parse(response);

          if (data && data.code) {
            _this9.verifyCode = data.code;

            _this9.showVerificationModal();
          } else {}

          console.log(data);
        }
      }).fail(function (xhr, status, error) {}).always(function () {
        var submitButton = _this9.actionModalElement.find("#tribute-form .modal-footer .submit-btn");

        submitButton.prop("disabled", false);
        submitButton.html("Submit");
      });
    }
  }, {
    key: "formDataToJSON",
    value: function formDataToJSON(formData) {
      var convertedJSON = {};
      formData.forEach(function (value, key) {
        if (typeof value == "string" && value.length == 0) {
          convertedJSON[key] = null;
        } else {
          convertedJSON[key] = value;
        }
      });
      return convertedJSON;
    } // Likes

  }, {
    key: "likeTributeDonation",
    value: function likeTributeDonation(id) {
      var _this10 = this;

      if (this.itemsWaiting[id]) return;
      this.itemsWaiting[id] = true;
      jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'like_tribute_donation',
          params: {
            id: id
          }
        }
      }).done(function (response) {
        var newLikesCount = null;

        if (response) {
          var data = JSON.parse(response);

          if (data && data.success && data.likes != null) {
            newLikesCount = data.likes;
            jQuery("#tribute-donation-".concat(id, " .likes .counter")).html("".concat(newLikesCount));
          }
        }

        _this10.itemsWaiting[id] = null;
      }).fail(function (xhr, status, error) {
        _this10.itemsWaiting[id] = null;
      });
    }
  }, {
    key: "unlikeTributeDonation",
    value: function unlikeTributeDonation(id) {
      var _this11 = this;

      if (this.itemsWaiting[id]) return;
      this.itemsWaiting[id] = true;
      jQuery.ajax({
        method: 'post',
        url: ajax_var.url,
        data: {
          action: 'unlike_tribute_donation',
          params: {
            id: id
          }
        }
      }).done(function (response) {
        var newLikesCount = null;

        if (response) {
          var data = JSON.parse(response);

          if (data && data.success && data.likes != null) {
            newLikesCount = data.likes;
            jQuery("#tribute-donation-".concat(id, " .likes .counter")).html("".concat(newLikesCount));
          }
        }

        _this11.itemsWaiting[id] = null;
      }).fail(function (xhr, status, error) {
        _this11.itemsWaiting[id] = null;
      });
    }
  }, {
    key: "setCookie",
    value: function setCookie(cname, cvalue, hours) {
      var d = new Date();
      d.setTime(d.getTime() + hours * 60 * 60 * 1000);
      var expires = "expires=" + d.toUTCString();
      document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }
  }, {
    key: "getCookie",
    value: function getCookie(cname) {
      var name = cname + "=";
      var decodedCookie = decodeURIComponent(document.cookie);
      var ca = decodedCookie.split(';');

      for (var i = 0; i < ca.length; i++) {
        var c = ca[i];

        while (c.charAt(0) == ' ') {
          c = c.substring(1);
        }

        if (c.indexOf(name) == 0) {
          return c.substring(name.length, c.length);
        }
      }

      return "";
    }
  }]);

  return FirehawkCRMServiceTributeDonations;
}();