<?php

class Single_Tribute
{

    public $client = null;
    public $client_page_id = null;

    public function __construct() {

    }

    public function detectClient() {
        $id = $_GET["id"];

        $queryId = get_query_var('id');
        if (!isset($id) && isset($queryId)) {
          $id = $queryId;
        }

        $this::setClientPageId($id);

        $use_custom_link = get_option("fcrm_tributes_readable_permalinks");
        if (empty($use_custom_link) || $use_custom_link == false || $use_custom_link == 0) {
          $use_custom_link = false;
        } else {
          $use_custom_link = true;
        }

        $redirect_query_parameter = get_option("fcrm_tributes_redirect_query_parameter");

        $client_found = null;
        $is_get_param = false;
        $page_id = $this::find_page_client_number($id);
        if (isset($redirect_query_parameter) && strlen($redirect_query_parameter) && isset($_GET[$redirect_query_parameter])) {
          $page_id = $_GET[$redirect_query_parameter];
          $is_get_param = true;
        }

        if (!is_admin() && $use_custom_link == true && !isset($page_id)) {
         return $this::error_view("Tribute not found", "We couldn't find this tribute.");
        }

        if ($use_custom_link == true) {
          $client_found = Fcrm_Tributes_Api::get_client_by_number($page_id, true, true);
          $this::setClient($client_found);
        } else {
          $client_found = Fcrm_Tributes_Api::get_client($id, true, true);
          $this::setClient($client_found);
        }
    }

    private function error_view($title, $message) {
        $error_message = $message;
        $error_message = "<h4>". $title ."</h4><p>". $message ."</p>";
        ob_start();
        require_once(plugin_dir_path(dirname(__FILE__)) . 'public/partials/fcrm-tributes-public-error.php');
        $content = ob_get_clean();
        return $content;
    }

    private function find_page_client_number($permalink)
    {
      if (!isset($permalink)) {
        return null;
      }

      $url_parts = explode('-', $permalink);
      $page_id = "";

      foreach ($url_parts as $key => $value) {
          if ($key != 0 && $key != 1) {
             $seperator = $key > 2 ? "-" : "";
             $page_id = $page_id.$seperator.$value;
          }
      }

      return empty($page_id) ? null : $page_id;
    }

    private function setClient($client) {
        $this->client = $client;
    }

    private function setClientPageId($pageId) {
        $this->client_page_id = $pageId;
    }

    public function getClient() {
        return $this->client;
    }

    public function getClientPageId() {
        return $this->client_page_id;
    }

    public static function getSingleTributePageId() {
        $detailPage = $attributes['detail-page'];
        $tributePage = get_option('fcrm_tributes_single_page');
        if (isset($tributePage) && !isset($detailPage)) {
          $detailPage = $tributePage;
        }
        
        return $detailPage;
    }

    public function getPageUrl() {
        $current_url = home_url();
        
        $detailPage = $attributes['detail-page'];
        $tributePage = get_option('fcrm_tributes_single_page');
        if (isset($tributePage) && !isset($detailPage)) {
          $detailPage = $tributePage;
        }

        if(!isset($current_url) || !isset($detailPage)) {
            return null;
        }

        return $current_url . "/" . $detailPage . "/" . $this->client_page_id . "/";
    }

}