<?php
/**
 * This file contains all publicly accessible API functions used in and for BTF.
 * All of them are pluggable and can be replaced with your own.
 */

$api_key = get_option('fcrm_tributes_api_key');


class Fcrm_Tributes_Flowers_Api
{
  static $api_url = "https://www.floristone.com/api/rest";
  static $per_page = 12;
  static $username = '591730';
  static $password = 'FGEzGO';

  public static function getProducts($category, $page){

    $args = array(
      'method' => 'GET',
      'httpversion' => '1.1',
      'sslverify' => true,
      'headers' => array(
        'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
      )
    );

    $count = self::$per_page;

    if ($category == 'default'){
      $category = 'fa';
    }

    if ($page == 1){
      $start = 1;
    } else {
      $start = 1 + (($page - 1) * $count);
    }

    $url    = self::$api_url . '/flowershop/getproducts?category=' . $category . '&start=' . $start . '&count=' . $count;
    $api_response =	wp_remote_request( $url, $args );
    $api_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );


    include 'partials/flowers/flower-delivery-many-products.php';

    die();

  }

  public static function getProduct($code){

    $args = array(
      'method' => 'GET',
      'httpversion' => '1.1',
      'sslverify' => true,
      'headers' => array(
        'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
      )
    );

    $url    = self::$api_url . '/flowershop/getproducts?code=' . $code;
    $api_response =	wp_remote_request( $url, $args );
    $api_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );

    include 'partials/flowers/flower-delivery-single-product.php';

    die();

  }

 public static function getTree($code)
 {

      $args = array(
        'method' => 'GET',
        'httpversion' => '1.1',
        'sslverify' => true,
        'headers' => array(
          'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
        )
      );

      $url    = self::$api_url . '/trees/gettree?code=' . $code;
      $api_response =	wp_remote_request( $url, $args );
      $api_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );

      $description_list = '<ul class="lh-base px-0 ms-3 text-start">';
       for ($bullet=0;$bullet < count($api_response_body['copy']);$bullet++){
           $description_list .= '<li class="mb-2">'.$api_response_body['copy'][$bullet]['text'].'</li>';
       }
       $description_list .= '</ul>';
       $api_response_body['PRODUCTS'][0]['PRICE'] = $api_response_body['Group1Pricing']['price'];
       $api_response_body['PRODUCTS'][0]['LARGE'] = $api_response_body['img'];
       $api_response_body['PRODUCTS'][0]['NAME'] = $api_response_body['itemName'];
       $api_response_body['PRODUCTS'][0]['DESCRIPTION'] = $description_list;

      include 'partials/flowers/flower-delivery-plant-a-tree.php';

      die();

  }

  public static function getTreesTotal($code,$number,$price)
  {

      $args = array(
        'method' => 'GET',
        'httpversion' => '1.1',
        'sslverify' => true,
        'headers' => array(
          'Authorization' => 'Basic '.base64_encode(self::$username . ':' . self::$password)
        )
      );

      $url  = self::$api_url . '/trees/getprice?code=' . $code . '&number='.$number;
      $api_response =	wp_remote_request($url, $args);
      $get_total_response_body = json_decode(wp_remote_retrieve_body($api_response), true);

      echo $get_total_response_body['price'];
      die();
  }

  public static function checkOrder($orderno){

      $args = array(
        'method' => 'GET',
        'httpversion' => '1.1',
        'sslverify' => true,
        'headers' => array(
          'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
        )
      );
      $url    = self::$api_url . '/wordpress/flowershop-check-order?orderno=' . $orderno;
      $api_response =	wp_remote_request( $url, $args );
      $api_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );

      $good_order = $api_response_body['SUCCESS'];

      if ($good_order == true){
        include 'partials/flowers/flower-delivery-checkout-5.php';
      }
      else {
        checkout(4, array());
      }

      die();

  }

  public static function createCart(){

    $args = array(
      'method' => 'POST',
      'httpversion' => '1.1',
      'sslverify' => true,
      'headers' => array(
        'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
      )
    );
    $url    = self::$api_url . '/shoppingcart';
    $api_response =	wp_remote_request( $url, $args );
    $sessionid = json_decode(wp_remote_retrieve_body( $api_response ))->{"SESSIONID"};

    $_SESSION['sesh'] = $sessionid;

    return $sessionid;

  }

  public static function getCartCount(){
    if (!isset($_SESSION['sesh'])){
      $sessionid = self::createCart();
    }
    else {
      $sessionid = $_SESSION['sesh'];

    }

    $args = array(
      'method' => 'GET',
      'httpversion' => '1.1',
      'sslverify' => true,
      'headers' => array(
        'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
      )
    );

    $url  = self::$api_url . '/shoppingcart?sessionid=' . $sessionid;
    $api_response =	wp_remote_request( $url, $args );
    $api_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );


    echo count($api_response_body['products']);
    die();
  }

  public static function getCartData(){

    if (!isset($_SESSION['sesh'])){
      $sessionid = self::createCart();
    }
    else {
      $sessionid = $_SESSION['sesh'];

    }

    $args = array(
      'method' => 'GET',
      'httpversion' => '1.1',
      'sslverify' => true,
      'headers' => array(
        'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
      )
    );

    $url  = self::$api_url . '/shoppingcart?sessionid=' . $sessionid;
    $api_response =	wp_remote_request( $url, $args );
    $api_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );


    if ($api_response_body['products'][0]['CODE'] == "TREE"){

     // return in cart
     $treeProduct = array();
        $tree = array(
           "CODE" =>  $api_response_body['products'][0]['CODE'],
           "NUMBER" => intval(preg_replace('/[^0-9.]+/', '', $api_response_body['products'][0]['NAME'])),
           "PRICE" =>  $api_response_body['products'][0]['PRICE']

        );

        array_push($treeProduct,$tree);

        $url_tree = self::$api_url . '/trees/gettree?code=TREE';
        $api_response_tree =	wp_remote_request( $url_tree, $args );
        $api_response_body_tree = json_decode( wp_remote_retrieve_body( $api_response_tree ), true );


        $url  = self::$api_url . '/trees/gettotal?products=' . json_encode($treeProduct);
        $api_response =	wp_remote_request($url, $args);
        $get_total_response_body = json_decode(wp_remote_retrieve_body($api_response), true);

        $products = array();
        $products_for_display = array(

           array(

               "IMG" => $api_response_body_tree["img"],
               "CODE" => $api_response_body['products'][0]['CODE'],
               "PRICE" => number_format($api_response_body['products'][0]['PRICE'], 2, '.', ''),
               "NAME" =>  $api_response_body['products'][0]['NAME']

           )

        );
        $products = $products_for_display;

        $errors = array();
        $errors = $get_total_response_body['errors'];


    } else {
    $errors = array();
    $errors = $api_response_body[errors];

    $products = array();
    $products_for_display = array();

    if (isset($_SESSION['fcrm-tribute-flowers-recipient-postal-code'])){
      $zipcode = $_SESSION['fcrm-tribute-flowers-recipient-postal-code'];
    } else {
      $zipcode = '11779';
    }

    for($i=0;$i<count($api_response_body["products"]);$i++){
      $code = $api_response_body["products"][$i]['CODE'];
      $url  = self::$api_url . '/flowershop/getproducts?code=' . $code;
      $api_response =	wp_remote_request( $url, $args );
      $get_products_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );



      $product = array(
        "CODE" =>  $get_products_response_body["PRODUCTS"][0]['CODE'],
        "PRICE" => $get_products_response_body["PRODUCTS"][0]['PRICE'],
        "IMG" =>  $get_products_response_body["PRODUCTS"][0]['LARGE'],
        "RECIPIENT" => array(
          "ZIPCODE" => $zipcode
        )
      );
      array_push($products, $product);
      $product = array(
        "CODE" =>  $get_products_response_body["PRODUCTS"][0]['CODE'],
        "PRICE" => $get_products_response_body["PRODUCTS"][0]['PRICE'],
        "NAME" => $get_products_response_body["PRODUCTS"][0]['NAME'],
        "IMG" => $get_products_response_body["PRODUCTS"][0]['LARGE']
      );
      array_push($products_for_display, $product);
   }

   $url    = self::$api_url . '/flowershop/gettotal?products=' . json_encode($products);
   $api_response =	wp_remote_request( $url, $args );
   $get_total_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );


    }

   $vars = array(
     'get_total_response_body' => $get_total_response_body,
     'products_for_display' => $products_for_display,
     'products' => $products,
     'errors' => $errors
   );

   return $vars;

  }

  public static function getCart($code){

     $vars = self::getCartData();
     $get_total_response_body = $vars['get_total_response_body'];
     $products_for_display = $vars['products_for_display'];
     $products = $vars['products'];
     $errors = $vars['errors'];

     if ($products_for_display[0]['CODE'] == "TREE"){
          $display_tree_message_seperate = "Flowers and trees cannot be purchased together and need to be purchased separately.";
     }

     include 'partials/flowers/flower-delivery-cart.php';
     die();
  }

  public static function addToCart($code){
    if (!isset($_SESSION['sesh'])){
      $sessionid = self::createCart();
    } else {
      $sessionid = $_SESSION['sesh'];
      if (self::checkCartStillExists() == false){
        $sessionid = self::createCart();
      }
    }

    //check if adding tree to flower
    $messageTree = false;

    if (strpos($code, 'Trees') !== false ){
      $checkCart = self::getCartData();

      if (count($checkCart['products_for_display']) != 0){
         if($checkCart['products_for_display'][0]["CODE"] != "TREE"){// not adding tree
           $messageTree = true;
        }
      }
    }

    $args = array(
      'method' => 'PUT',
      'httpversion' => '1.1',
      'sslverify' => true,
      'headers' => array(
        'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password),
        'Content-Length' => 0
      )
    );

    $url    = self::$api_url . '/shoppingcart?action=add&sessionid=' . $sessionid . '&productcode=' . $code;
    $api_response =	wp_remote_request( $url, $args );

    if ($messageTree){
     $code = "Not a TREE";
    }

    self::getCart($code);
  }

  public static function checkCartStillExists(){
    $vars = self::getCartData();
    $errors = $vars[errors];

    for($i=0;$i<count($errors);$i++){
      if ($errors[$i] == 'invalid sessionid' || $errors[$i] == 'The sessionid does not exist'){
        return false;
      }
    }
    return true;
  }

  public static function removeFromCart($code){

      if (!isset($_SESSION['sesh'])){
        $sessionid = self::createCart();
      }
      else {
        $sessionid = $_SESSION['sesh'];
        if (self::checkCartStillExists() == false){
          $sessionid = self::createCart();
        }
      }

      $args = array(
        'method' => 'PUT',
        'httpversion' => '1.1',
        'sslverify' => true,
        'headers' => array(
          'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password),
          'Content-Length' => 0
        )
      );
      $url    = self::$api_url . '/shoppingcart?action=remove&sessionid=' . $sessionid . '&productcode=' . $code;
      $api_response =	wp_remote_request( $url, $args );


      self::getCart(null);
  }

  public static function getCustomerService(){
      $currency = get_option('fcrm_tributes_currency');
      if (!isset($currency)) {
        $currency = "USD";
      }

      $args = array(
        'method' => 'GET',
        'httpversion' => '1.1',
        'sslverify' => true,
        'headers' => array(
          'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
        )
      );
      $url    = self::$api_url . '/flowershop/customerservice?currency' . $currency;
      $api_response =	wp_remote_request( $url, $args );
      $api_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );

      include 'partials/flowers/flower-delivery-customer-service.php';
      die();
  }

  public static function createAuthorizeNetHostedForm($amount, $redirect_url, $payload)
  {
      $data = array(
        'amount' => $amount,
        'redirect_url' => strtok($redirect_url, '?'),
        'payload' => json_encode($payload),
        'plugin' => 'firehawk-tributes'
      );

      $args = array(
       'method' => 'POST',
       'httpversion' => '1.1',
       'sslverify' => true,
       'headers' => array(
         'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
       ),
       'body' => $data
     );

      $url    = self::$api_url . '/wordpress/paymentForm';
      $api_response =	wp_remote_request($url, $args);

      $api_response_body = json_decode(wp_remote_retrieve_body($api_response), true);

      return $api_response_body;
  }

 public static function clearCart(){

     $args = array(
       'method' => 'PUT',
       'httpversion' => '1.1',
       'sslverify' => true,
       'headers' => array(
         'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password),
         'Content-Length' => 0
       )
     );
     $sessionid = $_SESSION['sesh'];
     $url    = self::$api_url . '/shoppingcart?action=clear&sessionid=' . $sessionid;
     $api_response =	wp_remote_request( $url, $args );

 }

  public static function getDeliveryDates($zipcode){

      $args = array(
        'method' => 'GET',
        'httpversion' => '1.1',
        'sslverify' => true,
        'headers' => array(
          'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
        )
      );
      $url    = self::$api_url . '/flowershop/checkdeliverydate?zipcode=' . $zipcode;
      $api_response =	wp_remote_request( $url, $args );
      return json_decode( wp_remote_retrieve_body( $api_response ), true );

  }

  public static function generateAuthorizeNetKey() {
    $args = array(
      'method' => 'GET',
      'httpversion' => '1.1',
      'sslverify' => true,
      'headers' => array(
        'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
      )
    );
    $url    = self::$api_url . '/flowershop/getauthorizenetkey';
    $api_response =	wp_remote_request( $url, $args );
    return json_decode( wp_remote_retrieve_body( $api_response ), true );
  }

  public static function checkout($page, $formdata, $validated){
      self::storeCheckoutData($formdata);

      $core_postal_code = get_option('fcrm_tributes_f1_postal_code');

      if (isset($_SESSION['fcrm-tribute-flowers-recipient-postal-code']) && strlen($_SESSION['fcrm-tribute-flowers-recipient-postal-code']) > 0){
        $zipcode = $_SESSION['fcrm-tribute-flowers-recipient-postal-code'];
      }
      else if (isset($core_postal_code) && strlen($core_postal_code) > 0){
        $zipcode = $core_postal_code;
      }
      else {
        $zipcode = '11779';
      }

      switch($page){
       case 1:
          if (isset($_SESSION['fcrm-tribute-flowers-authnet-key'])) {
            $authnet_data = [
              "AUTHORIZENET_URL" => $_SESSION['fcrm-tribute-flowers-authnet-url'],
              "AUTHORIZENET_KEY" => $_SESSION['fcrm-tribute-flowers-authnet-key'],
              "USERNAME" => $_SESSION['fcrm-tribute-flowers-authnet-username']
            ];
          } else {
            $authnet_data = self::generateAuthorizeNetKey();
            $_SESSION['fcrm-tribute-flowers-authnet-url'] = $authnet_data["AUTHORIZENET_URL"];
            $_SESSION['fcrm-tribute-flowers-authnet-key'] = $authnet_data["AUTHORIZENET_KEY"];
            $_SESSION['fcrm-tribute-flowers-authnet-username'] = $authnet_data["USERNAME"];
          }

         $delivery_dates = self::getDeliveryDates($zipcode);
         include 'partials/flowers/flower-delivery-checkout-1.php';
         break;
       case 2:
         $_SESSION['fcrm-tribute-flowers-tree-certificate'] = "";
         include 'partials/flowers/flower-delivery-checkout-2.php';
         break;
       case 3:
         include 'partials/flowers/flower-delivery-checkout-3.php';
         break;
       case 4:
         $delivery_dates = self::getDeliveryDates($zipcode);
         $vars = self::getCartData();
         $get_total_response_body = $vars["get_total_response_body"];
         $products_for_display = $vars["products_for_display"];
         $products = $vars["products"];
         $errors = $vars["errors"];
         include 'partials/flowers/flower-delivery-checkout-4.php';
         break;
       case 5:
         $orderno = $formdata[0][value];
         session_unset();
         include 'partials/flowers/flower-delivery-checkout-5.php';
         break;
       case 6:
         include 'partials/flowers/flower-delivery-ssl-warning.php';
         break;
      }

      die();

  }

  public static function storeCheckoutData($formdata) {
    for ($i = 0; $i < count($formdata); $i++){
      error_log($formdata[$i]['name'] . ' = '. $formdata[$i]['value']);
      $_SESSION[''.$formdata[$i]['name'].''] = $formdata[$i]['value'];
    }
  }

  public static function processOrder() {

     $vars = self::getCartData();
     $get_total_response_body = $vars["get_total_response_body"];
     $products_for_display = $vars["products_for_display"];
     $products = $vars["products"];
     $products_for_api = array();
     $treeDeliveryMethod = $_SESSION['fcrm-tribute-flowers-tree-certificate'];

     $ccinfo = json_encode(array(
      'type' => $_SESSION['fcrm-tribute-flowers-billing-credit-card'],
      'ccnum' => $_SESSION['fcrm-tribute-flowers-billing-credit-card-no'],
      'cvv2' => $_SESSION['fcrm-tribute-flowers-billing-security-code'],
      'expmonth' => $_SESSION['fcrm-tribute-flowers-billing-exp-month'],
      'expyear' => $_SESSION['fcrm-tribute-flowers-billing-exp-year']
     ));

     // check if tree //

     if ($products_for_display[0]["CODE"] == "TREE") { // if a trees

       $customer = json_encode(array(
         'first_name' => $_SESSION['fcrm-tribute-flowers-customer-name'],
         'last_name' => null,
         'address' => $_SESSION['fcrm-tribute-flowers-customer-address-1'] . " " . $_SESSION['fcrm-tribute-flowers-customer-address-2'] ,
         'city' => $_SESSION['fcrm-tribute-flowers-customer-city'],
         'state' => $_SESSION['fcrm-tribute-flowers-customer-state'],
         'zipcode' => $_SESSION['fcrm-tribute-flowers-customer-postal-code'],
         'country' => $_SESSION['fcrm-tribute-flowers-customer-country'],
         'phone' => $_SESSION['fcrm-tribute-flowers-customer-phone'],
         'email' => $_SESSION['fcrm-tribute-flowers-customer-email'],
         'ip' => $_SERVER['REMOTE_ADDR']
       ));

       $recipient = json_encode(array(
         'message' => ($treeDeliveryMethod == "Cert-email-behalf") ? $_SESSION['fcrm-tribute-flowers-tree-certificate-email-behalf-message-to-recipient'] : null,
         'first_name' => ($treeDeliveryMethod == "Cert-email-behalf") ?$_SESSION['fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-name'] :null,
         'last_name' => null,
         'email' => ($treeDeliveryMethod == "Cert-email-behalf") ? $_SESSION['fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-email']:null,
         'send_certificate' => ($treeDeliveryMethod == "Cert-email-behalf") ? 1 : 0
       ));

       $treeOrder = json_encode(array(
         'code' => $products[0]["CODE"],
         'number' => intval(preg_replace('/[^0-9.]+/', '', $products[0]['NAME'])),
         'amount' => $products[0]["PRICE"]
       ));


     } else {

       $customer = json_encode(array(
         'name' => $_SESSION['fcrm-tribute-flowers-customer-name'],
         'address1' => $_SESSION['fcrm-tribute-flowers-customer-address-1'],
         'address2' => $_SESSION['fcrm-tribute-flowers-customer-address-2'],
         'city' => $_SESSION['fcrm-tribute-flowers-customer-city'],
         'state' => $_SESSION['fcrm-tribute-flowers-customer-state'],
         'zipcode' => $_SESSION['fcrm-tribute-flowers-customer-postal-code'],
         'country' => $_SESSION['fcrm-tribute-flowers-customer-country'],
         'phone' => $_SESSION['fcrm-tribute-flowers-customer-phone'],
         'email' => $_SESSION['fcrm-tribute-flowers-customer-email'],
         'ip' => $_SERVER['REMOTE_ADDR']
       ));

       $products_for_api = array();
       for($i=0;$i<count($products);$i++){
         $product = array(
           'code' => $products[$i][CODE],
           'price' => $products[$i][PRICE],
           'deliverydate' => $_SESSION['fcrm-tribute-flowers-delivery-date'],
           'cardmessage' => $_SESSION['fcrm-tribute-flowers-card-message'],
           'specialinstructions' => $_SESSION['fcrm-tribute-flowers-special-instructions'],
           'recipient' => array(
             'name' => $_SESSION['fcrm-tribute-flowers-recipient-name'],
             'institution' => $_SESSION['fcrm-tribute-flowers-recipient-institution'],
             'address1' => $_SESSION['fcrm-tribute-flowers-recipient-address-1'],
             'address2' => $_SESSION['fcrm-tribute-flowers-recipient-address-2'],
             'city' => $_SESSION['fcrm-tribute-flowers-recipient-city'],
             'state' => $_SESSION['fcrm-tribute-flowers-recipient-state'],
             'country' => $_SESSION['fcrm-tribute-flowers-recipient-country'],
             'phone' => $_SESSION['fcrm-tribute-flowers-recipient-phone'],
             'zipcode' => $_SESSION['fcrm-tribute-flowers-recipient-postal-code']
           )
         );
         array_push($products_for_api, $product);
       }

     }

     $products_for_api = json_encode($products_for_api);
     $ordertotal = $get_total_response_body["ORDERTOTAL"];

     $f1_aff_id = get_option('fcrm_tributes_f1_aff_id');
     $data = array(
       'products' => sanitize_text_field( $products_for_api ),
       'customer' => sanitize_text_field( $customer ),
       'ccinfo' => sanitize_text_field( $ccinfo ),
       'ordertotal' => sanitize_text_field( $ordertotal ),
       'f1_aff_id' => sanitize_text_field( $f1_aff_id )
     );

     if ($products_for_display[0]["CODE"] == "TREE") {
        $deceased_display_name = $_SESSION['fcrm-tribute-flowers-tree-certificate-name-of-loved-one'];
        $data["deceased_display_name"] = sanitize_text_field($deceased_display_name);
        $data["product"] = sanitize_text_field($treeOrder);
        $data["recipient"] = sanitize_text_field($recipient);
        $data["referring_affiliate_id"] = sanitize_text_field( $f1_aff_id );
        $url = self::$api_url . '/trees/placeorder';
        unset($data["products"]);
        unset($data["f1_aff_id"]);
     } else {
       $url = self::$api_url . '/flowershop/placeorder';
     }

     $args = array(
        'method' => 'POST',
        'httpversion' => '1.1',
        'sslverify' => true,
        'headers' => array(
          'Authorization' => 'Basic '.base64_encode( self::$username . ':' . self::$password)
        ),
        'body' => $data
     );

     $api_response =	wp_remote_request( $url, $args );
     $api_response_body = json_decode( wp_remote_retrieve_body( $api_response ), true );

     echo json_encode($api_response_body);

     die();

  }

  public static function init_flower_delivery() {

     if (!(isset($_SESSION['fcrm-tribute-flowers-recipient-postal-code']))){
       //TODO: Configure team information
       // $options = get_option('fhw-solutions-obituaries_1');
       // $_SESSION['fcrm-tribute-flowers-recipient-institution'] = $options['funeral_home_name'];
       // $_SESSION['fcrm-tribute-flowers-recipient-address-1'] = $options['funeral_home_address'];
       // $_SESSION['fcrm-tribute-flowers-recipient-city'] = $options['funeral_home_city'];
       // $_SESSION['fcrm-tribute-flowers-recipient-state'] = $options['funeral_home_state'];
       // $_SESSION['fcrm-tribute-flowers-recipient-country'] = $options['funeral_home_country'];
       // $_SESSION['fcrm-tribute-flowers-recipient-phone'] = $options['funeral_home_phone'];
       // $_SESSION['fcrm-tribute-flowers-recipient-postal-code'] = $options['funeral_home_zip'];
     }

     $htmlString = '';
     //$htmlString .= '<div class="fcrm-tribute-flowers-container bootstrap-fhws-obituaries-container" id="flowers">';
     $htmlString .= self::init_flower_delivery_menu();
     $htmlString .= '<div class="fcrm-tribute-flowers-page-content"></div>';
     $htmlString .= '<div class="fcrm-tributes-flowers-loader"><div class="fcrms-spinner primary xl" role="status"><span class="visually-hidden">Loading...</span></div></div>';


     // pre-pop values from obit session
     $htmlString .= '<input type="hidden" id="fcrm-tribute-flowers-recipient-name" value="' . $_SESSION['fcrm-tribute-flowers-recipient-name'] . '">';
     $htmlString .= '<input type="hidden" id="fcrm-tribute-flowers-recipient-institution" value="' . $_SESSION['fcrm-tribute-flowers-recipient-institution'] . '">';
     $htmlString .= '<input type="hidden" id="fcrm-tribute-flowers-recipient-address-1" value="' . $_SESSION['fcrm-tribute-flowers-recipient-address-1'] . '">';
     $htmlString .= '<input type="hidden" id="fcrm-tribute-flowers-recipient-city" value="' . $_SESSION['fcrm-tribute-flowers-recipient-city'] . '">';
     $htmlString .= '<input type="hidden" id="fcrm-tribute-flowers-recipient-state" value="' . $_SESSION['fcrm-tribute-flowers-recipient-state'] . '">';
     $htmlString .= '<input type="hidden" id="fcrm-tribute-flowers-recipient-country" value="' . $_SESSION['fcrm-tribute-flowers-recipient-country'] . '">';
     $htmlString .= '<input type="hidden" id="fcrm-tribute-flowers-recipient-phone" value="' . $_SESSION['fcrm-tribute-flowers-recipient-phone'] . '">';
     $htmlString .= '<input type="hidden" id="fcrm-tribute-flowers-recipient-postal-code" value="' . $_SESSION['fcrm-tribute-flowers-recipient-postal-code'] . '">';

     return $htmlString;
   }

   public static function init_flower_delivery_menu() {
       ob_start();
       echo '<div class="fcrm-tributes-flower-menu">';
       include 'partials/flowers/flower-delivery-menu.php';
       echo '</div>';
       $buffer = ob_get_clean();
       return $buffer;
   }

   public static function setFlowerSessionData($data){

     // select tree certificate delivery Method
     $_SESSION['fcrm-tribute-flowers-tree-certificate-name-of-loved-one'] =  ($data['fcrm-tribute-flowers-tree-certificate-name-of-loved-one'] == null)? $data['name'] : $data['fcrm-tribute-flowers-tree-certificate-name-of-loved-one'] ;
     $_SESSION['fcrm-tribute-flowers-tree-certificate'] = $data['fcrm-tribute-flowers-tree-certificate'];
     $_SESSION['fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-name'] = $data['fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-name'];
     $_SESSION['fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-email'] = $data['fcrm-tribute-flowers-tree-certificate-email-behalf-recipient-email'];
     $_SESSION['fcrm-tribute-flowers-tree-certificate-email-behalf-message-to-recipient'] = $data['fcrm-tribute-flowers-tree-certificate-email-behalf-message-to-recipient'];

     // bill to
     $_SESSION['fcrm-tribute-flowers-customer-name'] = $data['fcrm-tribute-flowers-customer-name'];
     $_SESSION['fcrm-tribute-flowers-customer-email'] = $data['fcrm-tribute-flowers-customer-email'];
     $_SESSION['fcrm-tribute-flowers-customer-address-1'] = $data['fcrm-tribute-flowers-customer-address-1'];
     $_SESSION['fcrm-tribute-flowers-customer-address-2'] = $data['fcrm-tribute-flowers-customer-address-2'];
     $_SESSION['fcrm-tribute-flowers-customer-state'] = $data['fcrm-tribute-flowers-customer-state'];
     $_SESSION['fcrm-tribute-flowers-customer-city'] = $data['fcrm-tribute-flowers-customer-city'];
     $_SESSION['fcrm-tribute-flowers-customer-country'] = $data['fcrm-tribute-flowers-customer-country'];
     $_SESSION['fcrm-tribute-flowers-customer-postal-code'] = $data['fcrm-tribute-flowers-customer-postal-code'];
     $_SESSION['fcrm-tribute-flowers-customer-phone'] = $data['fcrm-tribute-flowers-customer-phone'];

     // deliver info
     $_SESSION['fcrm-tribute-flowers-delivery-date'] = $data['fcrm-tribute-flowers-delivery-date'];
     $_SESSION['fcrm-tribute-flowers-special-card-message'] = $data['fcrm-tribute-flowers-special-card-message'];
     $_SESSION['fcrm-tribute-flowers-special-special-instructions'] = $data['fcrm-tribute-flowers-special-special-instructions'];

     // deliver to
     $_SESSION['fcrm-tribute-flowers-recipient-name'] = ($data['fcrm-tribute-flowers-recipient-name'] == null) ? $data['name'] : $data['fcrm-tribute-flowers-recipient-name'] ;
     $_SESSION['fcrm-tribute-flowers-recipient-institution'] = ($data['fcrm-tribute-flowers-recipient-institution'] == null) ?  $data['institution'] : $data['fcrm-tribute-flowers-recipient-institution'];
     $_SESSION['fcrm-tribute-flowers-recipient-address-1'] = ($data['fcrm-tribute-flowers-recipient-address-1'] == null) ?  $data['address1'] : $data['fcrm-tribute-flowers-recipient-address-1'];
     $_SESSION['fcrm-tribute-flowers-recipient-city'] = ($data['fcrm-tribute-flowers-recipient-city'] == null) ?  $data['city'] : $data['fcrm-tribute-flowers-recipient-city'];
     $_SESSION['fcrm-tribute-flowers-recipient-state'] = ($data['fcrm-tribute-flowers-recipient-state'] == null) ? $data['state'] : $data['fcrm-tribute-flowers-recipient-state'];
     $_SESSION['fcrm-tribute-flowers-recipient-country'] = ($data['fcrm-tribute-flowers-recipient-country'] == null) ?  $data['country'] : $data['fcrm-tribute-flowers-recipient-country'];
     $_SESSION['fcrm-tribute-flowers-recipient-phone'] = ($data['fcrm-tribute-flowers-recipient-phone'] == null) ?  $data['phone'] : $data['fcrm-tribute-flowers-recipient-phone'];
     $_SESSION['fcrm-tribute-flowers-recipient-postal-code'] = ($data['fcrm-tribute-flowers-recipient-postal-code'] == null) ?  $data['zip'] : $data['fcrm-tribute-flowers-recipient-postal-code'];
     $_SESSION['fcrm-tribute-flowers-recipient-address-2'] = $data['fcrm-tribute-flowers-recipient-address-2'];

     die();
   }
}

if (isset($_REQUEST['action'])){

  if (!session_id()) {
    session_start();
  }

  if ($_REQUEST['action'] == "getProducts"){
    Fcrm_Tributes_Flowers_Api::getProducts($_REQUEST['category'], $_REQUEST['page']);
  }
  else if ($_REQUEST['action'] == "getProduct") {
    Fcrm_Tributes_Flowers_Api::getProduct($_REQUEST['code']);
  }
  else if ($_REQUEST['action'] == "getTree") {
    Fcrm_Tributes_Flowers_Api::getTree($_REQUEST['code']);
  }
  else if ($_REQUEST['action'] == "getTreesTotal") {
    Fcrm_Tributes_Flowers_Api::getTreesTotal($_REQUEST['code'], $_REQUEST['number'], $_REQUEST['price']);
  }
  else if ($_REQUEST['action'] == "addToCart") {
    Fcrm_Tributes_Flowers_Api::addToCart($_REQUEST['code']);
  }
  else if ($_REQUEST['action'] == "removeFromCart") {
    Fcrm_Tributes_Flowers_Api::removeFromCart($_REQUEST['code']);
  }
  else if ($_REQUEST['action'] == "getCart"){
    Fcrm_Tributes_Flowers_Api::getCart($_REQUEST['code']);
  }
  else if ($_REQUEST['action'] == "getCustomerService") {
    Fcrm_Tributes_Flowers_Api::getCustomerService();
  }
  else if ($_REQUEST['action'] == "checkout"){
    Fcrm_Tributes_Flowers_Api::checkout($_REQUEST['page'], $_REQUEST['formdata'], $_REQUEST['trees']);
  }
  else if ($_REQUEST['action'] == "processOrder") {
    Fcrm_Tributes_Flowers_Api::processOrder();
  }
  else if ($_REQUEST['action'] == "createAuthorizeNetHostedForm") {
    Fcrm_Tributes_Flowers_Api::createAuthorizeNetHostedForm($_REQUEST['amount'], $_REQUEST['redirect_url'], $_REQUEST['payload']);
  }
  else if ($_REQUEST['action'] == "checkOrder"){
    Fcrm_Tributes_Flowers_Api::checkOrder($_REQUEST['orderno']);
  }
  else if ($_REQUEST['action'] == "setFlowerSessionData"){
    Fcrm_Tributes_Flowers_Api::setFlowerSessionData($_REQUEST);
  }
  else if ($_REQUEST['action'] == "getCartCount"){
    Fcrm_Tributes_Flowers_Api::getCartCount($_REQUEST);
  }
}
