<?php
/**
 * This file contains all publicly accessible API functions used in and for BTF.
 * All of them are pluggable and can be replaced with your own.
 */

$api_key = get_option('fcrm_tributes_api_key');


class Fcrm_Tributes_Api
{

    static $apiUrl = "https://api.firehawkcrm.com";

    public static function get_clients($params)
    {
        if (isset($params["from-today"])) {
          $params["fromToday"] = $params["from-today"] === "true";
        }

        $range = [];
        $hasRange = false;
        if (isset($params["range-months"]) && $params["range-months"] > 0) {
          $range["months"] = $params["range-months"];
          $hasRange = true;
        }

        if (isset($params["range-days"]) && $params["range-days"] > 0) {
          $range["days"] = $params["range-days"];
          $hasRange = true;
        }
        if (isset($params["range-hours"]) && $params["range-hours"] > 0) {
          $range["hours"] = $params["range-hours"];
          $hasRange = true;
        }

        if ($hasRange) {
          $params["range"] = $range;
        }

        $fcrmTeam = get_option('fcrm_tributes_team');
        $request_params = array('body' => $params);

        $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/clients/" . $fcrmTeam;
        $request = wp_remote_post($url, $request_params);
        if (is_wp_error($request)) {
            return null;
        }
        $body = wp_remote_retrieve_body($request);
        $data = json_decode($body);

        if (! empty($data)) {
          return $data;
        } else {
          return null;
        }
      }

    public static function get_client($id, $gallery = false, $extra = false)
    {
        $fcrmTeam = get_option('fcrm_tributes_team');

        $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/client/" . $id . "?teamId=".$fcrmTeam;

        if ($extra == true) {
          $url = $url . "&tribute=true";
        }

        if ($gallery == true) {
          $url = $url . "&gallery=true";
        }

        $request = wp_remote_get($url);
        if (is_wp_error($request)) {
            return null;
        }
        $body = wp_remote_retrieve_body($request);
        $data = json_decode($body);

        if (! empty($data)) {
          if (isset($data->tributeBannerImage) && isset($data->tributeBannerImage[0]->downloadUrl)) {
            $data->bannerImage = $data->tributeBannerImage[0]->downloadUrl;
          } else if (isset($data->tributeBannerImage) && isset($data->tributeBannerImage->downloadUrl)) {
            $data->bannerImage = $data->tributeBannerImage->downloadUrl;
          } else if (isset($data->gallery)) {
            foreach ($data->gallery as $key => $galleryItem) {
              if (isset($galleryItem->tags) && in_array("tribute-banner", $galleryItem->tags)) {
                $data->bannerImage = $galleryItem->downloadUrl;
                unset($data->gallery[$key]);
                break;
              }
            }
          }

          if (!isset($data->bannerImage) && isset($data->defaultBannerImage)) {
            $data->bannerImage = $data->defaultBannerImage;
          }

          $data->meta_dod = Fcrm_Tributes_Api::format_dod($data);
          $data->meta_service = Fcrm_Tributes_Api::format_service_details($data);

          return $data;
        } else {
          return null;
        }
    }

    public static function get_client_by_number($client_number, $gallery = false, $extra = false)
    {
        $fcrmTeam = get_option('fcrm_tributes_team');

        $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/client/file-number/" . $client_number . "?teamId=".$fcrmTeam;

        if ($extra == true) {
          $url = $url . "&tribute=true";
        }

        if ($gallery == true) {
          $url = $url . "&gallery=true";
        }

        $request = wp_remote_get($url);
        if (is_wp_error($request)) {
            return null;
        }
        $body = wp_remote_retrieve_body($request);
        $data = json_decode($body);

        if (! empty($data)) {
          if (isset($data->tributeBannerImage) && isset($data->tributeBannerImage[0]->downloadUrl)) {
            $data->bannerImage = $data->tributeBannerImage[0]->downloadUrl;
          } else if (isset($data->tributeBannerImage) && isset($data->tributeBannerImage->downloadUrl)) {
            $data->bannerImage = $data->tributeBannerImage->downloadUrl;
          } else if (isset($data->gallery)) {
            foreach ($data->gallery as $key => $galleryItem) {
              if (isset($galleryItem->tags) && in_array("tribute-banner", $galleryItem->tags)) {
                $data->bannerImage = $galleryItem->downloadUrl;
                unset($data->gallery[$key]);
                break;
              }
            }
          }

          if (!isset($data->bannerImage) && isset($data->defaultBannerImage)) {
            $data->bannerImage = $data->defaultBannerImage;
          }

          $data->meta_dod = Fcrm_Tributes_Api::format_dod($data);
          $data->meta_service = Fcrm_Tributes_Api::format_service_details($data);

          return $data;
        } else {
          return null;
        }
    }

    public static function get_tribute_messages($params)
    {
        $id = $params["client"];
        $fcrmTeam = get_option('fcrm_tributes_team');
        $params["teamId"] = $fcrmTeam;

        $request_params = array('body' => $params);

        $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/client/" . $id . "/messages";
        $request = wp_remote_post($url, $request_params);

        // var_dump($url);
        if (is_wp_error($request)) {
            return null;
        }
        $body = wp_remote_retrieve_body($request);
        $data = json_decode($body);

        if (! empty($data)) {
          return $data;
        } else {
          return null;
        }
    }

    public static function get_tribute_trees($params)
    {
        $id = $params["client"];
        $fcrmTeam = get_option('fcrm_tributes_team');
        $params["teamId"] = $fcrmTeam;

        $request_params = array('body' => $params);

        $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/client/" . $id . "/trees";
        $request = wp_remote_post($url, $request_params);

        // var_dump($url);
        if (is_wp_error($request)) {
            return null;
        }
        $body = wp_remote_retrieve_body($request);
        $data = json_decode($body);

        if (! empty($data)) {
          return $data;
        } else {
          return null;
        }
    }

    public static function get_tribute_donations($params)
    {
        $id = $params["client"];
        $fcrmTeam = get_option('fcrm_tributes_team');
        $params["teamId"] = $fcrmTeam;

        $request_params = array('body' => $params);

        $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/client/" . $id . "/donations";
        $request = wp_remote_post($url, $request_params);

        // var_dump($url);
        if (is_wp_error($request)) {
            return null;
        }
        $body = wp_remote_retrieve_body($request);
        $data = json_decode($body);

        if (! empty($data)) {
          return $data;
        } else {
          return null;
        }
    }

    public static function verify_tribute_email($params) {
      $id = $params["client"];
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/client/" . $id . "/verify-tribute";
      $request = wp_remote_post($url, $request_params);

      if (is_wp_error($request)) {
          return null;
      }
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function verify_tribute_code($params) {
      $id = $params["id"];
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/verify-tribute-code/" . $id;
      $request = wp_remote_post($url, $request_params);

      if (is_wp_error($request)) {
          return null;
      }
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function verify_edit_tribute_email($params) {
      $id = $params["id"];
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/tribute-message/" . $id . "/verify-edit";
      $request = wp_remote_post($url, $request_params);

      // if (is_wp_error($request)) {
      //     return null;
      // }
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function edit_tribute_message($params) {
      $request_params = array('body' => $params);

      $url = "https://api.firehawkcrm.com/v2/wp/tributes/edit-message";
      $request = wp_remote_post($url, $request_params);

      if (is_wp_error($request)) {
          return null;
      }
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function create_tribute_message($params) {
      $request_params = array('body' => $params);

      $url = "https://api.firehawkcrm.com/v2/wp/tributes/create-message";
      $request = wp_remote_post($url, $request_params);

      if (is_wp_error($request)) {
          return null;
      }
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function like_tribute_message($params) {
      $id = $params["id"];
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/tribute-message/" . $id . "/like";
      $request = wp_remote_post($url, $request_params);
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function unlike_tribute_message($params) {
      $id = $params["id"];
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/tribute-message/" . $id . "/unlike";
      $request = wp_remote_post($url, $request_params);
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function get_tributes($params)
    {
        $fcrmTeam = get_option('fcrm_tributes_team');
        $fcrmBrand = get_option('fcrm_tributes_team_brand');
        $params["brand"] = $fcrmBrand;
        $request_params = array('body' => $params);

        $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/tributes/" . $fcrmTeam;
        $request = wp_remote_post($url, array(
            'headers'     => array('Content-Type' => 'application/json; charset=utf-8'),
            'body'        => json_encode($params),
            'method'      => 'POST',
            'data_format' => 'body',
        ));
        if (is_wp_error($request)) {
            return null;
        }
        $body = wp_remote_retrieve_body($request);
        $data = json_decode($body);

        if (! empty($data)) {
          return $data;
        } else {
          return null;
        }
    }

    public static function get_tributes_sitemap($from = 0)
    {
        $fcrmTeam = get_option('fcrm_tributes_team');
        $fcrmBrand = get_option('fcrm_tributes_team_brand');
        $params = [
          "limit" => 500,
          "brand" => $fcrmBrand,
          "sitemap" => true,
          "from" => $from * 500,
          "sort" => [[
            "field" => "timestamp",
            "order" => "desc"
          ]]
        ];
        $request_params = array('body' => $params, 'timeout' => 45);

        $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/tributes/" . $fcrmTeam;
        $request = wp_remote_post($url, array(
            'headers'     => array('Content-Type' => 'application/json; charset=utf-8'),
            'body'        => json_encode($params),
            'method'      => 'POST',
            'data_format' => 'body',
        ));
        if (is_wp_error($request)) {
            return null;
        }
        $body = wp_remote_retrieve_body($request);
        $data = json_decode($body);

        if (! empty($data)) {
          return $data;
        } else {
          return null;
        }
    }

    public static function create_tribute_tree($params) {
      $request_params = array('body' => $params);

      $url = "https://api.staging.firehawkcrm.com/v2/wp/tributes/create-tree";
      $request = wp_remote_post($url, $request_params);

      if (is_wp_error($request)) {
          return null;
      }
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function like_tribute_tree($params) {
      $id = $params["id"];
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/tributes/tree/" . $id . "/like";
      $request = wp_remote_post($url, $request_params);
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function unlike_tribute_tree($params) {
      $id = $params["id"];
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/tributes/tree/" . $id . "/unlike";
      $request = wp_remote_post($url, $request_params);
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function create_tribute_donation($params) {
      $request_params = array('body' => $params);

      $url = "https://2eaa-159-196-161-1.au.ngrok.io/v2/wp/tributes/create-donation";
      $request = wp_remote_post($url, $request_params);

      if (is_wp_error($request)) {
          return null;
      }
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function like_tribute_donation($params) {
      $id = $params["id"];
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/tributes/donation/" . $id . "/like";
      $request = wp_remote_post($url, $request_params);
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function unlike_tribute_donation($params) {
      $id = $params["id"];
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/tributes/donation/" . $id . "/unlike";
      $request = wp_remote_post($url, $request_params);
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function get_client_donation_info($clientId) {
      $id = $params["id"];
      $params = [];
      $fcrmTeam = get_option('fcrm_tributes_team');
      $params["teamId"] = $fcrmTeam;
      $request_params = array('body' => $params);

      $url = "https://us-central1-fcrm-e17b0.cloudfunctions.net/funeralServices/api/client/" . $clientId . "/donation-info";
      $request = wp_remote_post($url, $request_params);
      $body = wp_remote_retrieve_body($request);
      $data = json_decode($body);

      if (! empty($data)) {
        return $data;
      } else {
        return null;
      }
    }

    public static function format_service_details($client) {
      $details = "Service Details: ";

      if (isset($client->serviceDateTime)) {
          $serviceTime = new DateTime($client->serviceDateTime);
          $details .= $serviceTime->format('D j F g:i a').' ';
      }

      if (isset($client->serviceVenue)) {
        $venueName = '';
        $hasVenue = false;

        if (isset($client->serviceVenue->name)) {
          $hasVenue = true;
          $venueName .= $client->serviceVenue->name;
        }
        if (isset($client->serviceVenue->address)) {
          if ($hasVenue) {
            $venueName .= ', ';
          }
          $hasVenue = true;
          $venueName .= $client->serviceVenue->address;
        }

        if ($hasVenue) {
          $details .= 'at '. $venueName;
        }
      }

      return $details;
    }

    public static function get_stock($stockId, $teamId)
    {
        if (!isset($stockId) || !$teamId) {
          return null;
        }

        $params = array(
          "teamId" => $teamId,
          "stockId" => $stockId
        );

        $url = self::$apiUrl."/v2/wp/cart/stock?".http_build_query($params);
        $request = wp_remote_get($url);
        if (is_wp_error($request)) {
            return null;
        }
        $body = wp_remote_retrieve_body($request);
        $data = (array) json_decode($body);

        if (!isset($data)) {
          return $data;
        } else if (!empty($data)) {
          return $data;
        } else {
          return null;
        }
    }

    public static function format_dod($client) {
      if (isset($client->clientDateOfBirth) && isset($client->clientDateOfDeath)) {
          $date1 = new DateTime($client->clientDateOfBirth);
          $date2 = new DateTime($client->clientDateOfDeath);
          return $date1->format('Y') . " - " . $date2->format('Y');
      } elseif (isset($client->clientDateOfDeath)) {
          $date1 = new DateTime($client->clientDateOfDeath);
          return $date1->format('Y');
      }
    }
}
