<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       firehawkcrm.com
 * @since      1.0.0
 *
 * @package    Fcrm_Tributes
 * @subpackage Fcrm_Tributes/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Fcrm_Tributes
 * @subpackage Fcrm_Tributes/includes
 * @author     Grant Bevan <grant@firehawk.digital>
 */
class Fcrm_Tributes_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'fcrm-tributes',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
