<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              firehawkcrm.com
 * @since             1.0.0
 * @package           Fcrm_Tributes
 *
 * @wordpress-plugin
 * Plugin Name:       FireHawkCRM Tributes
 * Plugin URI:        https://firehawk.digital/services
 * Description:       Display tributes from FireHawkCRM on your website
 * Version:           1.0.53
 * Author:            Firehawk Systems
 * Author URI:        firehawk.digital
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       fcrm-tributes
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'PLUGIN_NAME_VERSION', '1.0.53' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-fcrm-tributes-activator.php
 */
function activate_fcrm_tributes() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-fcrm-tributes-activator.php';
	Fcrm_Tributes_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-fcrm-tributes-deactivator.php
 */
function deactivate_fcrm_tributes() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-fcrm-tributes-deactivator.php';
	Fcrm_Tributes_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_fcrm_tributes' );
register_deactivation_hook( __FILE__, 'deactivate_fcrm_tributes' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-fcrm-tributes.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_fcrm_tributes() {

	$plugin = new Fcrm_Tributes();
	$plugin->run();

}

function fcrm_tributes_create_detail_page_rules() {
	$outputString = '';
	$tributePageName = get_option('fcrm_tributes_single_page');

	if (!isset($tributePageName)) {
		return;
	}

	for ($i=0; $i < strlen($tributePageName); $i++) {
			$outputString = $outputString . '['. strtoupper($tributePageName[$i]) . strtolower($tributePageName[$i]) . ']';
	}

	add_rewrite_rule('' . $outputString . '/([^/]+)/?$', 'index.php?pagename=' . $tributePageName . '&id=$matches[1]', 'top');
	add_rewrite_rule('fhf_tributes_sitemap_([0-9]+)\.xml$', 'index.php?fhf_tributes_sitemap=$matches[1]', 'top');

	flush_rewrite_rules();
}

function fcrm_tributes_add_to_query_params($query_vars)
{
		$query_vars[] = 'id';
		$query_vars[] = 'fhf_tributes_sitemap';
		return $query_vars;
}

add_action('init', 'fcrm_tributes_create_detail_page_rules' );
add_action('query_vars', 'fcrm_tributes_add_to_query_params');

run_fcrm_tributes();
