<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       firehawkcrm.com
 * @since      1.0.0
 *
 * @package    Fcrm_Tributes
 * @subpackage Fcrm_Tributes/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Fcrm_Tributes
 * @subpackage Fcrm_Tributes/admin
 * @author     Grant Bevan <grant@firehawk.digital>
 */
class Fcrm_Tributes_Admin
{

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    /**
     * Register the stylesheets for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_styles()
    {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Fcrm_Tributes_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Fcrm_Tributes_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */

        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/fcrm-tributes-admin.css', array(), $this->version, 'all');
    }

    /**
     * Register the JavaScript for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts()
    {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Fcrm_Tributes_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Fcrm_Tributes_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */

        wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/fcrm-tributes-admin.js', array( 'jquery' ), $this->version, false);

        wp_enqueue_media();
    }


    /**
     * Register the settings page
     *
     * @since    1.0.0
     */
    public function add_admin_menu()
    {
        $fcrm_icon_date = "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";

        add_menu_page('FH Tributes', 'FH Tributes', 'manage_options', 'fcrm-tributes', array( $this, 'create_admin_interface' ), 'data:image/svg+xml;base64,'.$fcrm_icon_date);
    }

    /**
         * Callback function for the admin settings page.
         *
         * @since    1.0.0
         */
    public function create_admin_interface()
    {
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/partials/fcrm-tributes-admin-display.php';
    }

    /**
     * Callback function for the admin settings page.
     *
     * @since    1.0.0
     */
    public function create_general_settings_interface()
    {
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/partials/basic/general-settings-display.php';
    }

    /**
     * Updates single page permalink based plugin settings.
     *
     * @since    1.0.0
     */
    function on_single_page_setting_update($option) {
      fcrm_tributes_create_detail_page_rules();
    }

    /**
     * Creates our settings sections with fields etc.
     *
     * @since    1.0.0
     */
    public function settings_api_init()
    {

        /**
         * Sections functions
         */
        // The basic section
        add_settings_section(
                'fcrm_tributes_basic_settings_section',
                __('Settings', 'fcrm-tributes'),
                array( $this, 'setting_section_callback_function' ),
                'fcrm_tributes_settings'
            );


        /**
         * Basic settings
         */

        // Add the field with the team id
        add_settings_field(
              'fcrm_tributes_team',
              'Team ID',
              array( $this, 'team_setting_callback_function' ),
              'fcrm_tributes_settings',
              'fcrm_tributes_basic_settings_section'
          );
        
        add_settings_field(
            'fcrm_tributes_team_brand',
            'Brand ID',
            array( $this, 'text_input_setting_callback_function' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section',
            array(
                "field_key" => "fcrm_tributes_team_brand"
            )
        );

        add_settings_field(
              'fcrm_tributes_default_image',
              'Default Image URL',
              array( $this, 'team_setting_default_image' ),
              'fcrm_tributes_settings',
              'fcrm_tributes_basic_settings_section'
          );

        /**
         * Plugin settings
         */

         add_settings_field(
             'fcrm_tributes_date_format',
             'Tributes Date Format',
             array( $this, 'team_setting_date_format' ),
             'fcrm_tributes_settings',
             'fcrm_tributes_basic_settings_section'
         );

         add_settings_field(
             'fcrm_tributes_dob_format',
             'Tributes DOB Format',
             array( $this, 'team_setting_dob_format' ),
             'fcrm_tributes_settings',
             'fcrm_tributes_basic_settings_section'
         );

         add_settings_field(
            'fcrm_tributes_hide_dob',
            'Hide DOB',
            array( $this, 'checkbox_input_setting_callback_function' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section',
            array(
                "field_key" => "fcrm_tributes_hide_dob"
            )
        );

         

         add_settings_field(
            'fcrm_tributes_event_date_format',
            'Tributes Event Date Format',
            array( $this, 'team_setting_event_date_format' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section'
        );

        add_settings_field(
            'fcrm_tributes_event_end_date_format',
            'Tributes Event End Date Format',
            array( $this, 'team_setting_event_end_date_format' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section'
        );

         add_settings_field(
             'fcrm_tributes_date_locale',
             'Tributes Date Locale',
             array( $this, 'text_input_setting_callback_function' ),
             'fcrm_tributes_settings',
             'fcrm_tributes_basic_settings_section',
             array(
               "field_key" => "fcrm_tributes_date_locale"
             )
         );

        add_settings_field(
            'fcrm_tributes_single_page',
            'Tributes Single Page Location',
            array( $this, 'team_setting_tribute_page_location' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section'
        );

        add_settings_field(
            'fcrm_tributes_readable_permalinks',
            'Use human Readable Permalinks',
            array( $this, 'team_setting_human_permalinks' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section'
        );

        add_settings_field(
            'fcrm_tributes_redirect_query_parameter',
            'Tributes Query Parameter (for redirects)',
            array( $this, 'team_setting_redirect_query_parameter' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section'
        );

        add_settings_field(
            'fcrm_tributes_show_location',
            'Show service locations',
            array( $this, 'location_setting_callback_function' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section'
        );

        add_settings_field(
            'fcrm_tributes_meta_title',
            'Tribute Page Title: Description',
            array( $this, 'text_input_setting_callback_function' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section',
            array(
                "field_key" => "fcrm_tributes_meta_title"
            )
        );
        add_settings_field(
            'fcrm_tributes_meta_description',
            'Tribute Page Meta: Description',
            array( $this, 'text_input_setting_callback_function' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section',
            array(
                "field_key" => "fcrm_tributes_meta_description"
            )
        );

        add_settings_field(
            'fcrm_tributes_page_options_printing_button',
            'Tribute Page: Printing Button Label',
            array( $this, 'text_input_setting_callback_function' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section',
            array(
                "field_key" => "fcrm_tributes_page_options_printing_button"
            )
        );

        add_settings_field(
            'fcrm_tributes_contribute_page',
            'Contribute URL',
            array( $this, 'team_setting_contribute_page' ),
            'fcrm_tributes_settings',
            'fcrm_tributes_basic_settings_section'
        );



        //register basic settings
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_team');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_team_brand');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_default_image');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_date_format');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_dob_format');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_hide_dob');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_event_date_format');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_event_end_date_format');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_date_locale');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_meta_title');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_meta_description');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_single_page');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_readable_permalinks');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_show_location');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_redirect_query_parameter');
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_contribute_page');
        
        register_setting('fcrm_tributes_settings', 'fcrm_tributes_page_options_printing_button');

        


        // add_action( 'admin_init', array( $this, 'fcrm_tributess_options_setup' ) );

        if (get_option( 'fcrm_tributes_show_location' ) === false ) {
          update_option( 'fcrm_tributes_show_location', '1' );
        }
    }

    function team_setting_default_image()
    {
       ?>
       <?php $fcrmTeam = get_option('fcrm_tributes_default_image'); ?>

       <p>
       	<input type="text" id="filter-module-checkbox" name="fcrm_tributes_default_image" value="<?php echo $fcrmTeam; ?>">
       </p>
       <?php
    }

    function location_setting_callback_function()
    {
       ?>
       <?php $fcrmTeam = get_option('fcrm_tributes_show_location'); ?>

       <p>
        <input name="fcrm_tributes_show_location" type="checkbox" value="1" <?php checked( '1', get_option( 'fcrm_tributes_show_location' ) ); ?> />
       </p>
       <?php
    }

    function team_setting_human_permalinks()
    {
       ?>
       <p>
        <input name="fcrm_tributes_readable_permalinks" type="checkbox" value="1" <?php checked( '1', get_option( 'fcrm_tributes_readable_permalinks' ) ); ?> />
       </p>
       <?php
    }

    function team_setting_tribute_page_location()
    {
       ?>
       <?php $value = get_option('fcrm_tributes_single_page'); ?>

       <p>
       	<input type="text" name="fcrm_tributes_single_page" value="<?php echo $value; ?>">
       </p>
       <?php
    }

    function team_setting_date_format()
    {
       ?>
       <?php $value = get_option('fcrm_tributes_date_format'); ?>

       <p>
        <input type="text" name="fcrm_tributes_date_format" value="<?php echo $value; ?>">
       </p>
       <?php
    }

    function team_setting_event_date_format()
    {
       ?>
       <?php $value = get_option('fcrm_tributes_event_date_format'); ?>

       <p>
        <input type="text" name="fcrm_tributes_event_date_format" value="<?php echo $value; ?>">
       </p>
       <?php
    }

    function team_setting_event_end_date_format()
    {
       ?>
       <?php $value = get_option('fcrm_tributes_event_end_date_format'); ?>

       <p>
        <input type="text" name="fcrm_tributes_event_end_date_format" value="<?php echo $value; ?>">
       </p>
       <?php
    }

    function team_setting_redirect_query_parameter()
    {
       ?>
       <?php $value = get_option('fcrm_tributes_redirect_query_parameter'); ?>

       <p>
        <input type="text" name="fcrm_tributes_redirect_query_parameter" value="<?php echo $value; ?>">
       </p>
       <?php
    }

    function team_setting_contribute_page()
    {
       ?>
       <?php $value = get_option('fcrm_tributes_contribute_page'); ?>

       <p>
        <input type="text" name="fcrm_tributes_contribute_page" value="<?php echo $value; ?>">
       </p>
       <?php
    }

    function team_setting_dob_format()
    {
       ?>
       <?php $value = get_option('fcrm_tributes_dob_format'); ?>

       <p>
        <input type="text" name="fcrm_tributes_dob_format" value="<?php echo $value; ?>">
       </p>
       <?php
    }


    function team_setting_f1_affiliate_id()
    {
       ?>
       <?php $value = get_option('fcrm_tributes_f1_aff_id'); ?>

       <p>
        <input type="text" name="fcrm_tributes_f1_aff_id" value="<?php echo $value; ?>">
       </p>
       <?php
    }

    /*
     * Basic
     */

    // The basic section
    public function setting_section_callback_function()
    {
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/partials/basic/basic-section-display.php';
    }

    // Select post types
    public function api_setting_callback_function()
    {
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/partials/basic/api-settings-display.php';
    }

    // Select post types
    public function team_setting_callback_function()
    {
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/partials/basic/team-settings-display.php';
    }

    function text_input_setting_callback_function($params)
    {
       ?>
       <p>
         <input type="text" name="<?php echo $params["field_key"]; ?>" value="<?php echo get_option($params["field_key"]); ?>">
       </p>
       <?php
    }

    function checkbox_input_setting_callback_function($params)
    {
       ?>
       <p>
        <input name="<?php echo $params["field_key"]; ?>" type="checkbox" value="1" <?php checked( '1', get_option($params["field_key"]) ); ?> />
       </p>
       <?php
    }
}
